/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFileButton
extends Button {
    private ReadListenerLinkedList readListenerList;

    public ReadFileButton(final Frame frame) {
        super("Read File");
        final FileDialog fileDialog = new FileDialog(frame, "Select a Midi or jMusic file to import", 0);
        fileDialog.setFilenameFilter(new ReadFilenameFilter());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fileDialog.show();
                Score score = Read.midiOrJmWithAWTMessaging(fileDialog.getDirectory(), fileDialog.getFile(), frame);
                if (score == null) {
                    return;
                }
                if (ReadFileButton.this.readListenerList != null) {
                    score = ReadFileButton.this.readListenerList.scoreRead(score);
                    ReadFileButton.this.readListenerList.finishedReading();
                }
            }
        });
    }

    public void addReadListener(ReadListener readListener) {
        if (readListener == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(readListener);
        } else {
            this.readListenerList.add(readListener);
        }
    }

    public void removeReadListener(ReadListener readListener) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == readListener) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }
}

