/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.gui.wave.WaveFileReader;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.rt.RTLine;
import jm.music.rt.RTPhrase;
import jm.util.AudioFilePlayThread;
import jm.util.AudioRTLine;
import jm.util.Read;

public class Play
implements JMC {
    private static Vector cyclePlaying = new Vector();
    private static Thread pauseThread;
    private static Vector ms;
    private static AudioInputStream audioInputStream;
    private static Vector mixerList;
    private static boolean audioPlaying;
    private static boolean audioPaused;
    private static RTMixer mixer;
    private static MidiSynth midiSynth1;
    private static MidiSynth midiSynth2;
    private static int msCnt;

    private static void msFill(int n) {
        if (ms.size() < n) {
            for (int i = ms.size(); i < n; ++i) {
                ms.add(new MidiSynth());
            }
        }
    }

    public static boolean cycleIsPlaying() {
        return Play.cycleIsPlaying(0);
    }

    public static boolean cycleIsPlaying(int n) {
        if (cyclePlaying.size() < n + 1) {
            for (int i = cyclePlaying.size(); i < n + 1; ++i) {
                cyclePlaying.addElement(false);
            }
            cyclePlaying.add(n, false);
        }
        return (Boolean)cyclePlaying.elementAt(n);
    }

    public static void waitCycle(Score score, int n) {
        try {
            Thread.sleep((int)(60000.0 / score.getTempo() * score.getEndTime()) + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void mid(String string) {
        Score score = new Score();
        Read.midi(score, string);
        Play.midi(score);
    }

    public static void midi(Note note) {
        Play.midi(note, true);
    }

    public static void midi(Phrase phrase) {
        Play.midi(phrase, true);
    }

    public static void midi(Part part) {
        Play.midi(part, true);
    }

    public static void midi(Score score) {
        Play.midi(score, true);
    }

    public static void midi(Note note, boolean bl) {
        Score score = new Score("One note score", 60.0);
        score.addPart(new Part(new Phrase(note)));
        Play.midi(score, bl);
    }

    public static void midi(Phrase phrase, boolean bl) {
        double d = 60.0;
        if (phrase.getTempo() != -1.0) {
            d = phrase.getTempo();
        }
        Score score = new Score(phrase.getTitle() + " score", d);
        if (phrase.getTempo() != -1.0) {
            score.setTempo(phrase.getTempo());
        }
        score.addPart(new Part(phrase));
        Play.midi(score, bl);
    }

    public static void midi(Part part, boolean bl) {
        double d = 60.0;
        if (part.getTempo() != -1.0) {
            d = part.getTempo();
        }
        Score score = new Score(part.getTitle() + " score", d);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        score.addPart(part);
        Play.midi(score, bl);
    }

    public static void midi(Score score, boolean bl) {
        Play.midi(score, bl, true, 1, 0);
    }

    public static void midi(Score score, boolean bl, boolean bl2, int n, int n2) {
        System.out.println("jMusic Play: Playing score " + score.getTitle() + " using JavaSound General MIDI soundbank.");
        Play.msFill(n);
        MidiSynth midiSynth = (MidiSynth)ms.elementAt(msCnt);
        if (midiSynth.isPlaying()) {
            midiSynth.stop();
        }
        try {
            midiSynth.play(score);
            if (bl2) {
                System.out.println("jMusic Play: Waiting for the end of " + score.getTitle() + ".");
                if (bl && n2 == 0) {
                    Play.waitCycle(score, 200);
                } else {
                    Play.waitCycle(score, n2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("jMusic Play: MIDI Playback Error:" + exception);
            return;
        }
        if (bl) {
            Play.closeAll();
        }
        msCnt = (msCnt + 1) % n;
    }

    public static void updateScore(Score score) {
        Play.updateScore(score, 0);
    }

    public static void updateScore(Score score, int n) {
        try {
            ((MidiSynth)ms.elementAt(n)).updateSeq(score);
        }
        catch (Exception exception) {
            System.err.println("jMusic Play class can't update MIDI sequence:" + exception);
            return;
        }
    }

    public static void pauseAudio() {
        for (int i = 0; i < mixerList.size(); ++i) {
            ((RTMixer)mixerList.elementAt(i)).pause();
        }
        audioPaused = true;
    }

    public static void unPauseAudio() {
        if (audioPaused) {
            for (int i = 0; i < mixerList.size(); ++i) {
                ((RTMixer)mixerList.elementAt(i)).unPause();
            }
            audioPaused = false;
        } else {
            System.err.println("Play.unPauseAudio error: audio playback was not previously paused.");
        }
    }

    public static void stopAudio() {
        for (int i = 0; i < mixerList.size(); ++i) {
            ((RTMixer)mixerList.elementAt(i)).stop();
        }
        audioPaused = false;
        audioPlaying = false;
    }

    public static void stopMidi() {
        for (int i = 0; i < ms.size(); ++i) {
            Play.stopMidi(i);
        }
    }

    public static void stopMidi(int n) {
        System.out.println("jMusic Play: Stopping JavaSound MIDI playback of " + n);
        if (cyclePlaying.size() < n + 1) {
            for (int i = cyclePlaying.size(); i < n + 1; ++i) {
                cyclePlaying.addElement(false);
            }
        }
        cyclePlaying.set(n, false);
        ((MidiSynth)ms.elementAt(n)).stop();
    }

    public static void stopMidiCycle() {
        Play.stopMidiCycle(0);
    }

    public static void stopMidiCycle(int n) {
        System.out.println("jMusic Play: Stopping cycle playback at end of next sequence");
        cyclePlaying.set(n, false);
        ((MidiSynth)ms.elementAt(n)).setCycle(false);
    }

    public static void midiCycle(Note note) {
        Play.midiCycle(note, 0);
    }

    public static void midiCycle(Note note, int n) {
        Score score = new Score("One note score");
        score.addPart(new Part(new Phrase(note)));
        Play.midiCycle(score, n);
    }

    public static void midiCycle(Phrase phrase) {
        Play.midiCycle(phrase, 0);
    }

    public static void midiCycle(Phrase phrase, int n) {
        Score score = new Score(phrase.getTitle() + " score");
        score.addPart(new Part(phrase));
        Play.midiCycle(score, n);
    }

    public static void midiCycle(Part part) {
        Play.midiCycle(part, 0);
    }

    public static void midiCycle(Part part, int n) {
        Score score = new Score(part.getTitle() + " score");
        score.addPart(part);
        Play.midiCycle(score, n);
    }

    public static void midiCycle(Score score) {
        Play.midiCycle(score, 0);
    }

    public static void midiCycle(Score score, int n) {
        int n2;
        if (ms.size() < n + 1) {
            for (n2 = ms.size(); n2 < n + 1; ++n2) {
                ms.addElement(new MidiSynth());
            }
        }
        if (cyclePlaying.size() < n + 1) {
            for (n2 = cyclePlaying.size(); n2 < n + 1; ++n2) {
                cyclePlaying.addElement(false);
            }
        }
        if (((Boolean)cyclePlaying.elementAt(n)).booleanValue()) {
            Play.stopMidiCycle(n);
            ((MidiSynth)ms.elementAt(n)).stop();
        }
        cyclePlaying.set(n, true);
        System.out.println("jMusic Play: Starting cycle playback");
        try {
            ((MidiSynth)ms.elementAt(n)).play(score);
            ((MidiSynth)ms.elementAt(n)).setCycle(true);
        }
        catch (Exception exception) {
            System.err.println("MIDI Playback Error:" + exception);
            return;
        }
    }

    public static void au(String string) {
        Play.au(string, true);
    }

    public static void au(String string, boolean bl) {
        WaveFileReader waveFileReader = new WaveFileReader(string);
        RTLine[] rTLineArray = new RTLine[]{new AudioRTLine(string)};
        RTMixer rTMixer = new RTMixer(rTLineArray);
        rTMixer.begin();
        System.out.println("---------- Playing '" + string + "'... Sample rate = " + waveFileReader.getSampleRate() + " Channels = " + waveFileReader.getChannels() + " ----------");
        if (bl) {
            File file = new File(string);
            try {
                int n = waveFileReader.getBits() - 1;
                Thread.sleep((int)((double)file.length() / (double)n / (double)waveFileReader.getSampleRate() / (double)waveFileReader.getChannels() * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                System.err.println("jMusic play.au error: Thread sleeping interupted");
            }
            System.out.println("-------------------- Completed Audio Playback ----------------------");
            System.exit(0);
        }
    }

    public static void audioFile(String string) {
        try {
            audioInputStream = AudioSystem.getAudioInputStream(new File(string));
            new AudioFilePlayThread(audioInputStream).start();
            System.out.println("Playing audio file " + string);
        }
        catch (IOException iOException) {
            System.err.println("Play audioFile error: in playAudioFile(): " + iOException.getMessage());
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.err.println("Unsupported Audio File error: in Play.audioFile():" + unsupportedAudioFileException.getMessage());
        }
    }

    public static void audio(Note note, Instrument instrument) {
        Play.audio(new Phrase(note), instrument);
    }

    public static void audio(Phrase phrase, Instrument[] instrumentArray) {
        Play.audio(new Score(new Part(phrase)), instrumentArray);
    }

    public static void audio(Phrase phrase, Instrument instrument) {
        Part part = new Part(phrase);
        if (phrase.getTempo() != -1.0) {
            part.setTempo(phrase.getTempo());
        }
        Play.audio(part, new Instrument[]{instrument});
    }

    public static void audio(Part part, Instrument[] instrumentArray) {
        Score score = new Score(part);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        Play.audio(score, instrumentArray);
    }

    public static void audio(Score score, Instrument[] instrumentArray) {
        audioPlaying = true;
        System.out.print("Playing Score as Audio... ");
        for (int i = 0; i < instrumentArray.length; ++i) {
            instrumentArray[i].setOutput(1);
        }
        Vector<Phrase> vector = new Vector<Phrase>();
        for (int i = 0; i < score.size(); ++i) {
            Part part = score.getPart(i);
            for (int j = 0; j < part.size(); ++j) {
                Phrase phrase = part.getPhrase(j);
                if (phrase.getInstrument() == -1) {
                    phrase.setInstrument(part.getInstrument());
                }
                if (phrase.getTempo() == -1.0) {
                    phrase.setTempo(part.getTempo());
                }
                vector.addElement(phrase);
            }
        }
        RTLine[] rTLineArray = new RTLine[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Phrase phrase = (Phrase)vector.elementAt(i);
            rTLineArray[i] = new RTPhrase(phrase, instrumentArray[phrase.getInstrument()]);
        }
        if (mixer == null) {
            mixer = new RTMixer(rTLineArray);
            mixer.begin();
        } else {
            mixer.addLines(rTLineArray);
        }
    }

    private static void audioWait(final Score score, RTMixer rTMixer) {
        pauseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    pauseThread;
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0));
                }
                catch (Exception exception) {
                    System.out.println("jMusic Play.audioWait error in pauseThread");
                }
                System.out.println("Completed audio playback.");
                audioPaused = true;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        pauseThread.start();
    }

    public static void audioClip(String string) {
        System.out.println("-------- Playing an audio file ----------");
        System.out.println("Loading sound into memory, please wait...");
        File file = new File(string);
        try {
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            AudioClip audioClip = Applet.newAudioClip(uRL);
            System.out.println("Playing '" + string + "' ...");
            audioClip.play();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("jMusic play.au error: malformed URL or filename");
        }
        try {
            Thread.sleep((int)((double)file.length() / 2.0 / 44100.0 / 2.0 * 1000.0) + 1000);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("jMusic play.au error: Thread sleeping interupted");
        }
        System.out.println("-------------------- Completed Playback ----------------------");
        System.exit(0);
    }

    public static void closeAll() {
        audioInputStream = null;
        for (int i = 0; i < ms.size(); ++i) {
            ((MidiSynth)ms.elementAt(i)).finalize();
        }
        ms.clear();
    }

    static {
        ms = new Vector();
        mixerList = new Vector();
        audioPlaying = false;
        audioPaused = false;
        midiSynth1 = new MidiSynth();
        midiSynth2 = new MidiSynth();
        msCnt = 0;
    }
}

