/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class AdaptiveMatrix {
    private int depth;
    private Hashtable weightMatrix;
    private Hashtable countMatrix;
    private int indexRange;

    public AdaptiveMatrix(int[] nArray, int n, int n2) {
        this.countMatrix = new Hashtable();
        this.weightMatrix = new Hashtable();
        this.depth = n;
        this.indexRange = n2;
        this.calcCount(nArray);
        this.calcWeight();
    }

    public AdaptiveMatrix(String string) {
        this.read(string);
    }

    public void update(int[] nArray) {
        this.calcCount(nArray);
        this.calcWeight();
    }

    public int[] generate(int n, int[] nArray) {
        if (nArray.length != this.depth) {
            System.err.println("[WARNING] Wrong seed length for this Matrix depth");
            return null;
        }
        int[] nArray2 = new int[n];
        String string = "";
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
            nArray3[i] = nArray[i];
            string = string + nArray[i] + " ";
        }
        String string2 = string;
        if (!this.weightMatrix.containsKey(string)) {
            System.err.println("[WARNING] This seed is unavailable .. try another");
            return null;
        }
        block1: for (int i = nArray.length; i < nArray2.length; ++i) {
            if (!this.weightMatrix.containsKey(string)) {
                string = string2;
                nArray = nArray3;
            }
            double[] dArray = (double[])this.weightMatrix.get(string);
            string = "";
            for (int j = 1; j < nArray.length; ++j) {
                string = string + nArray[j] + " ";
                nArray[j - 1] = nArray[j];
            }
            double d = Math.random();
            double d2 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                if (!((d2 += dArray[j]) > d)) continue;
                nArray2[i] = j;
                string = string + j + " ";
                nArray[this.depth - 1] = j;
                continue block1;
            }
        }
        return nArray2;
    }

    public void read(String string) {
        AdaptiveMatrix adaptiveMatrix = null;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            adaptiveMatrix = (AdaptiveMatrix)objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.depth = adaptiveMatrix.getDepth();
        this.indexRange = adaptiveMatrix.getIndexRange();
        this.countMatrix = adaptiveMatrix.getCountMatrix();
        this.weightMatrix = adaptiveMatrix.getWeightMatrix();
    }

    public void write(String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void print() {
        System.out.println();
        System.out.println("MATRIX");
        System.out.println("----------------");
        Enumeration enumeration = this.weightMatrix.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            double[] dArray = (double[])this.weightMatrix.get(string);
            System.out.print(string + "\t: ");
            for (int i = 0; i < dArray.length; ++i) {
                System.out.print(" " + dArray[i]);
            }
            System.out.println();
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public Hashtable getWeightMatrix() {
        return this.weightMatrix;
    }

    public Hashtable getCountMatrix() {
        return this.countMatrix;
    }

    public int getIndexRange() {
        return this.indexRange;
    }

    private void calcCount(int[] nArray) {
        for (int i = this.depth - 1; i < nArray.length - 1; ++i) {
            String string = "";
            int[] nArray2 = new int[this.indexRange];
            int n = 0;
            int n2 = this.depth - 1;
            while (n < this.depth) {
                string = string + nArray[i - n2] + " ";
                ++n;
                --n2;
            }
            if (this.countMatrix.containsKey(string)) {
                int[] nArray3 = (int[])this.countMatrix.get(string);
                int n3 = nArray[i + 1];
                nArray3[n3] = nArray3[n3] + 1;
                this.countMatrix.put(string, nArray3);
                continue;
            }
            int n4 = nArray[i + 1];
            nArray2[n4] = nArray2[n4] + 1;
            this.countMatrix.put(string, nArray2);
        }
    }

    private void calcWeight() {
        Enumeration enumeration = this.countMatrix.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int[] nArray = (int[])this.countMatrix.get(string);
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n += nArray[i];
            }
            double[] dArray = new double[this.indexRange];
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = (double)nArray[i] / (double)n;
            }
            this.weightMatrix.put(string, dArray);
        }
    }
}

