/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import jm.JMC;
import jm.music.data.Phrase;

public class Note
implements Cloneable,
Serializable {
    public static final int DEFAULT_PITCH = 60;
    public static final double DEFAULT_RHYTHM_VALUE = 1.0;
    public static final int DEFAULT_DYNAMIC = 85;
    public static final double DEFAULT_PAN = 0.5;
    public static final double DEFAULT_DURATION_MULTIPLIER = 0.9;
    public static final double DEFAULT_ARTICULATION = 0.9;
    public static final double DEFAULT_DURATION = 0.9;
    public static final double DEFAULT_OFFSET = 0.0;
    public static final double DEFAULT_SAMPLE_START_TIME = 0.0;
    public static final int MIN_PITCH = 0;
    public static final double MIN_FREQUENCY = 1.0E-17;
    public static final double MAX_MIDI_PITCH = 127.0;
    public static final int MAX_PITCH = 127;
    public static final double MIN_RHYTHM_VALUE = 0.0;
    public static final double MAX_RHYTHM_VALUE = Double.MAX_VALUE;
    public static final int MIN_DYNAMIC = 0;
    public static final int MAX_DYNAMIC = 127;
    public static final double MIN_PAN = 0.0;
    public static final double MAX_PAN = Double.MAX_VALUE;
    public static final double MIN_DURATION = 0.0;
    public static final double MAX_DURATION = Double.MAX_VALUE;
    public static final int REST = Integer.MIN_VALUE;
    public static final boolean FREQUENCY = true;
    public static final boolean MIDI_PITCH = false;
    public static final int AMP_ENV = 0;
    public static final int PITCH_ENV = 1;
    public static final int FILTER_ENV = 2;
    public static final int PAN_ENV = 3;
    public static final String C = "C";
    public static final String G = "G";
    public static final String D = "D";
    public static final String A = "A";
    public static final String E = "E";
    public static final String B = "B";
    public static final String F_SHARP = "F#";
    public static final String C_SHARP = "C#";
    public static final String G_SHARP = "Ab";
    public static final String D_SHARP = "Eb";
    public static final String A_SHARP = "Bb";
    public static final String A_FLAT = "Ab";
    public static final String E_FLAT = "Eb";
    public static final String B_FLAT = "Bb";
    public static final String F = "F";
    private String noteString = "";
    private double pitch;
    private int dynamic;
    private double rhythmValue;
    private double pan;
    private double duration;
    private double offset;
    private double sampleStartTime;
    private boolean pitchType;
    private Phrase myPhrase = null;
    private double[][] breakPoints = new double[64][];

    public Note() {
        this(60, 1.0);
        this.pitch = 60.0;
        this.pitchType = false;
        this.rhythmValue = 1.0;
        this.dynamic = 85;
        this.pan = 0.5;
        this.duration = 0.9;
        this.offset = 0.0;
    }

    public Note(int n, double d) {
        this(n, d, 85);
    }

    public Note(int n, double d, int n2) {
        this(n, d, n2, 0.5);
    }

    public Note(int n, double d, int n2, double d2) {
        if (n < 0 && n > -2147483646) {
            System.err.println("jMusic Note constructor error: Pitch is " + n + ", it must be no less than " + 0 + " (REST = " + Integer.MIN_VALUE + ")");
            System.exit(1);
        }
        this.pitchType = false;
        this.pitch = n;
        this.rhythmValue = d;
        this.dynamic = n2 < 0 ? 0 : (n2 > 127 ? 127 : n2);
        this.pan = d2;
        this.duration = d * 0.9;
        this.offset = 0.0;
    }

    public Note(double d, double d2) {
        this(d, d2, 85);
    }

    public Note(double d, double d2, int n) {
        this(d, d2, n, 0.5);
    }

    public Note(double d, double d2, int n, double d3) {
        if (d > 1.0E-17) {
            this.pitch = d;
        } else {
            System.err.println("jMusic Note constructor error: Frequency is " + d + ", it must be greater than " + 1.0E-17 + " hertz.");
            System.exit(1);
        }
        this.pitchType = true;
        this.rhythmValue = d2;
        this.dynamic = n < 0 ? 0 : (n > 127 ? 127 : n);
        this.pan = d3;
        this.duration = d2 * 0.9;
        this.offset = 0.0;
    }

    public Note(String string) {
        this.noteString = string;
        this.setPitch(this.getPitchValue());
    }

    public boolean getPitchType() {
        return this.pitchType;
    }

    public void setPitchType(boolean bl) {
        this.pitchType = bl;
    }

    public double getFrequency() {
        double d = this.pitch;
        if (!this.pitchType && this.pitch != -2.147483648E9 && this.pitch <= 127.0 && this.pitch >= 0.0) {
            d = JMC.FRQ[(int)this.pitch];
        }
        if (this.pitch == -2.147483648E9) {
            d = -2.147483648E9;
        }
        return d;
    }

    public void setFrequency(double d) {
        try {
            this.pitch = this.pitch < 1.0E-17 ? 1.0E-17 : d;
            this.pitchType = true;
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Error setting note value: You must enter frequency values above 1.0E-17");
            System.exit(1);
        }
    }

    public int getPitch() {
        if (this.pitchType && this.pitch != -2.147483648E9) {
            System.err.println("jMusic error getting Note pitch: Pitch is a frequency - getPitch() can't be used.");
            System.exit(1);
        }
        int n = this.pitch < -2.147483646E9 ? Integer.MIN_VALUE : (int)this.pitch;
        return n;
    }

    public void setPitch(int n) {
        if (n == Integer.MIN_VALUE) {
            this.pitch = -2.147483648E9;
        } else {
            try {
                this.pitch = n < 0 ? 0.0 : ((double)n > 127.0 ? 127.0 : (double)n);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Error setting pitch value: You must enter pitch values between 0 and 127.0");
            }
        }
        this.pitchType = false;
    }

    public double getRhythmValue() {
        return this.rhythmValue;
    }

    public void setRhythmValue(double d) {
        this.rhythmValue = d < 0.0 ? 0.0 : (d > Double.MAX_VALUE ? Double.MAX_VALUE : d);
    }

    public int getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(int n) {
        this.dynamic = n < 0 ? 0 : (n > 127 ? 127 : n);
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double d) {
        this.pan = d < 0.0 ? 0.0 : (d > Double.MAX_VALUE ? Double.MAX_VALUE : d);
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double d) {
        this.duration = d < 0.0 ? 0.0 : (d > Double.MAX_VALUE ? Double.MAX_VALUE : d);
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public double getSampleStartTime() {
        return this.sampleStartTime;
    }

    public void setSampleStartTime(double d) {
        this.sampleStartTime = d;
    }

    public void setMyPhrase(Phrase phrase) {
        this.myPhrase = phrase;
    }

    public Phrase getMyPhrase() {
        return this.myPhrase;
    }

    public Note copy() {
        Note note = !this.pitchType ? new Note(this.getPitch(), this.rhythmValue, this.dynamic) : new Note(this.getFrequency(), this.rhythmValue, this.dynamic);
        note.setPan(this.pan);
        note.setDuration(this.duration);
        note.setOffset(this.offset);
        note.setSampleStartTime(this.sampleStartTime);
        note.setMyPhrase(this.myPhrase);
        for (int i = 0; i < this.breakPoints.length; ++i) {
            if (this.breakPoints[i] == null) continue;
            note.setBreakPoints(i, this.getBreakPoints(i));
        }
        return note;
    }

    public void setBreakPoints(int n, double[] dArray) {
        if (n < 0 || n > this.breakPoints.length) {
            System.err.println("jMusic Note error: BreakPoint index " + n + " is out of range when setting.");
            System.exit(1);
        }
        this.breakPoints[n] = dArray;
    }

    public double[] getBreakPoints(int n) {
        if (n < 0 || n > this.breakPoints.length) {
            System.err.println("jMusic Note error: BreakPoint index " + n + "is out of range when getting.");
            System.exit(1);
        }
        if (this.breakPoints[n] == null) {
            System.err.println("jMusic Note error: Breakpoint index " + n + " is empty.");
            System.exit(1);
        }
        return this.breakPoints[n];
    }

    public String toString() {
        String string = !this.pitchType ? new String("jMusic NOTE: [Pitch = " + (int)this.pitch + "][RhythmValue = " + this.rhythmValue + "][Dynamic = " + this.dynamic + "][Duration = " + this.duration + "][Pan = " + this.pan + "]") : new String("Note: [Frequency = " + this.pitch + "][RhythmValue = " + this.rhythmValue + "][Dynamic = " + this.dynamic + "][Duration = " + this.duration + "][Pan = " + this.pan + "]");
        return string;
    }

    public boolean isScale(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (this.pitch % 12.0 != (double)nArray[i]) continue;
            return true;
        }
        return false;
    }

    public void setRhythmValue(double d, boolean bl) {
        this.setRhythmValue(d);
        if (bl) {
            this.setDuration(d * 0.9);
        }
    }

    public static int freqToMidiPitch(double d) {
        if (d < 26.73 || d > 14496.0) {
            System.err.println("freqToMidiPitch error: Frequency " + d + " is not within the MIDI note range.");
            return -1;
        }
        double d2 = Math.pow(2.0, 0.08333333333333333);
        double d3 = Math.pow(2.0, 8.333333333333334E-4);
        int n = 0;
        int n2 = 0;
        double d4 = 440.0;
        if (d >= d4) {
            while (d > d2 * d4) {
                d4 = d2 * d4;
                ++n;
            }
            while (d > d3 * d4) {
                d4 = d3 * d4;
                ++n2;
            }
            if (d3 * d4 - d < d - d4) {
                ++n2;
            }
            if (n2 > 50) {
                ++n;
                n2 = 100 - n2;
            }
        } else {
            while (d < d4 / d2) {
                d4 /= d2;
                --n;
            }
            while (d < d4 / d3) {
                d4 /= d3;
                ++n2;
            }
            if (d - d4 / d3 < d4 - d) {
                ++n2;
            }
            if (n2 >= 50) {
                --n;
                n2 = 100 - n2;
            }
        }
        return 69 + n;
    }

    public static double midiPitchToFreq(int n) {
        if (n < 0 || n > 127) {
            System.err.println("jMusic Note.midiPitchToFreq error:midiPitch of " + n + " is out side valid range.");
            return -1.0;
        }
        double d = Math.pow(2.0, 0.08333333333333333);
        int n2 = n - 69;
        double d2 = 440.0;
        if (n > 69) {
            for (int i = 69; i < n; ++i) {
                d2 *= d;
            }
        } else {
            for (int i = 69; i > n; --i) {
                d2 /= d;
            }
        }
        d2 = (double)Math.round(d2 * 1000.0) / 1000.0;
        return d2;
    }

    public boolean isRest() {
        return this.getPitch() == Integer.MIN_VALUE;
    }

    public void setLength(double d) {
        this.setRhythmValue(d);
        this.setDuration(d * 0.9);
    }

    public boolean isSharp() {
        return this.getNote().equals(C_SHARP) || this.getNote().equals(F_SHARP);
    }

    public boolean isFlat() {
        return this.getNote().equals("Eb") || this.getNote().equals("Ab") || this.getNote().equals("Bb");
    }

    public boolean isNatural() {
        return !this.isSharp() && !this.isFlat();
    }

    public boolean samePitch(Note note) {
        return this.getPitch() == note.getPitch();
    }

    public boolean sameDuration(Note note) {
        return this.getDuration() == note.getDuration();
    }

    public boolean equals(Note note) {
        return this.samePitch(note) && this.sameDuration(note);
    }

    public Note nextNote(int[] nArray) {
        int n;
        Note note = null;
        for (n = 0; n < nArray.length; ++n) {
            if (this.getPitchValue() % 12 != 0) continue;
            note = new Note(this.getPitch() + nArray[n], 1.0);
        }
        n = this.getPitch() + nArray[1];
        System.out.println("NEXT PITCH " + n + " " + this.getPitch() + " " + nArray[1]);
        return new Note(n, 1.0);
    }

    public int getPitchValue() {
        int n = 0;
        if (this.noteString.equals(C)) {
            n = 60;
        } else if (this.noteString.equals(C_SHARP)) {
            n = 61;
        } else if (this.noteString.equals(D)) {
            n = 62;
        } else if (this.noteString.equals("Eb")) {
            n = 63;
        } else if (this.noteString.equals(E)) {
            n = 64;
        } else if (this.noteString.equals(F)) {
            n = 65;
        } else if (this.noteString.equals(F_SHARP)) {
            n = 66;
        } else if (this.noteString.equals(G)) {
            n = 67;
        } else if (this.noteString.equals("Ab")) {
            n = 68;
        } else if (this.noteString.equals(A)) {
            n = 69;
        } else if (this.noteString.equals("Bb")) {
            n = 70;
        } else if (this.noteString.equals(B)) {
            n = 71;
        }
        return n;
    }

    public String getNote() {
        this.noteString = this.getPitch() % 12 == 0 ? C : (this.getPitch() % 12 == 1 ? C_SHARP : (this.getPitch() % 12 == 2 ? D : (this.getPitch() % 12 == 3 ? "Eb" : (this.getPitch() % 12 == 4 ? E : (this.getPitch() % 12 == 5 ? F : (this.getPitch() % 12 == 6 ? F_SHARP : (this.getPitch() % 12 == 7 ? G : (this.getPitch() % 12 == 8 ? "Ab" : (this.getPitch() % 12 == 9 ? A : (this.getPitch() % 12 == 10 ? "Bb" : (this.getPitch() % 12 == 11 ? B : "N/A")))))))))));
        return this.noteString;
    }

    public static String getNote(int n) {
        String string = "";
        string = n % 12 == 0 ? C : (n % 12 == 1 ? C_SHARP : (n % 12 == 2 ? D : (n % 12 == 3 ? "Eb" : (n % 12 == 4 ? E : (n % 12 == 5 ? F : (n % 12 == 6 ? F_SHARP : (n % 12 == 7 ? G : (n % 12 == 8 ? "Ab" : (n % 12 == 9 ? A : (n % 12 == 10 ? "Bb" : (n % 12 == 11 ? B : "N/A")))))))))));
        return string;
    }
}

