/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class TempoEvent
implements Event {
    private short id = (short)16;
    private int time = 0;
    private double tempo = 60.0;

    public TempoEvent() {
        this(0, 0.0);
    }

    public TempoEvent(double d) {
        this(0, d);
    }

    public TempoEvent(int n, double d) {
        this.time = n;
        this.tempo = d;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int n) {
        this.time = n;
    }

    @Override
    public short getID() {
        return this.id;
    }

    @Override
    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(81);
        int n2 = (int)(60.0f / (float)this.tempo * 1000000.0f);
        dataOutputStream.writeByte((byte)(n2 >> 16 & 0xFF));
        dataOutputStream.writeByte((byte)(n2 >> 8 & 0xFF));
        dataOutputStream.writeByte((byte)(n2 & 0xFF));
        return (n += MidiUtil.writeVarLength(3, dataOutputStream)) + 5;
    }

    @Override
    public int read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = (n << 16) + (n2 << 8) + n3;
        this.tempo = 1000000.0f / (float)n4 * 60.0f;
        return 3;
    }

    @Override
    public Event copy() throws CloneNotSupportedException {
        TempoEvent tempoEvent;
        try {
            tempoEvent = (TempoEvent)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            tempoEvent = new TempoEvent();
        }
        return tempoEvent;
    }

    @Override
    public void print() {
        System.out.println("TempoEvent(020):             [time = " + this.time + "][tempo = " + this.tempo + "]");
    }
}

