/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class NoteOn
implements VoiceEvt,
Cloneable {
    private final short id = (short)5;
    private short pitch;
    private short velocity;
    private short midiChannel;
    private int time;

    public NoteOn() {
        this.pitch = 0;
        this.velocity = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public NoteOn(short s, short s2, short s3, int n) {
        this.pitch = s;
        this.velocity = s2;
        this.midiChannel = s3;
        this.time = n;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short s) {
        this.pitch = s;
    }

    public short getVelocity() {
        return this.velocity;
    }

    public void setVelocity(short s) {
        this.velocity = s;
    }

    @Override
    public short getMidiChannel() {
        return this.midiChannel;
    }

    @Override
    public void setMidiChannel(short s) {
        this.midiChannel = s;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int n) {
        this.time = n;
    }

    @Override
    public short getID() {
        return 5;
    }

    @Override
    public Event copy() throws CloneNotSupportedException {
        NoteOn noteOn;
        try {
            noteOn = (NoteOn)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            noteOn = new NoteOn();
        }
        return noteOn;
    }

    @Override
    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte((byte)(144 + this.midiChannel));
        dataOutputStream.writeByte((byte)this.pitch);
        dataOutputStream.writeByte((byte)this.velocity);
        return n + 3;
    }

    @Override
    public int read(DataInputStream dataInputStream) throws IOException {
        this.pitch = (short)dataInputStream.readUnsignedByte();
        this.velocity = (short)dataInputStream.readUnsignedByte();
        return 2;
    }

    @Override
    public void print() {
        System.out.println("Note On(005): [time = " + this.time + "][midiChannel = " + this.midiChannel + "][pitch = " + this.pitch + "][velocity = " + this.velocity + "]");
    }
}

