/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class MidiSynth
implements JMC,
MetaEventListener {
    private short m_ppqn;
    private Synthesizer m_synth;
    private Sequence m_seq;
    private Sequencer m_sequencer;
    private float m_currentTempo;
    private float m_masterTempo;
    private Stack m_tempoHistory;
    private double trackTempoRatio = 1.0;
    private double elementTempoRatio = 1.0;
    private String scoreTitle;
    private boolean isPlaying = false;
    private Boolean msCycle = false;
    private Boolean update = false;
    private Score updateScore;
    private static final int StopType = 47;

    public MidiSynth() {
        this(480);
    }

    public MidiSynth(short s) {
        this.m_ppqn = s;
        this.m_synth = null;
        this.m_tempoHistory = new Stack();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void play(Score score) throws InvalidMidiDataException {
        if (null == this.m_sequencer && !this.initSynthesizer()) {
            return;
        }
        this.scoreTitle = score.getTitle();
        this.m_masterTempo = (float)score.getTempo();
        if (null == this.m_seq) {
            this.m_seq = this.scoreToSeq(score);
        } else {
            Track[] trackArray = this.m_seq.getTracks();
            int n = trackArray.length;
            for (int i = 0; i < n; ++i) {
                this.m_seq.deleteTrack(trackArray[i]);
            }
            this.m_seq = this.scoreToSeq(score);
        }
        if (null != this.m_seq) {
            try {
                this.m_sequencer.open();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("MIDI System Unavailable:" + midiUnavailableException);
                return;
            }
            this.m_sequencer.setSequence(this.m_seq);
            this.m_sequencer.addMetaEventListener(this);
            this.m_sequencer.setMicrosecondPosition(0L);
            this.m_sequencer.setTempoInBPM(this.m_masterTempo);
            this.m_sequencer.start();
            this.isPlaying = true;
        }
    }

    public void updateSeq(Score score) throws InvalidMidiDataException {
        this.update = true;
        this.updateScore = score;
    }

    public void setCycle(Boolean bl) {
        this.msCycle = bl;
    }

    private void rePlay() {
        if (null == this.m_sequencer && !this.initSynthesizer()) {
            return;
        }
        if (this.update.booleanValue()) {
            block6: {
                System.out.println("Updating playback sequence");
                try {
                    this.m_seq = this.scoreToSeq(this.updateScore);
                    if (null == this.m_seq) break block6;
                    try {
                        this.m_sequencer.open();
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        System.err.println("MIDI System Unavailable:" + midiUnavailableException);
                        return;
                    }
                    this.m_sequencer.setSequence(this.m_seq);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    System.err.println("MIDISynth updating sequence error:" + invalidMidiDataException);
                    return;
                }
            }
            this.update = false;
        }
        this.m_sequencer.setMicrosecondPosition(0L);
        this.m_sequencer.setTempoInBPM(this.m_masterTempo);
        this.m_sequencer.start();
    }

    protected void printSeqInfo(Sequence sequence) {
        float f = sequence.getDivisionType();
    }

    @Override
    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            if (this.msCycle.booleanValue()) {
                this.rePlay();
            } else {
                this.stop();
            }
        }
    }

    public void stop() {
        this.msCycle = false;
        this.isPlaying = false;
        if (this.m_sequencer != null & this.m_sequencer.isOpen()) {
            this.m_sequencer.stop();
        }
        System.out.println("jMusic MidiSynth: Stopped JavaSound MIDI playback");
    }

    protected static MidiEvent createNoteOnEvent(int n, int n2, int n3, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(144 + n, n2, n3);
        MidiEvent midiEvent = new MidiEvent(shortMessage, l);
        return midiEvent;
    }

    protected static MidiEvent createNoteOffEvent(int n, int n2, int n3, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(128 + n, n2, n3);
        MidiEvent midiEvent = new MidiEvent(shortMessage, l);
        return midiEvent;
    }

    protected static MidiEvent createProgramChangeEvent(int n, int n2, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(192 + n, n2, 0);
        MidiEvent midiEvent = new MidiEvent(shortMessage, l);
        return midiEvent;
    }

    protected static MidiEvent createCChangeEvent(int n, int n2, int n3, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(176 + n, n2, n3);
        MidiEvent midiEvent = new MidiEvent(shortMessage, l);
        return midiEvent;
    }

    protected Sequence scoreToSeq(Score score) throws InvalidMidiDataException {
        Cloneable cloneable;
        Sequence sequence = new Sequence(0.0f, this.m_ppqn);
        if (null == sequence) {
            return null;
        }
        this.m_masterTempo = this.m_currentTempo = new Float(score.getTempo()).floatValue();
        Track track = null;
        double d = 0.0;
        double d2 = 1.0;
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            cloneable = (Part)enumeration.nextElement();
            int n = ((Part)cloneable).getChannel();
            if (n > 16) {
                throw new InvalidMidiDataException(((Part)cloneable).getTitle() + " - Invalid Channel Number: " + n);
            }
            this.m_tempoHistory.push(new Float(this.m_currentTempo));
            float f = new Float(((Part)cloneable).getTempo()).floatValue();
            if ((double)f != -1.0) {
                this.m_currentTempo = f;
            } else if ((double)f < -1.0) {
                System.out.println("jMusic MidiSynth error: Part TempoEvent (BPM) too low = " + f);
            }
            this.trackTempoRatio = this.m_masterTempo / this.m_currentTempo;
            int n2 = ((Part)cloneable).getInstrument();
            if (n2 == -1) {
                n2 = 0;
            }
            Enumeration enumeration2 = ((Part)cloneable).getPhraseList().elements();
            double d3 = 0.0;
            double d4 = 0.0;
            Track track2 = sequence.createTrack();
            while (enumeration2.hasMoreElements()) {
                Serializable serializable2;
                serializable = (Phrase)enumeration2.nextElement();
                d4 = ((Phrase)serializable).getStartTime();
                long l = (long)(d4 * (double)this.m_ppqn * this.trackTempoRatio);
                if (((Phrase)serializable).getInstrument() != -1) {
                    n2 = ((Phrase)serializable).getInstrument();
                }
                MidiEvent midiEvent = MidiSynth.createProgramChangeEvent(n, n2, l);
                track2.add(midiEvent);
                this.m_tempoHistory.push(new Float(this.m_currentTempo));
                f = new Float(((Phrase)serializable).getTempo()).floatValue();
                if ((double)f != -1.0) {
                    this.m_currentTempo = f;
                }
                this.elementTempoRatio = this.m_masterTempo / this.m_currentTempo;
                double d5 = -1.0;
                int n3 = 0;
                Enumeration enumeration3 = ((Phrase)serializable).getNoteList().elements();
                while (enumeration3.hasMoreElements()) {
                    serializable2 = (Note)enumeration3.nextElement();
                    n3 = (int)(((Note)serializable2).getOffset() * (double)this.m_ppqn * this.elementTempoRatio);
                    int n4 = -1;
                    n4 = !((Note)serializable2).getPitchType() ? ((Note)serializable2).getPitch() : Note.freqToMidiPitch(((Note)serializable2).getFrequency());
                    int n5 = ((Note)serializable2).getDynamic();
                    if (n4 == Integer.MIN_VALUE) {
                        l = (long)((double)l + ((Note)serializable2).getRhythmValue() * (double)this.m_ppqn * this.elementTempoRatio);
                        continue;
                    }
                    long l2 = l;
                    if (((Note)serializable2).getPan() != d5) {
                        midiEvent = MidiSynth.createCChangeEvent(n, 10, (int)(((Note)serializable2).getPan() * 127.0), l2);
                        track2.add(midiEvent);
                        d5 = ((Note)serializable2).getPan();
                    }
                    midiEvent = MidiSynth.createNoteOnEvent(n, n4, n5, l2 + (long)n3);
                    track2.add(midiEvent);
                    long l3 = (long)((double)l + ((Note)serializable2).getDuration() * (double)this.m_ppqn * this.elementTempoRatio);
                    midiEvent = MidiSynth.createNoteOffEvent(n, n4, n5, l3 + (long)n3);
                    track2.add(midiEvent);
                    l = (long)((double)l + ((Note)serializable2).getRhythmValue() * (double)this.m_ppqn * this.elementTempoRatio);
                    if (!((double)l3 > d)) continue;
                    d = l3;
                    track = track2;
                }
                serializable2 = (Float)this.m_tempoHistory.pop();
                this.m_currentTempo = ((Float)serializable2).floatValue();
            }
            serializable = (Float)this.m_tempoHistory.pop();
            this.m_currentTempo = ((Float)serializable).floatValue();
        }
        if (d > 0.0 && track != null) {
            cloneable = new MetaMessage();
            byte[] byArray = new byte[]{};
            ((MetaMessage)cloneable).setMessage(47, byArray, 0);
            MidiEvent midiEvent = new MidiEvent((MidiMessage)cloneable, (long)d);
            track.add(midiEvent);
        }
        return sequence;
    }

    private boolean initSynthesizer() {
        if (null == this.m_synth) {
            try {
                if (MidiSystem.getSequencer() == null) {
                    System.err.println("MidiSystem Sequencer Unavailable");
                    return false;
                }
                this.m_synth = MidiSystem.getSynthesizer();
                this.m_synth.open();
                this.m_sequencer = MidiSystem.getSequencer();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("Midi System Unavailable:" + midiUnavailableException);
                return false;
            }
        }
        return true;
    }

    public void finalize() {
        this.m_seq = null;
        this.m_sequencer.close();
        this.m_synth.close();
    }
}

