/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.awt.Frame;
import java.awt.List;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public abstract class MidiCommunication
implements Receiver {
    private Receiver midiReceiver;
    private boolean waitingToSetup = true;

    public MidiCommunication() {
        this.setupMidiInput();
        while (this.waitingToSetup) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public MidiCommunication(boolean bl) {
        if (bl) {
            this.setupMidiInput();
            while (this.waitingToSetup) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public MidiCommunication(int n, int n2) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        this.setMidiInputSelection(n, infoArray);
        this.setMidiOutputSelection(n2, infoArray);
    }

    public void midiSetup() {
        this.setupMidiInput();
    }

    public abstract void handleMidiInput(int var1, int var2, int var3, int var4);

    public void sendMidiOutput(int n, int n2, int n3, int n4) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(n, n2, n3, n4);
            this.midiReceiver.send(shortMessage, -1L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void send(MidiMessage midiMessage, long l) {
        byte[] byArray = midiMessage.getMessage();
        int n = midiMessage.getStatus();
        if (midiMessage instanceof ShortMessage) {
            int n2 = (byArray[0] & 0xFF) >> 4;
            int n3 = byArray[0] & 0xF;
            byte by = byArray[1];
            int n4 = -1;
            if (byArray.length > 2) {
                n4 = byArray[2];
            }
            if (n2 != 15) {
                this.handleMidiInput(n - n3, n3, by, n4);
            } else if (n == 248) {
                System.out.print("MIDI Clock message");
            } else if (n == 254) {
                System.out.print("MIDI Active sensing message");
            } else {
                System.out.print("A non-identified MIDI system message " + n);
            }
        } else if (midiMessage instanceof SysexMessage) {
            System.out.println();
            System.out.print("Sysex MIDI message <<");
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(" " + byArray[i]);
            }
            System.out.println(">>");
        } else if (midiMessage instanceof MetaMessage) {
            System.out.println();
            System.out.print("Meta MIDI Message {");
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(" " + byArray[i]);
            }
            System.out.println("}");
        } else {
            System.out.println("Unknown MIDI message [");
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(" " + byArray[i]);
            }
            System.out.println("]");
        }
    }

    @Override
    public void close() {
    }

    private void setupMidiInput() {
        try {
            final Frame frame = new Frame("MIDI Input port: Double-click to select.");
            final MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            final List list = new List();
            this.fillFrame(frame, list, infoArray);
            frame.setVisible(true);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = list.getSelectedIndex();
                        MidiCommunication.this.setMidiInputSelection(n, infoArray);
                        frame.setVisible(false);
                        MidiCommunication.this.setupMidiOutput();
                    }
                }
            };
            list.addMouseListener(mouseAdapter);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void setupMidiOutput() {
        try {
            final MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            final Frame frame = new Frame("MIDI Output port: Double-click to select.");
            final List list = new List();
            this.fillFrame(frame, list, infoArray);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = list.getSelectedIndex();
                        MidiCommunication.this.setMidiOutputSelection(n, infoArray);
                        frame.setVisible(false);
                        MidiCommunication.this.waitingToSetup = false;
                    }
                }
            };
            list.addMouseListener(mouseAdapter);
            frame.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void fillFrame(Frame frame, List list, MidiDevice.Info[] infoArray) {
        try {
            int n;
            frame.setSize(340, 200);
            frame.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 170, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 100);
            String[] stringArray = new String[infoArray.length];
            stringArray[0] = "" + infoArray[0];
            stringArray[1] = "" + infoArray[1];
            for (n = 2; n < infoArray.length; ++n) {
                stringArray[n] = MidiSystem.getMidiDevice(infoArray[n]).toString();
            }
            for (n = 0; n < infoArray.length; ++n) {
                list.add(stringArray[n]);
            }
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(list);
            frame.add(scrollPane);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void setMidiInputSelection(int n, MidiDevice.Info[] infoArray) {
        try {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            midiDevice.open();
            Transmitter transmitter = midiDevice.getTransmitter();
            transmitter.setReceiver(this);
        }
        catch (Exception exception) {
            System.out.println("Exception in PlumStone main ()");
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void setMidiOutputSelection(int n, MidiDevice.Info[] infoArray) {
        try {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            midiDevice.open();
            this.midiReceiver = midiDevice.getReceiver();
        }
        catch (Exception exception) {
            System.out.println("Exception in PlumStone main ()");
            System.out.println(exception);
            System.exit(0);
        }
    }
}

