/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;

public class WaveFileReader
implements JMC {
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private int bits;
    private String fileType;
    private boolean cache;
    private long duration;
    private InputStream is;
    private boolean wholeFile = false;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;

    public WaveFileReader(String string) {
        try {
            this.file = new File(string);
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.bits = this.format.getSampleSizeInBits() / 8;
            this.fileType = this.fileFormat.toString();
            this.is = AudioSystem.getAudioInputStream(this.file);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public float[] getSamples(int n, int n2) {
        float[] fArray = new float[n];
        try {
            this.is = AudioSystem.getAudioInputStream(this.file);
            this.is.read(new byte[n2 * this.bits]);
            byte[] byArray = new byte[this.bits * n];
            this.is.read(byArray);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                byte[] byArray2 = new byte[this.bits];
                for (int j = 0; j < this.bits; ++j) {
                    byArray2[j] = byArray[n3++];
                }
                fArray[i] = this.getFloat(byArray2);
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.out.println("jMusic WaveFileReader error: This file format is not supported.");
            System.exit(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fArray;
    }

    public int getWaveSize() {
        return (int)(this.duration / (long)this.channels);
    }

    public int getNumOfBytes() {
        return (int)(this.duration * (long)this.bits);
    }

    public int getBits() {
        return this.bits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitResolution() {
        int n = -1;
        switch (this.bits) {
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 3: {
                n = 24;
                break;
            }
            case 4: {
                n = 32;
            }
        }
        return n;
    }

    private float getFloat(byte[] byArray) {
        float f = 0.0f;
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            n |= (byArray[n3] & 0xFF) << (this.bigEndian ? n2 : n3 + 1) * 8 - 8;
            ++n3;
            --n2;
        }
        switch (this.bits) {
            case 1: {
                if (n > 127) {
                    n = ~n + 1;
                    n &= 0x7F;
                    n = ~n + 1;
                }
                f = (float)n / 127.0f;
                break;
            }
            case 2: {
                if (n > Short.MAX_VALUE) {
                    n = ~n + 1;
                    n &= Short.MAX_VALUE;
                    n = ~n + 1;
                }
                f = (float)n / 32767.0f;
                break;
            }
            case 3: {
                if (n > 0x7FFFFF) {
                    n = ~n + 1;
                    n &= 0x7FFFFF;
                    n = ~n + 1;
                }
                f = (float)n / 8388608.0f;
                break;
            }
            case 4: {
                f = (float)n / 2.1474836E9f;
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return f;
    }
}

