/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class WaveCanvas
extends Canvas {
    private float[] data;
    private int segmentSize = 0;
    private int resolution = 125;
    private int height = 200;
    private int amplitude = 1;
    public Image image = null;
    protected Graphics g;
    private boolean resized = false;
    private Color waveColor = Color.darkGray;
    private Color backgroundColor = Color.white;
    private int sampleStart = 0;
    private int waveSize;
    private boolean fastDraw = false;

    public void setData(float[] fArray) {
        this.data = fArray;
        this.segmentSize = fArray.length;
    }

    public void setResolution(int n) {
        if (n > 0) {
            this.resolution = n;
        }
        this.setFastDraw(true);
        this.repaint();
        this.setFastDraw(false);
        this.repaint();
    }

    public void setHeight(int n) {
        if (n > 0) {
            this.height = n;
        }
        this.setSize(new Dimension(600, this.height + 1));
        this.resized = true;
        this.repaint();
    }

    public void setFastDraw(boolean bl) {
        this.fastDraw = bl;
    }

    public void setAmplitude(int n) {
        if (n > 0) {
            this.amplitude = n;
        }
        this.repaint();
    }

    public void setWaveSize(int n) {
        this.waveSize = n;
    }

    public void setResized(boolean bl) {
        this.resized = bl;
        this.setFastDraw(true);
        this.repaint();
        this.setFastDraw(false);
        this.repaint();
    }

    public void toggleColor() {
        if (this.waveColor == Color.darkGray) {
            this.waveColor = Color.green;
            this.backgroundColor = Color.darkGray;
        } else {
            this.waveColor = Color.darkGray;
            this.backgroundColor = Color.white;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.setCursor(new Cursor(3));
        if (this.image == null || this.resized) {
            this.image = this.createImage(this.getSize().width, this.getSize().height);
            this.g = this.image.getGraphics();
            this.resized = false;
        }
        this.clearImage(this.g);
        int n = this.height / 2 - 1;
        this.g.setColor(Color.black);
        this.g.drawLine(0, n, this.getSize().width, n);
        int n2 = this.getSize().width * this.resolution;
        int n3 = this.data.length - this.resolution;
        this.g.setColor(this.waveColor);
        if (this.resolution == 1) {
            for (int i = 0; i < n2 && i < n3; ++i) {
                float f = this.data[i];
                this.g.drawLine(i, (int)((float)n - f * (float)n * (float)this.amplitude), i, (int)((float)n - f * (float)n * (float)this.amplitude));
            }
        } else {
            int n4 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < n2 && i < n3; i += this.resolution) {
                float f3 = this.data[i];
                if (this.fastDraw) {
                    this.g.drawLine(n4++, (int)((float)n - f3 * (float)n * (float)this.amplitude), n4, (int)((float)n - f3 * (float)n * (float)this.amplitude));
                    continue;
                }
                f = 0.0f;
                f2 = 0.0f;
                for (int j = 0; j < this.resolution; ++j) {
                    if (this.data[i + j] > f) {
                        f = this.data[i + j];
                    }
                    if (!(this.data[i + j] < f2)) continue;
                    f2 = this.data[i + j];
                }
                if (this.resolution > 8) {
                    float f4 = Math.max(f3, this.data[i + this.resolution]);
                    float f5 = Math.min(f3, this.data[i + this.resolution]);
                    if (f > 0.0f) {
                        this.g.drawLine(n4, (int)((float)n - f4 * (float)n * (float)this.amplitude), n4, (int)((float)n - f * (float)n * (float)this.amplitude));
                    }
                    if (f2 < 0.0f) {
                        this.g.drawLine(n4, (int)((float)n - f5 * (float)n * (float)this.amplitude), n4, (int)((float)n - f2 * (float)n * (float)this.amplitude));
                    }
                }
                this.g.drawLine(n4++, (int)((float)n - f3 * (float)n * (float)this.amplitude), n4, (int)((float)n - this.data[i + this.resolution] * (float)n * (float)this.amplitude));
            }
        }
        this.g.setColor(Color.lightGray);
        this.g.drawLine(0, this.height, this.getSize().width, this.height);
        graphics.drawImage(this.image, 0, 0, null);
        this.clearImage(this.g);
        this.setCursor(new Cursor(0));
    }

    private void clearImage(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(this.waveColor);
    }
}

