/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Histogram
extends Component
implements JMC {
    private Score score;
    private int maxPitchValue;
    private int maxRhythmValue;
    private int maxDynamicValue;
    private int maxPanValue;
    private int[] pitchValues;
    private int[] rhythmValues;
    private int[] dynamicValues;
    private int[] panValues;
    private Font f = new Font("Helvetica", 0, 9);
    private int barWidth = 4;
    private int lableSpace = 24;
    private int type = 0;
    private String title = "Pitch Histogram";
    private int xPos = 0;
    private int yPos = 0;

    public Histogram(Score score) {
        this(score, 0);
    }

    public Histogram(Score score, int n) {
        this(score, n, 0, 0);
    }

    public Histogram(Score score, int n, int n2, int n3) {
        this(score, n, n2, n3, 200);
    }

    public Histogram(Score score, int n, int n2, int n3, int n4) {
        this.score = score;
        this.type = n;
        this.xPos = n2;
        this.yPos = n3;
        if (n == 1) {
            this.title = "Rhythm Histogram";
        }
        if (n == 2) {
            this.title = "Dynamic Histogram";
        }
        if (n == 3) {
            this.title = "Pan Histogram";
        }
        this.setSize(n4, this.barWidth * 127 + this.lableSpace);
        this.analysis();
    }

    private void analysis() {
        this.pitchValues = new int[128];
        this.rhythmValues = new int[66];
        this.dynamicValues = new int[127];
        this.panValues = new int[100];
        this.maxPitchValue = 0;
        this.maxRhythmValue = 0;
        this.maxDynamicValue = 0;
        this.maxPanValue = 0;
        Enumeration enumeration = this.score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Enumeration enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                while (enumeration3.hasMoreElements()) {
                    int n;
                    Note note = (Note)enumeration3.nextElement();
                    if (note.getPitchType() || note.getPitch() == Integer.MIN_VALUE) continue;
                    int n2 = note.getPitch();
                    this.pitchValues[n2] = this.pitchValues[n2] + 1;
                    if (this.pitchValues[note.getPitch()] > this.maxPitchValue) {
                        this.maxPitchValue = this.pitchValues[note.getPitch()];
                    }
                    if ((n = (int)(note.getRhythmValue() / 0.125)) >= this.rhythmValues.length) {
                        n = this.rhythmValues.length - 1;
                    }
                    int n3 = n;
                    this.rhythmValues[n3] = this.rhythmValues[n3] + 1;
                    if (this.rhythmValues[n] > this.maxRhythmValue) {
                        this.maxRhythmValue = this.rhythmValues[n];
                    }
                    int n4 = note.getDynamic();
                    this.dynamicValues[n4] = this.dynamicValues[n4] + 1;
                    if (this.dynamicValues[note.getDynamic()] > this.maxDynamicValue) {
                        this.maxDynamicValue = this.dynamicValues[note.getDynamic()];
                    }
                    int n5 = (int)(note.getPan() * 100.0);
                    this.panValues[n5] = this.panValues[n5] + 1;
                    if (this.panValues[(int)(note.getPan() * 100.0)] <= this.maxPanValue) continue;
                    this.maxPanValue = this.panValues[(int)(note.getPan() * 100.0)];
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setType(int n) {
        this.type = n;
        this.repaint();
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setScore(Score score) {
        this.score = score;
        this.analysis();
        this.repaint();
    }

    public void saveData() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save histogram data as...", 1);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.saveDataAs(fileDialog.getDirectory() + string);
        }
    }

    public void saveDataAs(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            String string2 = "Pitch value" + String.valueOf("\t") + "Pitch data" + String.valueOf("\t") + "Rhythm value" + String.valueOf("\t") + "Rhythm data" + String.valueOf("\t") + "Dynamic value" + String.valueOf("\t") + "Dynamic data" + String.valueOf("\t") + "Pan value" + String.valueOf("\t") + "Pan data" + String.valueOf("\n");
            fileOutputStream.write(string2.getBytes());
            for (int i = 0; i < this.pitchValues.length; ++i) {
                String string3 = String.valueOf(i) + String.valueOf("\t") + String.valueOf(this.pitchValues[i]);
                if (i < this.rhythmValues.length) {
                    string3 = string3 + String.valueOf("\t") + String.valueOf((double)i * 0.125) + String.valueOf("\t") + String.valueOf(this.rhythmValues[i]);
                }
                if (i < this.dynamicValues.length) {
                    string3 = string3 + String.valueOf("\t") + String.valueOf(i) + String.valueOf("\t") + String.valueOf(this.dynamicValues[i]);
                }
                if (i < this.panValues.length) {
                    string3 = string3 + String.valueOf("\t") + String.valueOf((double)i / 100.0) + String.valueOf("\t") + String.valueOf(this.panValues[i]);
                }
                string3 = string3 + String.valueOf("\n");
                fileOutputStream.write(string3.getBytes());
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.f);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        int n = fontMetrics.getAscent() / 2;
        int n2 = 0;
        if (this.type == 0) {
            n2 = this.maxPitchValue;
        } else if (this.type == 1) {
            n2 = this.maxRhythmValue;
        } else if (this.type == 2) {
            n2 = this.maxDynamicValue;
        } else if (this.type == 3) {
            n2 = this.maxPanValue;
        }
        for (int i = 0; i < 5; ++i) {
            graphics.setColor(Color.green);
            String string = "" + n2 / 4 * i;
            graphics.drawString(string, this.getSize().width / 5 * i + this.lableSpace - fontMetrics.stringWidth(string) / 2, this.lableSpace - fontMetrics.getAscent() / 2);
            graphics.setColor(Color.gray);
            graphics.drawLine(this.getSize().width / 5 * i + this.lableSpace, this.lableSpace, this.getSize().width / 5 * i + this.lableSpace, this.getSize().height);
        }
        switch (this.type) {
            case 0: {
                this.paintPitches(graphics);
                break;
            }
            case 1: {
                this.paintRhythms(graphics);
                break;
            }
            case 2: {
                this.paintDynamics(graphics);
                break;
            }
            case 3: {
                this.paintPans(graphics);
            }
        }
    }

    private void paintPitches(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        int n = fontMetrics.getAscent() / 2;
        for (int i = 0; i < 127; ++i) {
            if (i % 12 == 0) {
                graphics.setColor(Color.red);
            } else if (i % 12 == 4) {
                graphics.setColor(Color.orange);
            } else if (i % 12 == 7) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.pitchValues[i] / (double)this.maxPitchValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 12 == 0) {
                graphics.setColor(Color.red);
                graphics.drawString("C" + (i / 12 - 1), 2, i * this.barWidth + n + this.lableSpace);
            }
            if (i % 12 == 4) {
                graphics.setColor(Color.orange);
                graphics.drawString("E" + (i / 12 - 1), 2, i * this.barWidth + n + this.lableSpace);
            }
            if (i % 12 != 7) continue;
            graphics.setColor(Color.blue);
            graphics.drawString("G" + (i / 12 - 1), 2, i * this.barWidth + n + this.lableSpace);
        }
    }

    private void paintRhythms(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        int n = fontMetrics.getAscent();
        for (int i = 1; i < 65; ++i) {
            if (i % 8 == 0) {
                graphics.setColor(Color.red);
            } else if (i % 8 == 4) {
                graphics.setColor(Color.orange);
            } else if (i % 8 == 2 || i % 8 == 6) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.fillRect(this.lableSpace, i * this.barWidth * 2 + this.lableSpace, (int)((double)this.rhythmValues[i] / (double)this.maxRhythmValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth * 2 - 1);
            if (i % 8 == 0) {
                graphics.setColor(Color.red);
                graphics.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + n + this.lableSpace);
            }
            if (i % 8 == 4) {
                graphics.setColor(Color.orange);
                graphics.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + n + this.lableSpace);
            }
            if (i % 8 != 2 && i % 8 != 6) continue;
            graphics.setColor(Color.blue);
            graphics.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + n + this.lableSpace);
        }
    }

    private void paintDynamics(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        int n = fontMetrics.getAscent() / 2;
        for (int i = 1; i < 127; ++i) {
            if (i % 10 == 0) {
                graphics.setColor(Color.red);
            } else if (i % 10 == 5) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.dynamicValues[i] / (double)this.maxDynamicValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 10 == 0) {
                graphics.setColor(Color.red);
                graphics.drawString("" + i, 2, i * this.barWidth + n + this.lableSpace);
            }
            if (i % 10 != 5) continue;
            graphics.setColor(Color.orange);
            graphics.drawString("" + i, 2, i * this.barWidth + n + this.lableSpace);
        }
    }

    private void paintPans(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        int n = fontMetrics.getAscent() / 2;
        for (int i = 1; i < 100; ++i) {
            if (i % 10 == 0 && i != 50) {
                graphics.setColor(Color.red);
            } else if (i % 10 == 5 && i != 50) {
                graphics.setColor(Color.orange);
            } else if (i == 50) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.panValues[i] / (double)this.maxPanValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 10 == 0 && i != 50) {
                graphics.setColor(Color.red);
                graphics.drawString("" + (double)i / 100.0, 2, i * this.barWidth + n + this.lableSpace);
                continue;
            }
            if (i % 10 == 5 && i != 50) {
                graphics.setColor(Color.orange);
                graphics.drawString("" + (double)i / 100.0, 2, i * this.barWidth + n + this.lableSpace);
                continue;
            }
            if (i != 50) continue;
            graphics.setColor(Color.blue);
            graphics.drawString("" + (double)i / 100.0, 2, i * this.barWidth + n + this.lableSpace);
        }
    }
}

