/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.helper;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.JMC;
import jm.audio.Instrument;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.View;
import jm.util.Write;

public class HelperGUI
extends Frame
implements JMC,
ActionListener,
AdjustmentListener {
    protected Score score = new Score();
    private Button composeBtn;
    private Button playBtn;
    private Button stopBtn;
    private Button showBtn;
    private Button sketchBtn;
    private Button histogramBtn;
    private Button printBtn;
    private Button saveBtn;
    private Button renderBtn;
    private Button notateBtn;
    private Button readMidiBtn;
    private Button audioViewBtn;
    private Button audioPlayBtn;
    private Button audioStopBtn;
    private Button xmlOpenBtn;
    private Button xmlSaveBtn;
    private Scrollbar sliderA;
    private Scrollbar sliderB;
    private Scrollbar sliderC;
    private Scrollbar sliderD;
    private Scrollbar sliderE;
    private Label labelA;
    private Label labelB;
    private Label labelC;
    private Label labelD;
    private Label labelE;
    private Label commentLabA;
    private Label commentLabB;
    private Label commentLabC;
    private Label commentLabD;
    private Label commentLabE;
    protected Instrument[] insts;
    protected int variableA;
    protected int variableB;
    protected int variableC;
    protected int variableD;
    protected int variableE;
    private MidiSynth ms = new MidiSynth();
    private boolean playing = false;
    protected String audioFileName;
    protected Panel sliders;

    public HelperGUI() {
        super("jMusic Helper GUI");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        this.add((Component)panel, "Center");
        this.sliders = new Panel();
        this.sliders.setLayout(new GridLayout(6, 1));
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        Panel panel5 = new Panel(new BorderLayout());
        Panel panel6 = new Panel();
        Panel panel7 = new Panel();
        Panel panel8 = new Panel(new BorderLayout());
        Panel panel9 = new Panel(new BorderLayout());
        Panel panel10 = new Panel(new BorderLayout());
        Label label = new Label("Create and View");
        label.setAlignment(1);
        panel2.add((Component)label, "North");
        panel.add((Component)panel2, "North");
        Label label2 = new Label("MIDI Options");
        label2.setAlignment(1);
        panel5.add((Component)label2, "North");
        panel.add((Component)panel5, "Center");
        Label label3 = new Label("Audio Options");
        label3.setAlignment(1);
        panel8.add((Component)label3, "North");
        panel.add((Component)panel8, "South");
        Panel panel11 = new Panel(new BorderLayout());
        Label label4 = new Label("XML Options");
        label4.setAlignment(1);
        panel9.add((Component)label4, "North");
        panel11.add((Component)panel9, "North");
        Label label5 = new Label("Compositional parameters");
        label5.setAlignment(1);
        Panel panel12 = new Panel();
        panel12.add(label5);
        panel10.add((Component)panel12, "North");
        panel11.add((Component)panel10, "Center");
        this.add((Component)panel11, "South");
        Panel panel13 = new Panel(new GridLayout(3, 1));
        this.composeBtn = new Button("Compose");
        this.composeBtn.addActionListener(this);
        Panel panel14 = new Panel();
        panel14.add(this.composeBtn);
        panel13.add(panel14);
        this.showBtn = new Button("View.show()");
        this.showBtn.addActionListener(this);
        this.showBtn.setEnabled(false);
        panel3.add(this.showBtn);
        this.notateBtn = new Button("View.notate()");
        this.notateBtn.addActionListener(this);
        this.notateBtn.setEnabled(false);
        panel3.add(this.notateBtn);
        this.printBtn = new Button("View.print()");
        this.printBtn.addActionListener(this);
        this.printBtn.setEnabled(false);
        panel3.add(this.printBtn);
        panel13.add(panel3);
        this.sketchBtn = new Button("View.sketch()");
        this.sketchBtn.addActionListener(this);
        this.sketchBtn.setEnabled(false);
        panel4.add(this.sketchBtn);
        this.histogramBtn = new Button("View.histogram()");
        this.histogramBtn.addActionListener(this);
        this.histogramBtn.setEnabled(false);
        panel4.add(this.histogramBtn);
        panel13.add(panel4);
        panel2.add((Component)panel13, "Center");
        Panel panel15 = new Panel(new GridLayout(2, 1));
        this.playBtn = new Button("Play.midi()");
        this.playBtn.addActionListener(this);
        this.playBtn.setEnabled(false);
        panel7.add(this.playBtn);
        this.stopBtn = new Button("Stop MIDI");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        panel7.add(this.stopBtn);
        panel15.add(panel7);
        this.saveBtn = new Button("Write.midi()");
        this.saveBtn.addActionListener(this);
        this.saveBtn.setEnabled(false);
        panel6.add(this.saveBtn);
        this.readMidiBtn = new Button("Read.midi()");
        this.readMidiBtn.addActionListener(this);
        this.readMidiBtn.setEnabled(true);
        panel6.add(this.readMidiBtn);
        panel15.add(panel6);
        panel5.add((Component)panel15, "Center");
        Panel panel16 = new Panel();
        this.renderBtn = new Button("Write.au()");
        this.renderBtn.addActionListener(this);
        this.renderBtn.setEnabled(false);
        panel16.add(this.renderBtn);
        panel8.add((Component)panel16, "Center");
        this.audioViewBtn = new Button("View.au()");
        this.audioViewBtn.addActionListener(this);
        this.audioViewBtn.setEnabled(false);
        panel16.add(this.audioViewBtn);
        this.audioPlayBtn = new Button("Play.au()");
        this.audioPlayBtn.addActionListener(this);
        this.audioPlayBtn.setEnabled(false);
        panel16.add(this.audioPlayBtn);
        Panel panel17 = new Panel();
        this.xmlOpenBtn = new Button("Read.xml()");
        this.xmlOpenBtn.addActionListener(this);
        this.xmlOpenBtn.setEnabled(true);
        panel17.add(this.xmlOpenBtn);
        this.xmlSaveBtn = new Button("Write.xml()");
        this.xmlSaveBtn.addActionListener(this);
        this.xmlSaveBtn.setEnabled(false);
        panel17.add(this.xmlSaveBtn);
        panel9.add((Component)panel17, "Center");
        Panel panel18 = new Panel(new GridLayout(1, 3));
        this.labelA = new Label(" variableA = 0");
        panel18.add(this.labelA);
        this.sliderA = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderA.addAdjustmentListener(this);
        panel18.add(this.sliderA);
        this.commentLabA = new Label(" No Comment ");
        panel18.add(this.commentLabA);
        this.sliders.add(panel18);
        Panel panel19 = new Panel(new GridLayout(1, 3));
        this.labelB = new Label(" variableB = 0");
        panel19.add(this.labelB);
        this.sliderB = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderB.addAdjustmentListener(this);
        panel19.add(this.sliderB);
        this.commentLabB = new Label(" No Comment ");
        panel19.add(this.commentLabB);
        this.sliders.add(panel19);
        Panel panel20 = new Panel(new GridLayout(1, 3));
        this.labelC = new Label(" variableC = 0");
        panel20.add(this.labelC);
        this.sliderC = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderC.addAdjustmentListener(this);
        panel20.add(this.sliderC);
        this.commentLabC = new Label(" No Comment ");
        panel20.add(this.commentLabC);
        this.sliders.add(panel20);
        Panel panel21 = new Panel(new GridLayout(1, 3));
        this.labelD = new Label(" variableD = 0");
        panel21.add(this.labelD);
        this.sliderD = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderD.addAdjustmentListener(this);
        panel21.add(this.sliderD);
        this.commentLabD = new Label(" No Comment ");
        panel21.add(this.commentLabD);
        this.sliders.add(panel21);
        Panel panel22 = new Panel(new GridLayout(1, 3));
        this.labelE = new Label(" variableE = 0");
        panel22.add(this.labelE);
        this.sliderE = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderE.addAdjustmentListener(this);
        panel22.add(this.sliderE);
        this.commentLabE = new Label(" No Comment ");
        panel22.add(this.commentLabE);
        this.sliders.add(panel22);
        Label label6 = new Label(" ");
        this.sliders.add(label6);
        panel10.add((Component)this.sliders, "Center");
        this.pack();
        this.setSize(new Dimension(350, 510));
        this.setVisible(true);
        this.composeBtn.requestFocus();
    }

    public void setVariableA(int n) {
        this.setVariableA(n, "No Comment");
    }

    public void setVariableA(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderA.setValue(n);
            this.labelA.setText(" variableA = " + n + "  ");
            this.variableA = n;
        }
        if (string.length() > 18) {
            this.commentLabA.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabA.setText(" " + string + " ");
        }
    }

    public void setVariableB(int n) {
        this.setVariableB(n, "No Comment");
    }

    public void setVariableB(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderB.setValue(n);
            this.labelB.setText(" variableB = " + n + "  ");
            this.variableB = n;
        }
        if (string.length() > 18) {
            this.commentLabB.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabB.setText(" " + string + " ");
        }
    }

    public void setVariableC(int n) {
        this.setVariableC(n, "No Comment");
    }

    public void setVariableC(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderC.setValue(n);
            this.labelC.setText(" variableC = " + n + "  ");
            this.variableC = n;
        }
        if (string.length() > 18) {
            this.commentLabC.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabC.setText(" " + string + " ");
        }
    }

    public void setVariableD(int n) {
        this.setVariableD(n, "No Comment");
    }

    public void setVariableD(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderD.setValue(n);
            this.labelD.setText(" variableD = " + n + "  ");
            this.variableD = n;
        }
        if (string.length() > 18) {
            this.commentLabD.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabD.setText(" " + string + " ");
        }
    }

    public void setVariableE(int n) {
        this.setVariableE(n, "No Comment");
    }

    public void setVariableE(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderE.setValue(n);
            this.labelE.setText(" variableE = " + n + "  ");
            this.variableE = n;
        }
        if (string.length() > 18) {
            this.commentLabE.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabE.setText(" " + string + " ");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.composeBtn) {
            this.composeScore();
        }
        if (actionEvent.getSource() == this.playBtn) {
            this.playScore();
        }
        if (actionEvent.getSource() == this.stopBtn) {
            this.stopScore();
        }
        if (actionEvent.getSource() == this.showBtn) {
            this.showScore();
        }
        if (actionEvent.getSource() == this.notateBtn) {
            this.notateScore();
        }
        if (actionEvent.getSource() == this.printBtn) {
            this.printScore();
        }
        if (actionEvent.getSource() == this.sketchBtn) {
            this.sketchScore();
        }
        if (actionEvent.getSource() == this.histogramBtn) {
            this.histogramScore();
        }
        if (actionEvent.getSource() == this.saveBtn) {
            this.saveScore();
        }
        if (actionEvent.getSource() == this.readMidiBtn) {
            this.openMidi();
        }
        if (actionEvent.getSource() == this.renderBtn) {
            this.renderScore();
        }
        if (actionEvent.getSource() == this.audioViewBtn) {
            this.viewAudio();
        }
        if (actionEvent.getSource() == this.audioPlayBtn) {
            this.playAudio();
        }
        if (actionEvent.getSource() == this.audioStopBtn) {
            this.stopAudio();
        }
        if (actionEvent.getSource() == this.xmlOpenBtn) {
            this.xmlOpen();
        }
        if (actionEvent.getSource() == this.xmlSaveBtn) {
            this.xmlSave();
        }
    }

    private void composeScore() {
        this.score = this.compose();
        this.makeBtnsVisible();
    }

    private void makeBtnsVisible() {
        this.playBtn.setEnabled(true);
        this.stopBtn.setEnabled(true);
        this.showBtn.setEnabled(true);
        this.notateBtn.setEnabled(true);
        this.printBtn.setEnabled(true);
        this.sketchBtn.setEnabled(true);
        this.histogramBtn.setEnabled(true);
        this.saveBtn.setEnabled(true);
        this.xmlSaveBtn.setEnabled(true);
        if (this.insts != null) {
            this.renderBtn.setEnabled(true);
        }
    }

    protected Score compose() {
        Phrase phrase = new Phrase();
        Score score = new Score(new Part(phrase));
        Note note = new Note(48 + (int)(Math.random() * (double)this.variableA), 0.5 + (double)this.variableB * 0.25);
        phrase.addNote(note);
        return score;
    }

    private void playScore() {
        if (this.playing) {
            this.ms.stop();
        }
        try {
            this.ms.play(this.score);
            this.playing = true;
        }
        catch (Exception exception) {
            System.err.println("JavaSound MIDI Playback Error:" + exception);
            return;
        }
    }

    private void stopScore() {
        if (this.playing) {
            this.ms.stop();
            this.playing = false;
        }
    }

    private void showScore() {
        View.show(this.score, this.getSize().width + 15, 0);
    }

    private void notateScore() {
        View.notate(this.score, this.getSize().width + 15, 0);
    }

    private void printScore() {
        View.print(this.score);
    }

    private void histogramScore() {
        View.histogram(this.score, 0, this.getSize().width + 15, 0);
    }

    private void sketchScore() {
        View.sketch(this.score, this.getSize().width + 15, 0);
    }

    public void saveScore() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as a MIDI file...", 1);
        fileDialog.setFile("FileName.mid");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.midi(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void openMidi() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a MIDI file to import...", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Read.midi(this.score, fileDialog.getDirectory() + string);
            this.makeBtnsVisible();
        }
    }

    private void renderScore() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as an audio file...", 1);
        fileDialog.setFile("FileName.au");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.audioFileName = fileDialog.getDirectory() + fileDialog.getFile();
            Write.au(this.score, this.audioFileName, this.insts);
        }
        this.audioViewBtn.setEnabled(true);
        this.audioPlayBtn.setEnabled(true);
    }

    private void viewAudio() {
        View.au(this.audioFileName, this.getSize().width + 5, 0);
    }

    private void playAudio() {
        Play.au(this.audioFileName, false);
    }

    private void stopAudio() {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sliderA) {
            this.labelA.setText(" variableA = " + this.sliderA.getValue());
            this.variableA = new Integer(this.sliderA.getValue());
        } else if (adjustmentEvent.getSource() == this.sliderB) {
            this.labelB.setText(" variableB = " + this.sliderB.getValue());
            this.variableB = new Integer(this.sliderB.getValue());
        } else if (adjustmentEvent.getSource() == this.sliderC) {
            this.labelC.setText(" variableC = " + this.sliderC.getValue());
            this.variableC = new Integer(this.sliderC.getValue());
        } else if (adjustmentEvent.getSource() == this.sliderD) {
            this.labelD.setText(" variableD = " + this.sliderD.getValue());
            this.variableD = new Integer(this.sliderD.getValue());
        } else if (adjustmentEvent.getSource() == this.sliderE) {
            this.labelE.setText(" variableE = " + this.sliderE.getValue());
            this.variableE = new Integer(this.sliderE.getValue());
        }
    }

    private void xmlSave() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.xml(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    private void xmlOpen() {
        Read.xml(this.score);
        this.makeBtnsVisible();
    }
}

