/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Statistics
implements Cloneable,
Serializable {
    private double[] elementData;
    private double largestValue = 0.0;
    private int size;

    public Statistics(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new double[n];
    }

    public Statistics() {
        this(100);
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.size < n) {
            double[] dArray = this.elementData;
            this.elementData = new double[this.size];
            System.arraycopy(dArray, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            double[] dArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new double[n3];
            System.arraycopy(dArray, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public double largestValue() {
        return this.largestValue;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(double d) {
        return this.indexOf(d) >= 0;
    }

    public int indexOf(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (d != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (d != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            Statistics statistics = (Statistics)super.clone();
            statistics.elementData = new double[this.size];
            System.arraycopy(this.elementData, 0, statistics.elementData, 0, this.size);
            return statistics;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        System.arraycopy(this.elementData, 0, dArray, 0, this.size);
        return dArray;
    }

    public double[] toArray(double[] dArray) {
        if (dArray.length < this.size) {
            dArray = new double[this.size];
        }
        System.arraycopy(this.elementData, 0, dArray, 0, this.size);
        if (dArray.length > this.size) {
            dArray[this.size] = 0.0;
        }
        return dArray;
    }

    public double resetLargestValue() {
        this.largestValue = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.get(i) > this.largestValue)) continue;
            this.largestValue = this.get(i);
        }
        return this.largestValue;
    }

    public double get(int n) {
        this.rangeCheck(n);
        return this.elementData[n];
    }

    public double set(int n, double d) {
        this.rangeCheck(n);
        double d2 = this.elementData[n];
        this.elementData[n] = d;
        if (d2 == this.largestValue) {
            this.resetLargestValue();
        } else if (d > this.largestValue) {
            this.largestValue = d2;
        }
        return d2;
    }

    public boolean add(double d) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = d;
        if (d > this.largestValue) {
            this.largestValue = d;
        }
        return true;
    }

    public boolean add(double[] dArray) {
        this.ensureCapacity(this.size + dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.elementData[this.size++] = dArray[i];
            if (!(dArray[i] > this.largestValue)) continue;
            this.largestValue = dArray[i];
        }
        return true;
    }

    public void add(int n, double d) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = d;
        ++this.size;
        if (d > this.largestValue) {
            this.largestValue = d;
        }
    }

    public double removeIndex(int n) {
        this.rangeCheck(n);
        double d = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = 0.0;
        return d;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0.0;
        }
        this.size = 0;
    }

    protected void removeRange(int n, int n2) {
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = 0.0;
        }
    }

    private void rangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeDouble(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new double[n];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = objectInputStream.readDouble();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Statistics)) {
            return false;
        }
        Statistics statistics = (Statistics)object;
        if (this.size == statistics.size()) {
            for (int i = 0; i < this.size; ++i) {
                double d;
                double d2 = this.get(i);
                if (d2 == (d = statistics.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean removeValue(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (d != this.get(i)) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(this.get(i)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

