/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jm.gui.graph.Statistics;
import jm.gui.graph.StatisticsList;

public abstract class GraphCanvas
extends Canvas {
    protected StatisticsList statsList;
    protected Image image;
    protected Graphics graphics;
    protected Dimension preferredSize = new Dimension(1, 1);
    protected Dimension minimumSize = new Dimension(1, 1);

    public GraphCanvas() {
        this(new Statistics());
    }

    public GraphCanvas(Statistics statistics) {
        this.statsList = new StatisticsList();
        this.statsList.add(statistics);
    }

    public GraphCanvas(Statistics[] statisticsArray) {
        this.statsList = new StatisticsList(statisticsArray.length * 110 / 100);
        for (int i = 0; i < statisticsArray.length; ++i) {
            this.statsList.add(statisticsArray[i]);
        }
    }

    public GraphCanvas(StatisticsList statisticsList) {
        this.statsList = statisticsList;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void addStatistics(Statistics statistics) {
        this.statsList.add(statistics);
    }

    protected abstract void paintBuffer();

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.image = this.createImage(1, 1);
            this.graphics = this.image.getGraphics();
        }
        this.paintBuffer();
        graphics.drawImage(this.image, 0, 0, this);
    }
}

