/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import jm.music.data.Note;

public class NoteEditor
extends Dialog
implements ActionListener,
WindowListener {
    private Button okButton = new Button("Apply");
    private Button cancelButton = new Button("Cancel");
    private Note note;
    private List noteList;
    private List octaveList;
    private TextField durationEdit = new TextField(15);
    private TextField dynamicEdit = new TextField(15);
    private TextField rhythmEdit = new TextField(15);
    private TextField panEdit = new TextField(15);
    private TextField offsetEdit = new TextField(15);
    private Label noteLabel = new Label("Note");
    private Label dynamicLabel = new Label("Volume (1-127)");
    private Label rhythmLabel = new Label("Rhythm Value");
    private Label durationLabel = new Label("Duration Factor");
    private Label panLabel = new Label("Pan");
    private Label offsetLabel = new Label("Offset");
    private Label octaveLabel = new Label("Octave");
    private static DecimalFormat decimalFormat = new DecimalFormat("###.###########");

    public NoteEditor(Frame frame) {
        super(frame, "Edit Note", true);
        this.initializeLists();
        this.placeControls();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    private static String getOctaveStringValue(int n) {
        int n2 = -1;
        for (int i = n; i > 11; i -= 12) {
            ++n2;
        }
        return new Integer(n2).toString();
    }

    private static String getPitchStringValue(int n) {
        int n2;
        if (n == Integer.MIN_VALUE) {
            return "Rest";
        }
        for (n2 = n; n2 >= 12; n2 -= 12) {
        }
        switch (n2) {
            case 0: {
                return "C";
            }
            case 1: {
                return "C#";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "D#";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "F#";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "G#";
            }
            case 9: {
                return "A";
            }
            case 10: {
                return "A#";
            }
            case 11: {
                return "B";
            }
        }
        return "Rest";
    }

    private static void setListToMatch(List list, String string) {
        for (int i = list.getItemCount() - 1; i >= 0; --i) {
            if (!list.getItem(i).equals(string)) continue;
            list.select(i);
        }
    }

    private void initializeNoteListValue(int n) {
        NoteEditor.setListToMatch(this.noteList, NoteEditor.getPitchStringValue(n));
    }

    private void initializeOctaveListValue(int n) {
        NoteEditor.setListToMatch(this.octaveList, NoteEditor.getOctaveStringValue(n));
    }

    private static void initializeDoubleEdit(TextField textField, double d) {
        textField.setText(decimalFormat.format(d));
    }

    private static void initializeIntEdit(TextField textField, int n) {
        textField.setText(new Integer(n).toString());
    }

    private void initializeData() {
        this.initializeNoteListValue(this.note.getPitch());
        this.initializeOctaveListValue(this.note.getPitch());
        NoteEditor.initializeDoubleEdit(this.durationEdit, this.note.getDuration() / this.note.getRhythmValue());
        NoteEditor.initializeDoubleEdit(this.rhythmEdit, this.note.getRhythmValue());
        NoteEditor.initializeDoubleEdit(this.offsetEdit, this.note.getOffset());
        NoteEditor.initializeDoubleEdit(this.panEdit, this.note.getPan());
        NoteEditor.initializeIntEdit(this.dynamicEdit, this.note.getDynamic());
    }

    public void editNote(Note note, int n, int n2) {
        this.note = note;
        this.setLocation(n, n2);
        this.initializeData();
        this.show();
    }

    private void initializeLists() {
        this.noteList = new List(6);
        this.noteList.add("Rest");
        this.noteList.add("A");
        this.noteList.add("A#");
        this.noteList.add("B");
        this.noteList.add("C");
        this.noteList.add("C#");
        this.noteList.add("D");
        this.noteList.add("D#");
        this.noteList.add("E");
        this.noteList.add("F");
        this.noteList.add("F#");
        this.noteList.add("G");
        this.noteList.add("G#");
        this.octaveList = new List(6);
        this.octaveList.add("-1");
        this.octaveList.add("0");
        this.octaveList.add("1");
        this.octaveList.add("2");
        this.octaveList.add("3");
        this.octaveList.add("4");
        this.octaveList.add("5");
        this.octaveList.add("6");
        this.octaveList.add("7");
        this.octaveList.add("8");
        this.octaveList.add("9");
    }

    private static boolean validateFloatEdit(TextField textField, double d, double d2) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        if (!stringTokenizer.hasMoreElements()) {
            textField.setText("Error--No Data");
            return false;
        }
        String string = stringTokenizer.nextToken();
        try {
            double d3 = new Double(string);
            if (d3 < d) {
                textField.setText("Value Too Low");
                return false;
            }
            if (d3 < d) {
                textField.setText("Value Too High");
                return false;
            }
        }
        catch (Throwable throwable) {
            textField.setText("Data Error");
            return false;
        }
        if (stringTokenizer.hasMoreElements()) {
            textField.setText("Data Error");
            return false;
        }
        return true;
    }

    private static double getFieldDouble(TextField textField) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        String string = stringTokenizer.nextToken();
        return new Double(string);
    }

    private static boolean validateIntegerEdit(TextField textField, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        if (!stringTokenizer.hasMoreElements()) {
            textField.setText("Error--No Data");
            return false;
        }
        String string = stringTokenizer.nextToken();
        try {
            int n3 = new Integer(string);
            if (n3 < n) {
                textField.setText("Value Too Low");
                return false;
            }
            if (n3 > n2) {
                textField.setText("Value Too High");
                return false;
            }
        }
        catch (Throwable throwable) {
            textField.setText("Data Error");
            return false;
        }
        if (stringTokenizer.hasMoreElements()) {
            textField.setText("Data Error");
            return false;
        }
        return true;
    }

    private static int getFieldInt(TextField textField) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        String string = stringTokenizer.nextToken();
        return new Integer(string);
    }

    private boolean inputIsValid() {
        return NoteEditor.validateFloatEdit(this.durationEdit, 0.0, 1.0) && NoteEditor.validateIntegerEdit(this.dynamicEdit, 0, 127) && NoteEditor.validateFloatEdit(this.rhythmEdit, 1.0E-5, 64.0) && NoteEditor.validateFloatEdit(this.panEdit, 0.0, 1.0) && NoteEditor.validateFloatEdit(this.offsetEdit, -999.999, 999.999);
    }

    private void placeControls() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.noteLabel, gridBagConstraints);
        this.add(this.noteLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagLayout.setConstraints(this.noteList, gridBagConstraints);
        this.add(this.noteList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.octaveLabel, gridBagConstraints);
        this.add(this.octaveLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 4;
        gridBagLayout.setConstraints(this.octaveList, gridBagConstraints);
        this.add(this.octaveList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.rhythmLabel, gridBagConstraints);
        this.add(this.rhythmLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.rhythmEdit, gridBagConstraints);
        this.add(this.rhythmEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.dynamicLabel, gridBagConstraints);
        this.add(this.dynamicLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.dynamicEdit, gridBagConstraints);
        this.add(this.dynamicEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.durationLabel, gridBagConstraints);
        this.add(this.durationLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.durationEdit, gridBagConstraints);
        this.add(this.durationEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.offsetLabel, gridBagConstraints);
        this.add(this.offsetLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.offsetEdit, gridBagConstraints);
        this.add(this.offsetEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panLabel, gridBagConstraints);
        this.add(this.panLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.panEdit, gridBagConstraints);
        this.add(this.panEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.add(this.okButton);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.add(this.cancelButton);
    }

    private int getSelectedPitch() {
        String string = this.noteList.getSelectedItem();
        if (string.equals("Rest")) {
            return Integer.MIN_VALUE;
        }
        int n = string.equals("C") ? 0 : (string.equals("C#") ? 1 : (string.equals("D") ? 2 : (string.equals("D#") ? 3 : (string.equals("E") ? 4 : (string.equals("F") ? 5 : (string.equals("F#") ? 6 : (string.equals("G") ? 7 : (string.equals("G#") ? 8 : (string.equals("A") ? 9 : (string.equals("A#") ? 10 : (string.equals("A") ? 11 : 0)))))))))));
        for (int i = new Integer(this.octaveList.getSelectedItem()).intValue(); i > -1; --i) {
            n += 12;
        }
        return n;
    }

    private void updateTheNote() {
        this.note.setPitch(this.getSelectedPitch());
        this.note.setRhythmValue(NoteEditor.getFieldDouble(this.rhythmEdit));
        this.note.setDuration(this.note.getRhythmValue() * NoteEditor.getFieldDouble(this.durationEdit));
        this.note.setDynamic(NoteEditor.getFieldInt(this.dynamicEdit));
        this.note.setPan(NoteEditor.getFieldDouble(this.panEdit));
        this.note.setOffset(NoteEditor.getFieldDouble(this.offsetEdit));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.inputIsValid()) {
                this.updateTheNote();
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

