/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.sound.midi.MidiUnavailableException;
import jm.gui.cpn.JmMidiPlayer;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Write;

public class LetterNotesEditor
extends Dialog
implements ActionListener,
WindowListener {
    private Button okButton;
    private Button playButton;
    private Button cancelButton;
    private Button copyButton;
    private Label inputLabel;
    private TextArea notesInput;
    private Phrase phrase;
    private Stave stave;
    private Note currentNote;
    private char currentNoteLetter = (char)65;
    private int currentPitch = 69;
    private static List inputList = new List(8);

    public LetterNotesEditor(Frame frame) {
        super(frame, "Set Music Parameters", true);
        this.initializeData();
        this.initializeButtons();
        this.initializeLabels();
        this.setSize(500, 300);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    private void initializeData() {
        this.notesInput = new TextArea("", 10, 100, 0);
    }

    private void initializeButtons() {
        this.okButton = new Button("Add Notes");
        this.playButton = new Button("Play Notes");
        this.cancelButton = new Button("Cancel");
        this.copyButton = new Button("Copy");
    }

    private void initializeLabels() {
        this.inputLabel = new Label("Enter Note Names, R for Rest");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.addNotes();
            this.dispose();
        } else if (actionEvent.getSource() == this.playButton) {
            this.playNotes();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        } else if (actionEvent.getSource() == this.copyButton && inputList.getSelectedItem().length() > 0) {
            this.notesInput.setText(inputList.getSelectedItem());
        }
    }

    private void addNotes() {
        this.initializeUpdate();
        String string = this.notesInput.getText();
        for (int i = 0; i < string.length(); ++i) {
            this.processChar(Character.toUpperCase(string.charAt(i)));
        }
        inputList.add(LetterNotesEditor.crunchLine(string), 0);
        while (inputList.getItemCount() > 100) {
            inputList.remove(100);
        }
    }

    private void playNotes() {
        int n;
        Phrase phrase = this.phrase.copy();
        this.initializeUpdate();
        String string = this.notesInput.getText();
        for (n = 0; n < string.length(); ++n) {
            this.processChar(Character.toUpperCase(string.charAt(n)));
        }
        for (n = 0; n < phrase.size(); ++n) {
            this.phrase.removeNote(0);
        }
        try {
            JmMidiPlayer jmMidiPlayer = new JmMidiPlayer();
            Score score = new Score();
            Part part = new Part();
            score.addPart(part);
            part.addPhrase(this.phrase);
            Write.midi(score, jmMidiPlayer);
            jmMidiPlayer.play();
            jmMidiPlayer.close();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            System.out.println("Midi Not Available");
        }
        this.phrase.empty();
        for (int i = 0; i < phrase.size(); ++i) {
            this.phrase.addNote(phrase.getNote(i));
        }
    }

    private void initializeUpdate() {
        if (this.phrase.size() > 0) {
            this.currentNote = this.phrase.getNote(this.phrase.size() - 1);
            if (this.currentNote.getPitch() >= 0) {
                this.currentPitch = this.currentNote.getPitch();
                this.currentNoteLetter = LetterNotesEditor.getNoteLetter(this.currentPitch, this.stave.getKeySignature());
            }
        } else {
            this.currentNote = null;
        }
    }

    private static char getNoteLetter(int n, int n2) {
        int n3 = n % 12;
        switch (n3) {
            case 0: {
                return 'C';
            }
            case 2: {
                return 'D';
            }
            case 4: {
                return 'E';
            }
            case 5: {
                return 'F';
            }
            case 7: {
                return 'G';
            }
            case 9: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
        }
        if (n2 >= 0) {
            return LetterNotesEditor.getNoteLetter(n - 1, n2);
        }
        return LetterNotesEditor.getNoteLetter(n + 1, n2);
    }

    private void processChar(char c) {
        switch (c) {
            case 'A': {
                this.addNote(69, c);
                break;
            }
            case 'B': {
                this.addNote(71, c);
                break;
            }
            case 'C': {
                this.addNote(60, c);
                break;
            }
            case 'D': {
                this.addNote(62, c);
                break;
            }
            case 'E': {
                this.addNote(64, c);
                break;
            }
            case 'F': {
                this.addNote(65, c);
                break;
            }
            case 'G': {
                this.addNote(67, c);
                break;
            }
            case 'R': {
                this.addNote(Integer.MIN_VALUE, c);
                break;
            }
            case '#': 
            case '+': {
                this.sharpenNote();
                break;
            }
            case '-': {
                this.flattenNote();
                break;
            }
            case '>': {
                this.addOctave();
                break;
            }
            case '<': {
                this.subtractOctave();
                break;
            }
            case '1': {
                this.moveToInterval(23, 36);
                break;
            }
            case '2': {
                this.moveToInterval(35, 48);
                break;
            }
            case '3': {
                this.moveToInterval(47, 60);
                break;
            }
            case '4': {
                this.moveToInterval(59, 72);
                break;
            }
            case '5': {
                this.moveToInterval(71, 84);
                break;
            }
            case '6': {
                this.moveToInterval(83, 96);
                break;
            }
            case '7': {
                this.moveToInterval(95, 108);
                break;
            }
            case '8': {
                this.moveToInterval(107, 120);
                break;
            }
            case '9': {
                this.moveToInterval(119, 127);
                break;
            }
            case '.': {
                this.dotNote();
                break;
            }
            case 'H': {
                this.makeHalfNote();
                break;
            }
            case 'W': {
                this.makeWholeNote();
                break;
            }
            case 'Q': {
                this.makeQuarterNote();
                break;
            }
            case 'N': {
                this.makeEighthNote();
                break;
            }
            case 'T': {
                this.makeTriplet();
                break;
            }
            case 'X': {
                this.makeSixteenthNote();
                break;
            }
            case '&': {
                this.tieNotes();
                break;
            }
        }
    }

    static boolean pitchIsHigh(int n, int n2, char c, char c2) {
        String string = "ABCDEFGABCDEFG";
        if (n > n2 + 8) {
            return true;
        }
        if (n < n2 + 3) {
            return false;
        }
        int n3 = string.indexOf(c2);
        int n4 = string.indexOf(c, n3);
        return n4 > n3 + 3;
    }

    static boolean pitchIsLow(int n, int n2, char c, char c2) {
        String string = "ABCDEFGABCDEFG";
        if (n < n2 - 8) {
            return true;
        }
        if (n > n2 - 3) {
            return false;
        }
        int n3 = string.indexOf(c);
        int n4 = string.indexOf(c2, n3);
        return n4 > n3 + 3;
    }

    private void addNote(int n, char c) {
        int n2 = n;
        Note note = this.currentNote != null ? this.currentNote.copy() : new Note();
        if (c != 'R') {
            if (n2 > this.currentPitch) {
                while (LetterNotesEditor.pitchIsHigh(n2, this.currentPitch, c, this.currentNoteLetter)) {
                    n2 -= 12;
                }
            } else {
                while (LetterNotesEditor.pitchIsLow(n2, this.currentPitch, c, this.currentNoteLetter)) {
                    n2 += 12;
                }
            }
        }
        if (this.noteIsSharp(c)) {
            ++n2;
        }
        if (this.noteIsFlat(c)) {
            --n2;
        }
        note.setPitch(n2);
        this.phrase.add(note);
        this.currentNote = note;
        this.currentNoteLetter = c;
        if (this.currentNoteLetter != 'R') {
            this.currentPitch = n2;
        }
    }

    private void sharpenNote() {
        this.currentNote.setPitch(this.currentNote.getPitch() + 1);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void flattenNote() {
        this.currentNote.setPitch(this.currentNote.getPitch() - 1);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void addOctave() {
        this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void subtractOctave() {
        this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        this.currentPitch = this.currentNote.getPitch();
    }

    private void moveToInterval(int n, int n2) {
        while (this.currentNote.getPitch() > n2) {
            this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        }
        while (this.currentNote.getPitch() < n) {
            this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        }
        if (this.currentNote.getPitch() == n && this.currentNoteLetter == 'B') {
            this.currentNote.setPitch(this.currentNote.getPitch() + 12);
        }
        if (this.currentNote.getPitch() == n2 && this.currentNoteLetter == 'C') {
            this.currentNote.setPitch(this.currentNote.getPitch() - 12);
        }
        this.currentPitch = this.currentNote.getPitch();
    }

    private void dotNote() {
        this.adjustNoteByFactor(1.5);
    }

    private void makeHalfNote() {
        this.adjustNoteByFactor(2.0 / this.currentNote.getRhythmValue());
    }

    private void makeWholeNote() {
        this.adjustNoteByFactor(4.0 / this.currentNote.getRhythmValue());
    }

    private void makeQuarterNote() {
        this.adjustNoteByFactor(1.0 / this.currentNote.getRhythmValue());
    }

    private void makeEighthNote() {
        this.adjustNoteByFactor(0.5 / this.currentNote.getRhythmValue());
    }

    private void makeTriplet() {
        this.adjustNoteByFactor(0.3333333333333333 / this.currentNote.getRhythmValue());
    }

    private void makeSixteenthNote() {
        this.adjustNoteByFactor(0.25 / this.currentNote.getRhythmValue());
    }

    private void tieNotes() {
        if (this.phrase.size() > 1) {
            this.phrase.removeLastNote();
            Note note = this.phrase.getNote(this.phrase.size() - 1);
            note.setDuration(note.getDuration() + this.currentNote.getDuration());
            note.setRhythmValue(note.getRhythmValue() + this.currentNote.getRhythmValue());
            this.currentNote = note;
        }
    }

    private boolean noteIsSharp(char c) {
        String string = "FCGDAEB";
        int n = this.stave.getKeySignature();
        boolean bl = c == 'R' ? false : (n > 0 ? string.indexOf(c) < n : false);
        return bl;
    }

    private boolean noteIsFlat(char c) {
        String string = "BEADGCF";
        int n = -this.stave.getKeySignature();
        boolean bl = c == 'R' ? false : (n > 0 ? string.indexOf(c) < n : false);
        return bl;
    }

    private void adjustNoteByFactor(double d) {
        this.currentNote.setRhythmValue(d * this.currentNote.getRhythmValue());
        this.currentNote.setDuration(d * this.currentNote.getDuration());
    }

    private void placeControls() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.inputLabel, gridBagConstraints);
        this.add(this.inputLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 10;
        gridBagLayout.setConstraints(this.notesInput, gridBagConstraints);
        this.add(this.notesInput);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.playButton, gridBagConstraints);
        this.add(this.playButton);
        this.playButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 5;
        gridBagLayout.setConstraints(inputList, gridBagConstraints);
        this.add(inputList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.copyButton, gridBagConstraints);
        this.add(this.copyButton);
        this.copyButton.addActionListener(this);
    }

    public void getNotes(Stave stave) {
        this.phrase = stave.getPhrase();
        this.stave = stave;
        this.setLocation(200, 50);
        this.show();
    }

    private static String crunchLine(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (stringBuffer.charAt(n) >= ' ') continue;
            stringBuffer.setCharAt(n, ' ');
        }
        n = 0;
        while (n < stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n) == ' ') {
                if (stringBuffer.charAt(n + 1) == ' ') {
                    stringBuffer.deleteCharAt(n);
                    continue;
                }
                n += 2;
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

