/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class TapDelay
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;
    private int taps;
    private int sampleDelay;

    public TapDelay(AudioObject audioObject, int n, int n2) {
        this(audioObject, n, n2, 0.5);
    }

    public TapDelay(AudioObject audioObject, int n, int n2, double d) {
        super(audioObject, "[Tap Delay]");
        this.finished = false;
        this.decay = (float)d;
        this.delay = n;
        this.taps = n2;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2 = fArray.length;
        if (!this.inst.finishedNewData && this.inst.getFinished()) {
            n2 = this.previous[0].nextWork(fArray);
        }
        float f = 0.0f;
        for (n = 0; n < n2; ++n) {
            for (int i = 1; i <= this.taps; ++i) {
                int n3 = this.delayIndex + this.sampleDelay * this.channels * i;
                if (n3 >= this.delayLine.length) {
                    n3 -= this.delayLine.length;
                }
                int n4 = n3;
                this.delayLine[n4] = this.delayLine[n4] + fArray[n] * (this.decay / (float)i);
            }
            int n5 = n;
            fArray[n5] = fArray[n5] + this.delayLine[this.delayIndex];
            this.delayLine[this.delayIndex] = 0.0f;
            ++this.delayIndex;
            if (this.delayIndex >= this.delayLine.length) {
                this.delayIndex = 0;
            }
            if (!(f < fArray[n])) continue;
            f = fArray[n];
        }
        if (this.inst.iterations <= 0 - this.delayLine.length) {
            this.finished = true;
        }
        return n;
    }

    @Override
    public void build() {
        if (this.delayLine == null) {
            this.sampleDelay = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
            this.delayLine = new float[this.sampleDelay * this.channels * this.taps];
            this.delayIndex = 0;
        }
        this.finished = false;
    }
}

