/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class StereoPan
extends AudioObject {
    private float pan;
    private int channel = 1;
    boolean panSet = false;

    public StereoPan(AudioObject audioObject) {
        super(audioObject, "[StereoPan]");
        this.pan = 0.5f;
    }

    public StereoPan(AudioObject audioObject, double d) {
        super(audioObject, "[StereoPan]");
        this.panSet = true;
        this.pan = d < 0.0 ? 0.0f : (d > 1.0 ? 1.0f : (float)d);
    }

    @Override
    public void build() {
        float f = (float)this.currentNote.getPan();
        if (!this.panSet) {
            this.pan = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        }
        this.channel = 1;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = this.previous[0].work(fArray);
        if (this.channels == 1) {
            return n;
        }
        for (int i = 0; i < n; ++i) {
            if (this.channel == 1) {
                if ((double)this.pan > 0.5) {
                    fArray[i] = fArray[i] * (1.0f - (this.pan - 0.5f) * 2.0f);
                }
                this.channel = 2;
                continue;
            }
            if ((double)this.pan < 0.5) {
                fArray[i] = fArray[i] * this.pan * 2.0f;
            }
            this.channel = 1;
        }
        return n;
    }

    public void setPan(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.pan = (float)d;
        }
    }
}

