/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.synth.MassObject;
import jm.audio.synth.SpringObject;

public class SpringPipe {
    int totalLength = 500;
    double width = 1.0;
    double pluckAmt = 1.0;
    private SpringObject[] springObjectArray;
    private MassObject[] massObjectArray;

    public SpringPipe(int n, double d, double d2, double d3) {
        SpringObject[] springObjectArray = new SpringObject[n + 1];
        MassObject[] massObjectArray = new MassObject[n];
        int n2 = (int)((double)this.totalLength - (double)n * this.width) / (n + 1);
        for (int i = 0; i < n; ++i) {
            springObjectArray[i] = new SpringObject(d);
            springObjectArray[i].setRestingLength(n2);
            massObjectArray[i] = new MassObject(d2, 1.0 + (Math.random() * d3 - d3 / 2.0));
            massObjectArray[i].setYPosition((double)n2 * ((double)i + 1.0) + this.width * (double)i);
        }
        springObjectArray[n] = new SpringObject();
        springObjectArray[n].setRestingLength(n2);
        massObjectArray[0].setYPosition(massObjectArray[0].getYPosition() - massObjectArray[0].getYPosition() * this.pluckAmt);
        this.springObjectArray = springObjectArray;
        this.massObjectArray = massObjectArray;
    }

    private void updateSpringMassNetwork() {
        int n;
        double[] dArray = new double[this.springObjectArray.length];
        dArray[0] = this.springObjectArray[0].getCurrentForce(0.0, this.massObjectArray[0].getYPosition());
        for (n = 1; n < this.massObjectArray.length; ++n) {
            dArray[n] = this.springObjectArray[n].getCurrentForce(this.massObjectArray[n - 1].getYPosition() + this.width, this.massObjectArray[n].getYPosition());
        }
        dArray[dArray.length - 1] = this.springObjectArray[dArray.length - 1].getCurrentForce(this.massObjectArray[this.massObjectArray.length - 1].getYPosition() + this.width, this.totalLength);
        for (n = 0; n < this.massObjectArray.length; ++n) {
            this.massObjectArray[n].setYPosition(this.massObjectArray[n].getYPosition() + this.massObjectArray[n].getDisplacement(dArray[n] - dArray[n + 1]));
        }
    }

    public double getNextNodePosition(int n) {
        this.updateSpringMassNetwork();
        return this.massObjectArray[n].getYPosition();
    }
}

