/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Compressor
extends AudioObject {
    private float threshold = 1.0f;
    private double ratio = 1.0;
    private float gainReduction = 1.0f;
    private float gain = 1.0f;

    public Compressor(AudioObject audioObject) {
        this(audioObject, 0.5);
    }

    public Compressor(AudioObject audioObject, double d) {
        this(audioObject, d, 2.0);
    }

    public Compressor(AudioObject audioObject, double d, double d2) {
        this(audioObject, d, d2, 1.5);
    }

    public Compressor(AudioObject audioObject, double d, double d2, double d3) {
        super(audioObject, "[Compressor]");
        this.threshold = (float)d;
        this.ratio = d2;
        this.gain = (float)d3;
        this.calcGainReduction();
    }

    @Override
    public void build() {
    }

    private void calcGainReduction() {
        if (this.ratio == 1.0) {
            this.gainReduction = 1.0f;
        } else if (this.ratio > 1.0) {
            this.gainReduction = (float)Math.min(1.0, Math.abs(Math.log(1.0 - 1.0 / this.ratio) * 0.2));
        } else if (this.ratio > 0.0) {
            this.gainReduction = (float)(1.0 / this.ratio);
        } else {
            System.out.println("jMusic error: Compressor ratio values cannot be less than 0.0");
            System.exit(0);
        }
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = this.previous[0].nextWork(fArray);
        int n2 = 0;
        while (n2 < n) {
            if (fArray[n2] > this.threshold) {
                fArray[n2] = this.threshold + (fArray[n2] - this.threshold) * this.gainReduction;
            }
            if (fArray[n2] < -this.threshold) {
                fArray[n2] = -this.threshold + (fArray[n2] + this.threshold) * this.gainReduction;
            }
            int n3 = n2++;
            fArray[n3] = fArray[n3] * this.gain;
        }
        return n;
    }

    public void setThreshold(double d) {
        this.threshold = (float)d;
    }

    public void setRatio(double d) {
        this.ratio = d;
        this.calcGainReduction();
    }

    public void setGain(double d) {
        this.gain = (float)d;
    }
}

