/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Comb
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;

    public Comb(AudioObject audioObject, int n) {
        this(audioObject, n, 0.5);
    }

    public Comb(AudioObject audioObject, int n, double d) {
        super(audioObject, "[Comb]");
        this.decay = (float)d;
        this.delay = n;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2 = this.previous[0].nextWork(fArray);
        for (n = 0; n < n2; ++n) {
            float f = this.delayLine[this.delayIndex];
            int n3 = n;
            fArray[n3] = fArray[n3] + f * this.decay;
            this.delayLine[this.delayIndex++] = fArray[n];
            if (this.delayIndex < this.delayLine.length) continue;
            this.delayIndex = 0;
        }
        return n;
    }

    @Override
    public void build() {
        int n = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[n * this.channels];
        this.delayIndex = 0;
    }
}

