/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioFileOut {
    private String fileName;
    private File file;
    private AudioFileFormat.Type fileType = AudioFileFormat.Type.AU;
    private AudioFormat format;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;
    private long duration;
    private int sampleSize;
    private AudioInputStream ais;
    private float[] sampleData;

    public AudioFileOut(float[] fArray, String string) {
        this(fArray, string, 1, 44100, 16);
    }

    public AudioFileOut(float[] fArray, String string, int n, int n2, int n3) {
        this.sampleData = fArray;
        this.duration = fArray.length;
        this.fileName = string;
        this.channels = n;
        this.sampleRate = n2;
        this.sampleSize = n3 / 8;
        if (string.endsWith(".au")) {
            this.fileType = AudioFileFormat.Type.AU;
            this.bigEndian = true;
        } else if (string.endsWith(".wav")) {
            this.fileType = AudioFileFormat.Type.WAVE;
            this.bigEndian = false;
        } else if (string.endsWith(".aif") || string.endsWith(".aiff")) {
            this.fileType = AudioFileFormat.Type.AIFF;
            this.bigEndian = true;
        } else {
            string = string + ".au";
            this.bigEndian = true;
        }
        this.file = new File(this.fileName);
        byte[] byArray = new byte[fArray.length * this.sampleSize];
        block8: for (int i = 0; i < fArray.length; ++i) {
            int n4 = -1;
            switch (this.sampleSize) {
                case 1: {
                    byArray[i] = new Float(fArray[i] * 127.0f).byteValue();
                    continue block8;
                }
                case 2: {
                    short s = new Float(fArray[i] * 32767.0f).shortValue();
                    if (this.bigEndian) {
                        byArray[i * 2] = (byte)((s & 0xFF00) >> 8);
                        byArray[i * 2 + 1] = (byte)(s & 0xFF);
                        continue block8;
                    }
                    byArray[i * 2] = (byte)(s & 0xFF);
                    byArray[i * 2 + 1] = (byte)((s & 0xFF00) >> 8);
                    continue block8;
                }
                case 3: {
                    n4 = new Float(fArray[i] * 8388608.0f).intValue();
                    if (this.bigEndian) {
                        byArray[i * 3] = (byte)((n4 & 0xFF0000) >> 16);
                        byArray[i * 3 + 1] = (byte)((n4 & 0xFF00) >> 8);
                        byArray[i * 3 + 2] = (byte)(n4 & 0xFF);
                        continue block8;
                    }
                    byArray[i * 3] = (byte)(n4 & 0xFF);
                    byArray[i * 3 + 1] = (byte)((n4 & 0xFF00) >> 8);
                    byArray[i * 3 + 2] = (byte)((n4 & 0xFF0000) >> 16);
                    continue block8;
                }
                case 4: {
                    n4 = new Float(fArray[i] * 2.1474836E9f).intValue();
                    if (this.bigEndian) {
                        byArray[i * 4] = (byte)((n4 & 0xFF000000) >> 24);
                        byArray[i * 4 + 1] = (byte)((n4 & 0xFF0000) >> 16);
                        byArray[i * 4 + 2] = (byte)((n4 & 0xFF00) >> 8);
                        byArray[i * 4 + 3] = (byte)(n4 & 0xFF);
                        continue block8;
                    }
                    byArray[i * 4] = (byte)(n4 & 0xFF);
                    byArray[i * 4 + 1] = (byte)((n4 & 0xFF00) >> 8);
                    byArray[i * 4 + 2] = (byte)((n4 & 0xFF0000) >> 16);
                    byArray[i * 4 + 3] = (byte)((n4 & 0xFF000000) >> 24);
                    continue block8;
                }
                default: {
                    System.err.println("jMusic AudioFileOut error: " + n3 + " bit audio output file format not supported, sorry :(");
                    System.exit(0);
                }
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.format = new AudioFormat(this.sampleRate, n3, this.channels, true, this.bigEndian);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, this.format, this.duration / (long)this.channels);
        try {
            AudioSystem.write(audioInputStream, this.fileType, this.file);
        }
        catch (IOException iOException) {
            System.out.println("error writing audio file.");
        }
    }
}

