/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package net.java.sip.communicator.slick.protocol.generic;

import java.util.*;

import net.java.sip.communicator.service.protocol.*;
import net.java.sip.communicator.service.protocol.event.*;

/**
 * Gather both chat room and chat room members events generated by unit tests.
 * 
 * @author Valentin Martinet
 */
public class AHMUCEventCollector 
implements AdHocChatRoomInvitationListener,
AdHocChatRoomInvitationRejectionListener,
AdHocChatRoomMessageListener,
AdHocChatRoomParticipantPresenceListener
{

    /**
     * Events collector.
     */
    public Vector<EventObject> events = new Vector<EventObject>();

    /**
     * Ad hoc MUC operation set.
     */
    public OperationSetAdHocMultiUserChat opSet = null;

    /**
     * Ad hoc chat room.
     */
    public AdHocChatRoom room = null;

    /**
     * Invite event.
     */
    public static final int MESSAGE_EVENT = 1;

    /**
     * Presence event.
     */
    public static final int PRESENCE_EVENT = 2;

    /**
     * Presence event.
     */
    public static final int INVITATION_EVENT = 3;

    /**
     * Constructor, operation set's side.
     * 
     * @param opSet the operation set which belong to this event collector
     * @param evtType event's type
     */
    public AHMUCEventCollector(
        OperationSetAdHocMultiUserChat pOpSet, int evtType)
    {
        opSet = pOpSet;

        if(evtType == INVITATION_EVENT)
        {
            opSet.addInvitationListener(this);
            opSet.addInvitationRejectionListener(this);
        }
    }

    /**
     * Constructor, room's side.
     * 
     * @param pRoom the room which belong to this event collector
     * @param evtType event's type
     */
    public AHMUCEventCollector(AdHocChatRoom pRoom, int evtType)
    {
        room = pRoom;

        if(evtType == MESSAGE_EVENT)
            room.addMessageListener(this);
        else if(evtType == PRESENCE_EVENT)
            room.addParticipantPresenceListener(this);
    }

    public void waitForEvent(long howLong)
    {
        synchronized (this)
        {
            try
            {
                wait(howLong);
            }
            catch (InterruptedException ex)
            {
                ex.printStackTrace();
            }
        }
    }
    
    public void addEvent(EventObject evt)
    {
        synchronized (this)
        {
            events.add(evt);
            notifyAll();
        }
    }
    
    public void invitationReceived(AdHocChatRoomInvitationReceivedEvent evt) 
    {
        addEvent(evt);
    }

    public void invitationRejected(AdHocChatRoomInvitationRejectedEvent evt) 
    {
        addEvent(evt);
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent evt) 
    {
        addEvent(evt);
    }

    public void messageDeliveryFailed(
        AdHocChatRoomMessageDeliveryFailedEvent evt) 
    {
        addEvent(evt);
    }


    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) 
    {
        addEvent(evt);
    }


    public void participantPresenceChanged(
        AdHocChatRoomParticipantPresenceChangeEvent evt) 
    {
        addEvent(evt);
    }

}
