/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.address.AddressFactoryImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.sip.Dialog;
import javax.sip.IOExceptionEvent;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.SipURI;
import javax.sip.message.Request;
import javax.sip.message.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SIPTransaction
extends MessageChannel
implements Transaction,
TransactionExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPTransaction.class);
    protected boolean toListener;
    protected int BASE_TIMER_INTERVAL = 500;
    protected int T4 = 5000 / this.BASE_TIMER_INTERVAL;
    protected int T2 = 4000 / this.BASE_TIMER_INTERVAL;
    protected int TIMER_I = this.T4;
    protected int TIMER_K = this.T4;
    protected int TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    protected static final int T1 = 1;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected transient Object applicationData;
    protected SIPResponse lastResponse;
    protected boolean isMapped;
    private TransactionSemaphore semaphore;
    protected String transactionId;
    public long auditTag = 0L;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected transient SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    protected byte[] originalRequestBytes;
    protected long originalRequestCSeqNumber;
    protected String originalRequestBranch;
    protected boolean originalRequestHasPort;
    private transient MessageChannel encapsulatedChannel;
    protected AtomicBoolean transactionTimerStarted = new AtomicBoolean(false);
    private String branch;
    private String method;
    private int currentState = -1;
    private transient int retransmissionTimerLastTickCount;
    private transient int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private transient Set<SIPTransactionEventListener> eventListeners;
    protected int collectionTime;
    private boolean terminatedEventDelivered;
    private boolean releaseReferences;
    private Boolean inviteTransaction = null;
    private Boolean dialogCreatingTransaction = null;
    private String forkId = null;
    public SIPClientTransaction.ExpiresTimerTask expiresTimerTask;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.sipStack = newParentStack;
        this.semaphore = new TransactionSemaphore();
        this.encapsulatedChannel = newEncapsulatedChannel;
        if (this.isReliable()) {
            ++this.encapsulatedChannel.useCount;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("use count for encapsulated channel" + this + " " + this.encapsulatedChannel.useCount);
            }
        }
        this.currentState = -1;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = new CopyOnWriteArraySet<SIPTransactionEventListener>();
        this.addEventListener(newParentStack);
        this.releaseReferences = this.sipStack.isAggressiveCleanup();
    }

    public abstract void cleanUp();

    public void setOriginalRequest(SIPRequest newOriginalRequest) {
        String newTransactionId = newOriginalRequest.getTransactionId();
        if (this.originalRequest != null && !this.originalRequest.getTransactionId().equals(newTransactionId)) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = newOriginalRequest;
        this.originalRequestCSeqNumber = newOriginalRequest.getCSeq().getSeqNumber();
        Via topmostVia = newOriginalRequest.getTopmostVia();
        this.originalRequestBranch = topmostVia.getBranch();
        this.originalRequestHasPort = topmostVia.hasPort();
        int originalRequestViaPort = topmostVia.getPort();
        if (originalRequestViaPort == -1) {
            originalRequestViaPort = topmostVia.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        this.method = newOriginalRequest.getMethod();
        this.transactionId = newTransactionId;
        this.originalRequest.setTransaction(this);
        String newBranch = topmostVia.getBranch();
        if (newBranch != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Setting Branch id : " + newBranch);
            }
            this.setBranch(newBranch);
        } else {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Branch id is null - compute TID!" + newOriginalRequest.encode());
            }
            this.setBranch(newTransactionId);
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        if (this.isReleaseReferences() && this.originalRequest == null && this.originalRequestBytes != null) {
            if (logger.isLoggingEnabled(8)) {
                logger.logWarning("reparsing original request " + this.originalRequestBytes + " since it was eagerly cleaned up, but beware this is not efficient with the aggressive flag set !");
            }
            try {
                this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
            }
            catch (ParseException e) {
                logger.logError("message " + this.originalRequestBytes + " could not be reparsed !");
            }
        }
        return this.originalRequest;
    }

    public final boolean isDialogCreatingTransaction() {
        if (this.dialogCreatingTransaction == null) {
            this.dialogCreatingTransaction = this.isInviteTransaction() || this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER");
        }
        return this.dialogCreatingTransaction;
    }

    public final boolean isInviteTransaction() {
        if (this.inviteTransaction == null) {
            this.inviteTransaction = this.getMethod().equals("INVITE");
        }
        return this.inviteTransaction;
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.originalRequestBranch;
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final long getCSeq() {
        return this.originalRequestCSeqNumber;
    }

    public void setState(int newState) {
        if (this.currentState == 3 && newState != 5 && newState != 4) {
            newState = 3;
        }
        if (this.currentState == 4 && newState != 5) {
            newState = 4;
        }
        if (this.currentState != 5) {
            this.currentState = newState;
        } else {
            newState = this.currentState;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction:setState " + newState + " " + this + " branchID = " + this.getBranch() + " isClient = " + (this instanceof SIPClientTransaction));
            logger.logStackTrace();
        }
    }

    public int getInternalState() {
        return this.currentState;
    }

    public TransactionState getState() {
        if (this.currentState < 0) {
            return null;
        }
        return TransactionState.getObject((int)this.currentState);
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerTicksLeft = this.isInviteTransaction() && this instanceof SIPClientTransaction ? tickCount : Math.min(tickCount, 8);
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft;
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int tickCount) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("enableTimeoutTimer " + this + " tickCount " + tickCount + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = tickCount;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public final boolean isTerminated() {
        return this.currentState == 5;
    }

    @Override
    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    @Override
    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    @Override
    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public String getPeerAddress() {
        return this.encapsulatedChannel.getPeerAddress();
    }

    @Override
    public int getPeerPort() {
        return this.encapsulatedChannel.getPeerPort();
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.encapsulatedChannel.getPeerPacketSourcePort();
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.encapsulatedChannel.getPeerPacketSourceAddress();
    }

    @Override
    protected InetAddress getPeerInetAddress() {
        return this.encapsulatedChannel.getPeerInetAddress();
    }

    @Override
    protected String getPeerProtocol() {
        return this.encapsulatedChannel.getPeerProtocol();
    }

    @Override
    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    @Override
    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    @Override
    public Via getViaHeader() {
        Via channelViaHeader = super.getViaHeader();
        try {
            channelViaHeader.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return channelViaHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendMessage(final SIPMessage messageToSend) throws IOException {
        block11: {
            block10: {
                try {
                    final RawMessageChannel channel = (RawMessageChannel)((Object)this.encapsulatedChannel);
                    for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                        boolean addrmatch = messageProcessor.getIpAddress().getHostAddress().toString().equals(this.getPeerAddress());
                        if (!addrmatch || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
                        if (channel instanceof TCPMessageChannel) {
                            try {
                                Runnable processMessageTask = new Runnable(){

                                    public void run() {
                                        block2: {
                                            try {
                                                ((TCPMessageChannel)channel).processMessage((SIPMessage)messageToSend.clone(), SIPTransaction.this.getPeerInetAddress());
                                            }
                                            catch (Exception ex) {
                                                if (!logger.isLoggingEnabled(4)) break block2;
                                                logger.logError("Error self routing message cause by: ", ex);
                                            }
                                        }
                                    }
                                };
                                this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                            }
                            catch (Exception e) {
                                logger.logError("Error passing message in self routing", e);
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Self routing message");
                            }
                            Object var10_12 = null;
                            this.startTransactionTimer();
                            return;
                        }
                        if (!(channel instanceof RawMessageChannel)) continue;
                        try {
                            Runnable processMessageTask = new Runnable(){

                                public void run() {
                                    block2: {
                                        try {
                                            channel.processMessage((SIPMessage)messageToSend.clone());
                                        }
                                        catch (Exception ex) {
                                            if (!logger.isLoggingEnabled(4)) break block2;
                                            logger.logError("Error self routing message cause by: ", ex);
                                        }
                                    }
                                }
                            };
                            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                        }
                        catch (Exception e) {
                            logger.logError("Error passing message in self routing", e);
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Self routing message");
                        }
                        break block10;
                    }
                    this.encapsulatedChannel.sendMessage(messageToSend, this.getPeerInetAddress(), this.getPeerPort());
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    this.startTransactionTimer();
                    throw throwable;
                }
            }
            Object var10_13 = null;
            this.startTransactionTimer();
            return;
        }
        Object var10_14 = null;
        this.startTransactionTimer();
    }

    @Override
    protected void sendMessage(byte[] messageBytes, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Set<SIPTransactionEventListener> set = this.eventListeners;
        synchronized (set) {
            for (SIPTransactionEventListener nextListener : this.eventListeners) {
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        if (errorEventID != 3) {
            this.eventListeners.clear();
            this.setState(5);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).setState(3);
            }
        }
    }

    protected boolean isServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public abstract Dialog getDialog();

    public abstract void setDialog(SIPDialog var1, String var2);

    public int getRetransmitTimer() {
        return 500;
    }

    @Override
    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    @Override
    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest requestToTest) {
        boolean transactionMatches = false;
        SIPRequest origRequest = this.getOriginalRequest();
        if (origRequest == null || this.getMethod().equals("CANCEL")) {
            return false;
        }
        Via topViaHeader = requestToTest.getTopmostVia();
        if (topViaHeader != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy())) {
                    transactionMatches = true;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("returning  true");
                    }
                }
            } else {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("testing against " + origRequest);
                }
                if (origRequest.getRequestURI().equals(requestToTest.getRequestURI()) && origRequest.getTo().equals(requestToTest.getTo()) && origRequest.getFrom().equals(requestToTest.getFrom()) && origRequest.getCallId().getCallId().equals(requestToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == requestToTest.getCSeq().getSeqNumber() && topViaHeader.equals(origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        if (transactionMatches) {
            this.setPassToListener();
        }
        return transactionMatches;
    }

    public void setRetransmitTimer(int retransmitTimer) {
        if (retransmitTimer <= 0) {
            throw new IllegalArgumentException("Retransmit timer must be positive!");
        }
        if (this.transactionTimerStarted.get()) {
            throw new IllegalStateException("Transaction timer is already started");
        }
        this.BASE_TIMER_INTERVAL = retransmitTimer;
    }

    @Override
    public void close() {
        this.encapsulatedChannel.close();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.encapsulatedChannel);
        }
    }

    @Override
    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    @Override
    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        if (this instanceof SIPClientTransaction) {
            this.encapsulatedChannel.setEncapsulatedClientTransaction((SIPClientTransaction)this);
        }
    }

    @Override
    public SipProviderImpl getSipProvider() {
        return this.getMessageProcessor().getListeningPoint().getProvider();
    }

    public void raiseIOExceptionEvent() {
        this.setState(5);
        String host = this.getPeerAddress();
        int port = this.getPeerPort();
        String transport = this.getTransport();
        IOExceptionEvent exceptionEvent = new IOExceptionEvent((Object)this, host, port, transport);
        this.getSipProvider().handleEvent((EventObject)exceptionEvent, this);
    }

    public boolean acquireSem() {
        boolean retval = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem [[[[" + this);
            logger.logStackTrace();
        }
        retval = this.sipStack.maxListenerResponseTime == -1 ? this.semaphore.acquire() : this.semaphore.tryAcquire();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem() returning : " + retval);
        }
        return retval;
    }

    public void releaseSem() {
        try {
            this.toListener = false;
            this.semRelease();
        }
        catch (Exception ex) {
            logger.logError("Unexpected exception releasing sem", ex);
        }
    }

    protected void semRelease() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("semRelease ]]]]" + this);
            logger.logStackTrace();
        }
        this.semaphore.release();
    }

    public boolean passToListener() {
        return this.toListener;
    }

    public void setPassToListener() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setPassToListener()");
        }
        this.toListener = true;
    }

    protected synchronized boolean testAndSetTransactionTerminatedEvent() {
        boolean retval = !this.terminatedEventDelivered;
        this.terminatedEventDelivered = true;
        return retval;
    }

    @Override
    public String getCipherSuite() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getCipherSuite();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public Certificate[] getLocalCertificates() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getLocalCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getPeerCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public List<String> extractCertIdentities() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            ArrayList<String> certIdentities = new ArrayList<String>();
            Certificate[] certs = this.getPeerCertificates();
            if (certs == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("No certificates available");
                }
                return certIdentities;
            }
            for (Certificate cert : certs) {
                Collection<List<?>> subjAltNames;
                X509Certificate x509cert;
                block17: {
                    x509cert = (X509Certificate)cert;
                    subjAltNames = null;
                    try {
                        subjAltNames = x509cert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException ex) {
                        if (!logger.isLoggingEnabled()) break block17;
                        logger.logError("Error parsing TLS certificate", ex);
                    }
                }
                Integer dnsNameType = 2;
                Integer uriNameType = 6;
                if (subjAltNames != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found subjAltNames: " + subjAltNames);
                    }
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(uriNameType)) continue;
                        try {
                            SipURI altNameUri = new AddressFactoryImpl().createSipURI((String)altName.get(1));
                            String altHostName = altNameUri.getHost();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("found uri " + altName.get(1) + ", hostName " + altHostName);
                            }
                            certIdentities.add(altHostName);
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled()) continue;
                            logger.logError("certificate contains invalid uri: " + altName.get(1));
                        }
                    }
                    if (!certIdentities.isEmpty()) continue;
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(dnsNameType)) continue;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("found dns " + altName.get(1));
                        }
                        certIdentities.add(altName.get(1).toString());
                    }
                    continue;
                }
                String dname = x509cert.getSubjectDN().getName();
                String cname = "";
                try {
                    Pattern EXTRACT_CN = Pattern.compile(".*CN\\s*=\\s*([\\w*\\.]+).*");
                    Matcher matcher = EXTRACT_CN.matcher(dname);
                    if (!matcher.matches()) continue;
                    cname = matcher.group(1);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found CN: " + cname + " from DN: " + dname);
                    }
                    certIdentities.add(cname);
                }
                catch (Exception ex) {
                    if (!logger.isLoggingEnabled()) continue;
                    logger.logError("exception while extracting CN", ex);
                }
            }
            return certIdentities;
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    protected abstract void startTransactionTimer();

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    @Override
    public boolean isReleaseReferences() {
        return this.releaseReferences;
    }

    @Override
    public void setReleaseReferences(boolean releaseReferences) {
        this.releaseReferences = releaseReferences;
    }

    @Override
    public int getTimerD() {
        return this.TIMER_D;
    }

    @Override
    public int getTimerT2() {
        return this.T2;
    }

    @Override
    public int getTimerT4() {
        return this.T4;
    }

    @Override
    public void setTimerD(int interval) {
        if (interval < 32000) {
            throw new IllegalArgumentException("To be RFC 3261 compliant, the value of Timer D should be at least 32s");
        }
        this.TIMER_D = interval / this.BASE_TIMER_INTERVAL;
    }

    @Override
    public void setTimerT2(int interval) {
        this.T2 = interval / this.BASE_TIMER_INTERVAL;
    }

    @Override
    public void setTimerT4(int interval) {
        this.TIMER_I = this.T4 = interval / this.BASE_TIMER_INTERVAL;
        this.TIMER_K = this.T4;
    }

    public void setForkId(String forkId) {
        this.forkId = forkId;
    }

    public String getForkId() {
        return this.forkId;
    }

    class LingerTimer
    extends SIPStackTimerTask {
        public LingerTimer() {
            if (logger.isLoggingEnabled(32)) {
                SIPTransaction sipTransaction = SIPTransaction.this;
                logger.logDebug("LingerTimer : " + sipTransaction.getTransactionId());
            }
        }

        public void runTask() {
            SIPTransaction.this.cleanUp();
        }
    }

    class TransactionSemaphore {
        private static final long serialVersionUID = -1634100711669020804L;
        Semaphore sem = null;
        ReentrantLock lock = null;

        public TransactionSemaphore() {
            if (((SipStackImpl)SIPTransaction.this.getSIPStack()).isReEntrantListener()) {
                this.lock = new ReentrantLock();
            } else {
                this.sem = new Semaphore(1, true);
            }
        }

        public boolean acquire() {
            try {
                if (((SipStackImpl)SIPTransaction.this.getSIPStack()).isReEntrantListener()) {
                    this.lock.lock();
                } else {
                    this.sem.acquire();
                }
                return true;
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception acquiring sem", ex);
                InternalErrorHandler.handleException(ex);
                return false;
            }
        }

        public boolean tryAcquire() {
            try {
                if (((SipStackImpl)SIPTransaction.this.getSIPStack()).isReEntrantListener()) {
                    return this.lock.tryLock(SIPTransaction.this.sipStack.maxListenerResponseTime, TimeUnit.SECONDS);
                }
                return this.sem.tryAcquire(SIPTransaction.this.sipStack.maxListenerResponseTime, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception trying acquiring sem", ex);
                InternalErrorHandler.handleException(ex);
                return false;
            }
        }

        public void release() {
            try {
                if (((SipStackImpl)SIPTransaction.this.getSIPStack()).isReEntrantListener()) {
                    if (this.lock.isHeldByCurrentThread()) {
                        this.lock.unlock();
                    }
                } else {
                    this.sem.release();
                }
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception releasing sem", ex);
            }
        }
    }
}

