/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import net.sf.profiler4j.console.CallGraphPanel;
import net.sf.profiler4j.console.MethodView;

class LinkView {
    private static double tolerance = 4.0;
    protected Point2D.Double[] n;
    protected GeneralPath path = new GeneralPath();
    private MethodView src;
    private MethodView dst;
    private double k = 10.0;

    public LinkView(MethodView src, MethodView dst) {
        this.src = src;
        this.dst = dst;
        this.updateShape();
    }

    public MethodView getDst() {
        return this.dst;
    }

    public MethodView getSrc() {
        return this.src;
    }

    public void updateShape() {
        this.path.reset();
        if (this.src.x >= this.dst.x) {
            if (this.src.y == this.dst.y) {
                this.k = (double)CallGraphPanel.spacingX * 0.3;
                this.n = new Point2D.Double[6];
                this.n[0] = new Point2D.Double(this.src.x + CallGraphPanel.methodWidth, this.src.y + CallGraphPanel.methodHeight / 2);
                this.n[5] = new Point2D.Double(this.dst.x, this.dst.y + CallGraphPanel.methodHeight / 2);
                this.n[1] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y);
                this.n[2] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y - this.k * 2.0);
                this.n[3] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y - this.k * 2.0);
                this.n[4] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y);
            } else if (this.src.y < this.dst.y) {
                this.k = (double)CallGraphPanel.spacingX * 0.3;
                this.n = new Point2D.Double[6];
                this.n[0] = new Point2D.Double(this.src.x + CallGraphPanel.methodWidth, this.src.y + CallGraphPanel.methodHeight / 2);
                this.n[5] = new Point2D.Double(this.dst.x, this.dst.y + CallGraphPanel.methodHeight / 2);
                this.n[1] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y);
                this.n[2] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y + this.k * 2.0);
                this.n[3] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y - this.k * 2.0);
                this.n[4] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y);
            } else {
                this.k = (double)CallGraphPanel.spacingX * 0.3;
                this.n = new Point2D.Double[6];
                this.n[0] = new Point2D.Double(this.src.x + CallGraphPanel.methodWidth, this.src.y + CallGraphPanel.methodHeight / 2);
                this.n[5] = new Point2D.Double(this.dst.x, this.dst.y + CallGraphPanel.methodHeight / 2);
                this.n[1] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y);
                this.n[2] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y - this.k * 2.0);
                this.n[3] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y + this.k * 2.0);
                this.n[4] = new Point2D.Double(this.n[5].x - this.k, this.n[5].y);
            }
        } else {
            this.n = new Point2D.Double[4];
            this.n[0] = new Point2D.Double(this.src.x + CallGraphPanel.methodWidth, this.src.y + CallGraphPanel.methodHeight / 2);
            this.n[3] = new Point2D.Double(this.dst.x, this.dst.y + CallGraphPanel.methodHeight / 2);
            this.k = (double)CallGraphPanel.spacingX * 0.3;
            this.n[1] = new Point2D.Double(this.n[0].x + this.k, this.n[0].y);
            this.n[2] = new Point2D.Double(this.n[3].x - this.k, this.n[3].y);
        }
        this.path.moveTo((float)this.n[0].x, (float)this.n[0].y);
        int i = 1;
        for (i = 1; i < this.n.length - 1; ++i) {
            Point2D.Double cp1 = this.n[i];
            Point2D.Double cp2 = this.n[i];
            Point2D.Double p = LinkView.midPoint(this.n[i], this.n[i + 1]);
            this.path.curveTo((float)cp1.x, (float)cp1.y, (float)cp2.x, (float)cp2.y, (float)p.x, (float)p.y);
        }
        this.path.lineTo((float)this.n[i].x, (float)this.n[i].y);
    }

    public boolean contains(int x, int y) {
        if (this.n != null) {
            Line2D.Double seg = new Line2D.Double();
            for (int i = 0; i < this.n.length - 1; ++i) {
                ((Line2D)seg).setLine(this.n[i].x, this.n[i].y, this.n[i + 1].x, this.n[i + 1].y);
                if (!(seg.ptSegDist(x, y) <= tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics2D g) {
        g.draw(this.path);
    }

    private static Point2D.Double midPoint(Point2D.Double p1, Point2D.Double p2) {
        return new Point2D.Double((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
    }
}

