/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network.event;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import ymsg.network.event.SessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFileTransferEvent
extends SessionEvent {
    protected URL location = null;
    public static final int UNKNOWN = -1;
    public static final int ACCEPT = 0;
    public static final int CANCEL = 1;
    public static final int RECEIVED = 2;
    public static final int SENT = 3;
    public static final int IN_PROGRESS = 4;
    public static final int FAILED = 5;
    public static final int REFUSED = 6;
    private int state = -1;
    private String id = null;
    private List<String> fileNames = null;
    private List<String> fileSizes = null;
    private long progress = 0L;

    public SessionFileTransferEvent(Object object, String string, String string2, String string3, String string4, String string5) {
        super(object, string, string2, string3, string4);
        try {
            this.location = new URL(string5);
        }
        catch (MalformedURLException malformedURLException) {
            this.location = null;
        }
    }

    public SessionFileTransferEvent(Object object, String string, String string2, String string3) {
        super(object, string, string2);
        this.id = string3;
    }

    public SessionFileTransferEvent(Object object, String string, String string2, String string3, int n) {
        this(object, string, string2, string3);
        this.state = n;
    }

    public SessionFileTransferEvent(Object object, String string, String string2, String string3, int n, long l) {
        this(object, string, string2, string3);
        this.state = n;
        this.progress = l;
    }

    public SessionFileTransferEvent(Object object, String string, String string2, List<String> list, List<String> list2, String string3, int n) {
        this(object, string, string2, string3);
        this.state = n;
        this.fileNames = list;
        this.fileSizes = list2;
    }

    public URL getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return super.toString() + " location:" + this.location;
    }

    public String getFilenameFromLocation() {
        try {
            String string = this.location.getFile();
            if (string.lastIndexOf("/") > 0) {
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            if (string.indexOf("?") >= 0) {
                string = string.substring(0, string.indexOf("?"));
            }
            return string;
        }
        catch (Exception exception) {
            return "ymsg_default.out";
        }
    }

    public String getId() {
        return this.id;
    }

    public int getState() {
        return this.state;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public List<String> getFileSizes() {
        return this.fileSizes;
    }

    public long getProgress() {
        return this.progress;
    }

    public void setProgress(long l) {
        this.progress = l;
    }
}

