/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import ymsg.network.AccountLockedException;
import ymsg.network.ChallengeResponseV10;
import ymsg.network.ChallengeResponseV16;
import ymsg.network.ChallengeResponseV9;
import ymsg.network.ConnectionHandler;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.FileTransferFailedException;
import ymsg.network.HTTPConnection;
import ymsg.network.HTTPConnectionHandler;
import ymsg.network.IllegalIdentityException;
import ymsg.network.LoginRefusedException;
import ymsg.network.NetworkConstants;
import ymsg.network.NoSuchChatroomException;
import ymsg.network.NoSuchConferenceException;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.SOCKSConnectionHandler;
import ymsg.network.ServiceConstants;
import ymsg.network.SessionPicture;
import ymsg.network.StatusConstants;
import ymsg.network.UserStore;
import ymsg.network.Util;
import ymsg.network.YMSG9BadFormatException;
import ymsg.network.YMSG9Packet;
import ymsg.network.YahooChatCategory;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatUser;
import ymsg.network.YahooConference;
import ymsg.network.YahooException;
import ymsg.network.YahooGroup;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionAuthorizationEvent;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionErrorEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionExceptionEvent;
import ymsg.network.event.SessionFileTransferEvent;
import ymsg.network.event.SessionFileTransferListener;
import ymsg.network.event.SessionFriendEvent;
import ymsg.network.event.SessionListener;
import ymsg.network.event.SessionNewMailEvent;
import ymsg.network.event.SessionNotifyEvent;
import ymsg.network.event.SessionPictureEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements StatusConstants,
ServiceConstants,
NetworkConstants {
    private static Logger logger = Logger.getLogger(Session.class.getName());
    private String primaryID;
    private String loginID;
    private String password;
    private String cookieY;
    private String cookieT;
    private String cookieC;
    private String imvironment;
    private long status;
    private String customStatusMessage;
    private boolean customStatusBusy;
    private YahooGroup[] groups;
    private YahooIdentity[] identities;
    private int conferenceCount;
    private UserStore userStore;
    private int sessionStatus;
    private long sessionId = 0L;
    private Vector listeners;
    private ConnectionHandler network;
    private ThreadGroup ymsgThreads;
    private InputThread ipThread;
    private PingThread pingThread;
    private Hashtable typingNotifiers;
    private boolean loginOver = false;
    private boolean receivedListFired = false;
    private YahooException loginException = null;
    private YMSG9Packet cachePacket;
    private Hashtable conferences;
    private boolean chatConnectOver = false;
    private boolean chatLoginOver = false;
    private int chatSessionStatus;
    private YahooChatLobby currentLobby = null;
    private String chatID;
    private SessionPicture picture = null;
    private String pictureURL = "";
    private ArrayList<SessionFileTransferListener> sessionFileTransferListeners = new ArrayList();
    Hashtable<String, XFer> currentTransfers = new Hashtable();

    public Session(ConnectionHandler ch) {
        this.network = ch;
        this._init();
    }

    public Session() {
        Properties p = System.getProperties();
        this.network = p.containsKey("socksProxyHost") ? new SOCKSConnectionHandler() : (p.containsKey("http.proxyHost") || p.containsKey("proxyHost") ? new HTTPConnectionHandler() : new DirectConnectionHandler());
        this._init();
    }

    private void _init() {
        this.status = 0x5A55AA55L;
        this.sessionId = 0L;
        this.sessionStatus = 0;
        this.ymsgThreads = new ThreadGroup("YMSG Threads");
        this.groups = null;
        this.identities = null;
        this.listeners = new Vector();
        this.conferences = new Hashtable();
        this.typingNotifiers = new Hashtable();
        this.userStore = new UserStore();
        this.network.install(this, this.ymsgThreads);
    }

    public void addSessionListener(SessionListener ss) {
        if (this.listeners.indexOf(ss) < 0) {
            this.listeners.addElement(ss);
        }
    }

    public void removeSessionListener(SessionListener ss) {
        this.listeners.removeElement(ss);
    }

    public void addSessionFileListener(SessionFileTransferListener sfs) {
        if (this.sessionFileTransferListeners.indexOf(sfs) < 0) {
            this.sessionFileTransferListeners.add(sfs);
        }
    }

    public void removeSessionFileListener(SessionFileTransferListener sfs) {
        this.listeners.remove(sfs);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(String u, String p) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException {
        if (this.sessionStatus != 0) {
            throw new IllegalStateException("Session should be unstarted");
        }
        u = u.toLowerCase();
        this.resetData();
        this.loginID = u;
        this.primaryID = null;
        this.password = p;
        this.sessionId = 0L;
        this.imvironment = "0";
        this.network.open();
        this.loginOver = false;
        this.startThreads();
        this.transmitAuth();
        long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
        while (!this.loginOver && !this.past(timeout)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        if (this.past(timeout)) {
            this.sessionStatus = 3;
            this.closeNetwork();
            throw new InterruptedIOException("Login timed out");
        }
        if (this.sessionStatus == 3 && this.loginException != null) {
            throw (LoginRefusedException)this.loginException;
        }
    }

    public synchronized void logout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.sessionStatus = 0;
        this.transmitLogoff();
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.sessionStatus != 3 && this.sessionStatus != 0) {
            throw new IllegalStateException("Session currently active");
        }
        this.sessionStatus = 0;
        this.chatSessionStatus = 0;
        this.resetData();
    }

    public void sendMessage(String to, String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitMessage(to, this.loginID, msg);
    }

    public void sendMessage(String to, String msg, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        this.transmitMessage(to, yid.getId(), msg);
    }

    public void sendBuzz(String to) throws IllegalStateException, IOException {
        this.sendMessage(to, "<ding>");
    }

    public void sendBuzz(String to, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.sendMessage(to, "<ding>", yid);
    }

    public int getSessionStatus() {
        return this.sessionStatus;
    }

    public long getStatus() {
        return this.status;
    }

    public synchronized void setStatus(long s) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0 && s != 0L && s != 12L) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (s == 99L) {
            throw new IllegalArgumentException("Cannot set custom state without message");
        }
        long oldStatus = this.status;
        this.status = s;
        this.customStatusMessage = null;
        if (this.sessionStatus == 2) {
            this._doStatus();
            if (oldStatus == 12L) {
                this.transmitToggleVisibility(true);
            }
        }
    }

    public synchronized void setStatus(String m, boolean b) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (m == null) {
            throw new IllegalArgumentException("Cannot set custom state with null message");
        }
        this.status = 99L;
        this.customStatusMessage = m;
        this.customStatusBusy = b;
        this._doStatus();
    }

    private void _doStatus() throws IllegalStateException, IOException {
        if (this.status == 0L) {
            this.transmitIsBack();
        } else if (this.status == 12L) {
            this.transmitToggleVisibility(false);
        } else if (this.status == 99L) {
            this.transmitIsAway(this.customStatusMessage, this.customStatusBusy);
        } else {
            this.transmitIsAway();
        }
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public void refreshStats() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitUserStat();
    }

    public YahooIdentity[] getIdentities() {
        if (this.identities == null) {
            return null;
        }
        return (YahooIdentity[])this.identities.clone();
    }

    public YahooIdentity getPrimaryIdentity() {
        return this.identityIdToObject(this.primaryID);
    }

    public YahooIdentity getLoginIdentity() {
        return this.identityIdToObject(this.loginID);
    }

    public void activateIdentity(YahooIdentity yid, boolean activate) throws IllegalStateException, IllegalIdentityException, IOException {
        this.checkStatus();
        this.checkIdentity(yid);
        if (yid.getId().equals(this.primaryID)) {
            throw new IllegalIdentityException("Primary identity cannot be de/activated");
        }
        if (activate) {
            this.transmitIdActivate(yid.getId());
        } else {
            this.transmitIdDeactivate(yid.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypingNotification(String user, Component com) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            if (this.typingNotifiers.containsKey(key)) {
                return;
            }
            this.typingNotifiers.put(key, new TypingNotifier(com, user, syid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypingNotification(String user) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
            if (tn == null) {
                return;
            }
            tn.quit = true;
            tn.interrupt();
            this.typingNotifiers.remove(key);
        }
    }

    public void keyTyped(String user) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
        if (tn != null) {
            tn.keyTyped();
        }
    }

    public YahooGroup[] getGroups() {
        return (YahooGroup[])this.groups.clone();
    }

    public Hashtable getUsers() {
        return (Hashtable)this.userStore.getUsers().clone();
    }

    public YahooUser getUser(String id) {
        return this.userStore.get(id);
    }

    public YahooUser addUserbyID(String id) {
        return this.userStore.getOrCreate(id);
    }

    public String getImvironment() {
        return this.imvironment;
    }

    public String[] getCookies() {
        String[] arr = new String[]{this.cookieY, this.cookieT, this.cookieC};
        return arr;
    }

    public YahooConference createConference(String[] users, String msg) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkIdentityNotOnList(users);
        return this.createConference(users, msg, this.identityIdToObject(this.loginID));
    }

    public YahooConference createConference(String[] users, String msg, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        this.checkIdentityNotOnList(users);
        String r = this.getConferenceName(yid.getId());
        this.transmitConfInvite(users, yid.getId(), r, msg);
        try {
            return this.getConference(r);
        }
        catch (NoSuchConferenceException e) {
            return null;
        }
    }

    public void acceptConferenceInvite(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogon(room.getName(), room.getIdentity().getId());
    }

    public void declineConferenceInvite(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfDecline(room.getName(), room.getIdentity().getId(), msg);
    }

    public void extendConference(YahooConference room, String user, String msg) throws IllegalStateException, IOException, NoSuchConferenceException, IllegalIdentityException {
        this.checkStatus();
        String[] arr = new String[]{user};
        this.checkIdentityNotOnList(arr);
        this.transmitConfAddInvite(user, room.getName(), room.getIdentity().getId(), msg);
    }

    public void sendConferenceMessage(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfMsg(room.getName(), room.getIdentity().getId(), msg);
    }

    public void leaveConference(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogoff(room.getName(), room.getIdentity().getId());
    }

    public void addFriend(String friend, String group) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendAdd(friend, group);
    }

    public void removeFriend(String friend, String group) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendRemove(friend, group);
    }

    public void rejectContact(SessionEvent se, String msg) throws IllegalArgumentException, IllegalStateException, IOException {
        if (se.getFrom() == null || se.getTo() == null) {
            throw new IllegalArgumentException("Missing to or from field in event object.");
        }
        this.checkStatus();
        this.transmitContactReject(se.getFrom(), se.getTo(), msg);
    }

    public void ignoreContact(String friend, boolean ignore) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitContactIgnore(friend, ignore);
    }

    public void refreshFriends() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitList();
    }

    public void rejectFriendAuthorization(SessionAuthorizationEvent ev, String friend, String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitRejectBuddy(friend, ev.getTo(), msg);
    }

    public void acceptFriendAuthorization(SessionAuthorizationEvent ev, String friend) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitAcceptBuddy(friend, ev.getTo());
    }

    public void sendFileTransfer(String user, String filename, String msg) throws IllegalStateException, FileTransferFailedException, IOException {
        this.checkStatus();
        YahooUser u = this.userStore.get(user);
        if (u == null || u.versionId > 500000L) {
            // empty if block
        }
        this.transmitFileTransfer(user, msg, filename);
    }

    public void saveFileTransferAs(SessionFileTransferEvent ev, String filename) throws FileTransferFailedException, IOException {
        this.saveFT(ev, null, filename);
    }

    public void saveFileTransferTo(SessionFileTransferEvent ev, String dir) throws FileTransferFailedException, IOException {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        this.saveFT(ev, dir, ev.getFilenameFromLocation());
    }

    private void saveFT(SessionFileTransferEvent ev, String path, String filename) throws FileTransferFailedException, IOException {
        int len;
        byte[] buff = new byte[4096];
        String contDisp = "Content-Disposition: filename=";
        HTTPConnection conn = new HTTPConnection("GET", ev.getLocation());
        conn.println("Host: " + ev.getLocation().getHost());
        conn.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        conn.println("Cookie: " + this.cookieY + "; " + this.cookieT);
        conn.println("");
        conn.flush();
        String in = conn.readLine();
        if (in.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server HTTP error code: " + in);
        }
        do {
            in = conn.readLine();
            if (path == null || in == null || !in.startsWith(contDisp) || (filename = in.substring(contDisp.length())).charAt(0) != '\"') continue;
            filename = filename.substring(1, filename.length() - 1);
        } while (in != null && in.trim().length() > 0);
        if (in == null) {
            throw new FileTransferFailedException("Server premature end of reply");
        }
        if (path != null) {
            filename = path + filename;
        }
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(filename));
        do {
            if ((len = conn.read(buff)) <= 0) continue;
            dos.write(buff, 0, len);
        } while (len >= 0);
        dos.flush();
        dos.close();
        conn.close();
    }

    public synchronized void chatLogin(YahooChatLobby ycl) throws IllegalStateException, IOException, LoginRefusedException {
        this.chatLogin(ycl, this.identityIdToObject(this.loginID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void chatLogin(YahooChatLobby ycl, YahooIdentity yid) throws IllegalStateException, IOException, LoginRefusedException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        if (this.chatSessionStatus != 0 && this.chatSessionStatus != 2) {
            throw new IllegalStateException("Chat session should be unstarted or messaging");
        }
        this.chatConnectOver = false;
        this.chatLoginOver = false;
        this.chatID = yid.getId();
        try {
            long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
            if (this.currentLobby == null) {
                this.transmitChatConnect(yid.getId());
                while (!this.chatConnectOver && !this.past(timeout)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.past(timeout)) {
                    throw new InterruptedIOException("Chat connect timed out");
                }
            }
            this.transmitChatLogon(ycl.getNetworkName(), ycl.getParent().getId());
            while (!this.chatLoginOver && !this.past(timeout)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (this.past(timeout)) {
                throw new InterruptedIOException("Chat login timed out");
            }
            if (this.chatSessionStatus == 3 && this.loginException != null) {
                throw (LoginRefusedException)this.loginException;
            }
            this.currentLobby = this.chatSessionStatus == 2 ? ycl : null;
        }
        finally {
            if (this.chatSessionStatus != 2) {
                this.chatSessionStatus = 3;
                this.chatID = null;
            }
        }
    }

    public synchronized void chatLogout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatDisconnect(this.currentLobby.getNetworkName());
        this.currentLobby = null;
    }

    public void sendChatMessage(String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), msg, false);
    }

    public void sendChatEmote(String emote) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), emote, true);
    }

    public YahooChatLobby getCurrentChatLobby() {
        return this.currentLobby;
    }

    public int getChatSessionStatus() {
        return this.chatSessionStatus;
    }

    public void resetChat() throws IllegalStateException {
        if (this.chatSessionStatus != 3 && this.chatSessionStatus != 0) {
            throw new IllegalStateException("Chat session currently active");
        }
        this.chatSessionStatus = 0;
    }

    public void __test1(String a1, String a2) {
        try {
            this.network.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void __test2() {
    }

    protected void transmitAuth() throws IOException {
        this.sessionStatus = 1;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        this.sendPacket(body, 87);
    }

    protected void transmitAuthResp(String plp, String crp, String base64) throws IOException {
        if (base64 == null) {
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("0", this.loginID);
            body.addElement("6", plp);
            body.addElement("96", crp);
            body.addElement("2", this.loginID);
            body.addElement("2", "1");
            body.addElement("244", "2097087");
            body.addElement("148", "180");
            body.addElement("135", "9.0.0.2152");
            body.addElement("1", this.loginID);
            if (this.picture != null && this.getPictureChecksum() != null) {
                body.addElement("192", this.getPictureChecksum());
            }
            this.sendPacket(body, 84, this.status);
        } else {
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID);
            body.addElement("0", this.loginID);
            body.addElement("277", plp);
            body.addElement("278", crp);
            body.addElement("307", base64);
            body.addElement("244", "4194239");
            body.addElement("2", this.loginID);
            body.addElement("2", "1");
            body.addElement("135", "9.0.0.2152");
            if (this.picture != null && this.getPictureChecksum() != null) {
                body.addElement("192", this.getPictureChecksum());
            }
            this.sendPacket(body, 84, this.status);
        }
    }

    protected void transmitChatConnect(String yid) throws IOException {
        this.chatSessionStatus = 100;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("109", this.primaryID);
        body.addElement("1", yid);
        body.addElement("6", "abcde");
        body.addElement("98", YahooChatCategory.getLocale());
        body.addElement("135", "9.0.0.2152");
        this.sendPacket(body, 150);
    }

    protected void transmitChatDisconnect(String room) throws IOException {
        this.chatSessionStatus = 0;
        this.currentLobby = null;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("104", room);
        body.addElement("109", this.chatID);
        this.sendPacket(body, 160);
    }

    protected void transmitChatLogon(String netname, long id) throws IOException {
        this.chatSessionStatus = 1;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID);
        body.addElement("104", netname);
        body.addElement("129", "" + id);
        body.addElement("62", "2");
        this.sendPacket(body, 152);
    }

    protected void transmitChatMsg(String netname, String msg, boolean emote) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID);
        body.addElement("104", netname);
        body.addElement("117", msg);
        if (emote) {
            body.addElement("124", "2");
        } else {
            body.addElement("124", "1");
        }
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, 168);
    }

    protected void transmitChatPM(String to, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("5", to);
        body.addElement("14", msg);
        this.sendPacket(body, 32);
    }

    protected void transmitChatPing() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 161);
    }

    protected void transmitConfAddInvite(String user, String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        int i;
        this.getConference(room);
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("51", user);
        body.addElement("57", room);
        Vector users = this.getConference(room).getUsers();
        for (i = 0; i < users.size(); ++i) {
            body.addElement("52", ((YahooUser)users.elementAt(i)).getId());
        }
        for (i = 0; i < users.size(); ++i) {
            body.addElement("53", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("58", msg);
        body.addElement("13", "0");
        this.sendPacket(body, 28);
    }

    protected void transmitConfDecline(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Vector users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        this.sendPacket(body, 26);
    }

    protected void transmitConfInvite(String[] users, String yid, String room, String msg) throws IOException {
        this.conferences.put(room, new YahooConference(this.userStore, this.identityIdToObject(yid), room, this, false));
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("50", this.primaryID);
        for (int i = 0; i < users.length; ++i) {
            body.addElement("52", users[i]);
        }
        body.addElement("57", room);
        body.addElement("58", msg);
        body.addElement("13", "0");
        this.sendPacket(body, 24);
    }

    protected void transmitConfLogoff(String room, String yid) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Vector users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, 27);
    }

    protected void transmitConfLogon(String room, String yid) throws IOException, NoSuchConferenceException {
        Vector users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, 25);
    }

    protected void transmitConfMsg(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        Vector users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("53", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, 29);
    }

    protected void transmitContactIgnore(String friend, boolean ignore) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("7", friend);
        if (ignore) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "2");
        }
        this.sendPacket(body, 133);
    }

    protected void transmitContactReject(String friend, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("7", friend);
        body.addElement("14", msg);
        this.sendPacket(body, 134);
    }

    protected void transmitRejectBuddy(String friend, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("7", friend);
        body.addElement("13", "2");
        if (msg != null) {
            body.addElement("14", msg);
        }
        this.sendPacket(body, 214);
    }

    protected void transmitAcceptBuddy(String friend, String yid) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("5", friend);
        body.addElement("13", "1");
        this.sendPacket(body, 214);
    }

    protected void transmitFileTransfer(String to, String message, String filename) throws FileTransferFailedException, IOException {
        String in;
        String cookie = this.cookieY + "; " + this.cookieT;
        int fileSize = -1;
        byte[] marker = new byte[]{50, 57, -64, -128};
        DataInputStream dis = new DataInputStream(new FileInputStream(filename));
        fileSize = dis.available();
        if (fileSize <= 0) {
            throw new FileTransferFailedException("File transfer: missing or empty file");
        }
        byte[] fileData = new byte[fileSize];
        dis.readFully(fileData);
        dis.close();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID);
        body.addElement("5", to);
        body.addElement("28", fileSize + "");
        body.addElement("27", new File(filename).getName());
        body.addElement("14", message);
        byte[] packet = body.getBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(MAGIC, 0, 4);
        dos.write(VERSION, 0, 4);
        dos.writeShort(packet.length + 4 & 0xFFFF);
        dos.writeShort(70);
        dos.writeInt((int)(this.status & 0xFFFFFFFFFFFFFFFFL));
        dos.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
        dos.write(packet, 0, packet.length);
        dos.write(marker, 0, 4);
        packet = baos.toByteArray();
        String ftHost = Util.fileTransferHost();
        String ftURL = "http://" + ftHost + ":80/notifyft";
        HTTPConnection conn = new HTTPConnection("POST", new URL(ftURL));
        conn.println("Content-Length: " + (fileSize + packet.length));
        conn.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        conn.println("Host: " + ftHost);
        conn.println("Cookie: " + cookie);
        conn.println("");
        conn.write(packet);
        conn.write(fileData);
        conn.flush();
        String head = in = conn.readLine();
        if (in != null) {
            byte[] buffer = new byte[4096];
            while (conn.read(buffer) > 0) {
            }
        }
        conn.close();
        if (head.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server rejected upload");
        }
    }

    protected void transmitFriendAdd(String friend, String group) throws IOException {
        if (friend.contains("id=")) {
            friend = friend.substring(3, friend.indexOf(" "));
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("302", "319");
        body.addElement("300", "319");
        body.addElement("7", friend);
        body.addElement("241", "0");
        body.addElement("301", "319");
        body.addElement("303", "319");
        body.addElement("65", group);
        body.addElement("14", "");
        body.addElement("216", "");
        body.addElement("254", "");
        body.addElement("97", "1");
        this.sendPacket(body, 131);
    }

    protected void transmitFriendRemove(String friend, String group) throws IOException {
        if (friend.contains("id=")) {
            friend = friend.substring(3, friend.indexOf(" "));
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("7", friend);
        body.addElement("65", group);
        this.sendPacket(body, 132);
    }

    protected void transmitGroupRename(String oldName, String newName) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("65", oldName);
        body.addElement("67", newName);
        this.sendPacket(body, 19);
    }

    protected void transmitIdActivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, 7);
    }

    protected void transmitIdDeactivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, 8);
    }

    protected void transmitIdle() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("0", this.primaryID);
        this.sendPacket(body, 5);
    }

    protected void transmitIsAway() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", this.status + "");
        body.addElement("138", "");
        this.sendPacket(body, 198, 0L);
    }

    protected void transmitIsAway(String msg, boolean a) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.status = 99L;
        body.addElement("10", this.status + "");
        body.addElement("19", msg);
        if (a) {
            body.addElement("47", "1");
        } else {
            body.addElement("47", "0");
        }
        body.addElement("138", "");
        this.sendPacket(body, 198, 0L);
    }

    protected void transmitToggleVisibility(boolean visible) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        if (visible) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "2");
        }
        this.sendPacket(body, 197, 0L);
    }

    protected void transmitIsBack() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", this.status + "");
        body.addElement("138", "");
        this.sendPacket(body, 198, 0L);
    }

    protected void transmitList() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        this.sendPacket(body, 85);
    }

    protected void transmitLogoff() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.loginID);
        this.sendPacket(body, 2);
    }

    protected void transmitMessage(String to, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID);
        body.addElement("1", yid);
        body.addElement("5", to);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        body.addElement("63", ";" + this.imvironment);
        body.addElement("64", "0");
        this.sendPacket(body, 6, 0x5A55AA56L);
        TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(to);
        if (tn != null) {
            tn.stopTyping();
        }
    }

    protected void transmitNotify(String friend, String yid, boolean on, String msg, String mode) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("5", friend);
        body.addElement("14", msg);
        if (on) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "0");
        }
        body.addElement("49", mode);
        this.sendPacket(body, 75, 22L);
    }

    protected void transmitPing() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 18);
    }

    protected void transmitUserStat() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 10);
    }

    protected void receiveAddIgnore(YMSG9Packet pkt) {
    }

    protected void receiveAuth(YMSG9Packet pkt) throws IOException, NoSuchAlgorithmException, LoginRefusedException {
        String[] s;
        String v10 = pkt.getValue("13");
        String seed = pkt.getValue("94");
        try {
            s = v10 != null && v10.equals("1") ? ChallengeResponseV10.getStrings(this.loginID, this.password, seed) : (v10 != null && v10.equals("0") ? ChallengeResponseV9.getStrings(this.loginID, this.password, seed) : this.yahooAuth16Stage1(seed));
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (LoginRefusedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("auth", false, e);
        }
        if (s.length > 2) {
            this.transmitAuthResp(s[0], s[1], s[2]);
        } else {
            this.transmitAuthResp(s[0], s[1], null);
        }
    }

    private void throwLoginRefused(String m, long status) throws LoginRefusedException {
        LoginRefusedException ex = new LoginRefusedException(m, status);
        this.loginException = ex;
        this.ipThread.quit = true;
        this.sessionStatus = 3;
        this.loginOver = true;
        throw ex;
    }

    private String[] yahooAuth16Stage1(String seed) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        int responseCode;
        String authLink = "https://login.yahoo.com/config/pwtoken_get?src=ymsgr&ts=&login=" + this.loginID + "&passwd=" + URLEncoder.encode(this.password, "UTF-8") + "&chal=" + URLEncoder.encode(seed, "UTF-8");
        URL u = new URL(authLink);
        URLConnection uc = u.openConnection();
        if (uc instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)uc).getResponseCode()) == 200) {
            String ymsgr;
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = -1;
            byte[] buff = new byte[256];
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
            StringTokenizer toks = new StringTokenizer(out.toString(), "\r\n");
            if (toks.countTokens() <= 0) {
                this.throwLoginRefused("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uc).getResponseMessage(), -1L);
            }
            int responseNo = -1;
            try {
                responseNo = Integer.valueOf(toks.nextToken());
            }
            catch (NumberFormatException e) {
                this.throwLoginRefused("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uc).getResponseMessage(), -1L);
            }
            if (responseNo != 0 || !toks.hasMoreTokens()) {
                switch (responseNo) {
                    case 1235: {
                        this.throwLoginRefused("Login Failed, Invalid username", 3L);
                    }
                    case 1212: {
                        this.throwLoginRefused("Login Failed, Wrong password", 13L);
                    }
                    case 1213: {
                        this.throwLoginRefused("Login locked: Too many failed login attempts", 14L);
                    }
                    case 1236: {
                        this.throwLoginRefused("Login locked", 14L);
                    }
                    case 100: {
                        this.throwLoginRefused("Username or password missing", 13L);
                    }
                }
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            if ((ymsgr = toks.nextToken()).indexOf("ymsgr=") == -1 && toks.hasMoreTokens()) {
                ymsgr = toks.nextToken();
            }
            ymsgr = ymsgr.replaceAll("ymsgr=", "");
            return this.yahooAuth16Stage2(ymsgr, seed);
        }
        this.throwLoginRefused("Login Failed, unable to retrieve stage 1 url", -1L);
        return new String[0];
    }

    private String[] yahooAuth16Stage2(String token, String seed) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        int responseCode;
        String loginLink = "https://login.yahoo.com/config/pwtoken_login?src=ymsgr&ts=&token=" + token;
        URL u = new URL(loginLink);
        URLConnection uc = u.openConnection();
        if (uc instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)uc).getResponseCode()) == 200) {
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = -1;
            byte[] buff = new byte[256];
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            int responseNo = -1;
            String crumb = null;
            String cookieY = null;
            String cookieT = null;
            StringTokenizer toks = new StringTokenizer(out.toString(), "\r\n");
            if (toks.countTokens() <= 0) {
                this.throwLoginRefused("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uc).getResponseMessage(), -1L);
            }
            try {
                responseNo = Integer.valueOf(toks.nextToken());
            }
            catch (NumberFormatException e) {
                this.throwLoginRefused("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uc).getResponseMessage(), -1L);
            }
            if (responseNo != 0 || !toks.hasMoreTokens()) {
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            while (toks.hasMoreTokens()) {
                String t = toks.nextToken();
                if (t.startsWith("crumb=")) {
                    crumb = t.replaceAll("crumb=", "");
                    continue;
                }
                if (t.startsWith("Y=")) {
                    cookieY = t.replaceAll("Y=", "");
                    continue;
                }
                if (!t.startsWith("T=")) continue;
                cookieT = t.replaceAll("T=", "");
            }
            if (crumb == null || cookieT == null || cookieY == null) {
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            this.cookieY = cookieY;
            this.cookieT = cookieT;
            return this.yahooAuth16Stage3(crumb + seed, cookieY, cookieT);
        }
        this.throwLoginRefused("Login Failed, unable to retrieve stage 2 url", -1L);
        return new String[0];
    }

    private String[] yahooAuth16Stage3(String crypt, String cookieY, String cookieT) throws NoSuchAlgorithmException {
        return ChallengeResponseV16.getStrings(cookieY, cookieT, crypt);
    }

    protected void receiveAuthResp(YMSG9Packet pkt) {
        block10: {
            try {
                if (!pkt.exists("66")) break block10;
                long l = Long.parseLong(pkt.getValue("66"));
                if (l == 14L) {
                    URL u;
                    try {
                        u = new URL(pkt.getValue("20"));
                    }
                    catch (Exception e) {
                        u = null;
                    }
                    this.loginException = new AccountLockedException("User " + this.loginID + " has been locked out", u);
                    break block10;
                }
                if (l == 13L || l == 29L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " refused login", l);
                } else if (l == 3L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", l);
                } else if (l == 99L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ipThread.quit = true;
        this.sessionStatus = 3;
        this.loginOver = true;
    }

    protected void receiveChatConnect(YMSG9Packet pkt) {
        this.chatConnectOver = true;
    }

    protected void receiveChatDisconnect(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 0) {
            new FireEvent().fire(new SessionEvent(this), 160);
        }
        this.chatSessionStatus = 0;
    }

    protected void receiveChatLogoff(YMSG9Packet pkt) {
        try {
            String netname = pkt.getValue("104");
            String id = pkt.getValue("109");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(id);
            if (ycu != null) {
                ycl.removeUser(ycu);
            } else {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, 1, ycl);
            se.setChatUser(0, ycu);
            new FireEvent().fire(se, 155);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat logoff", false, e);
        }
    }

    protected void receiveChatLogon(YMSG9Packet pkt) {
        boolean joining = false;
        try {
            int cnt;
            if (pkt.exists("114")) {
                this.loginException = new LoginRefusedException("User " + this.chatID + " refused chat login");
                joining = true;
                this.chatSessionStatus = 3;
                return;
            }
            if ((pkt = this.compoundChatLoginPacket(pkt)) == null) {
                return;
            }
            String netname = pkt.getValue("104");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            for (cnt = Integer.parseInt(pkt.getValue("108")); cnt > 0 && pkt.getNthValue("109", cnt - 1) == null; --cnt) {
            }
            YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
            if (cnt == 1 && ycu != null) {
                ycu.update(pkt.getValue("113"), pkt.getValue("141"), pkt.getValue("110"), pkt.getValue("142"));
                SessionChatEvent se = new SessionChatEvent((Object)this, 1, ycl);
                se.setChatUser(0, ycu);
                new FireEvent().fire(se, 3844);
                return;
            }
            this.currentLobby = ycl;
            joining = pkt.exists("13");
            if (joining) {
                ycl.clearUsers();
            }
            Hashtable<String, YahooChatUser> ht = new Hashtable<String, YahooChatUser>();
            for (int i = 0; i < cnt; ++i) {
                ycu = this.createChatUser(pkt, i);
                ht.put(ycu.getId(), ycu);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, cnt, ycl);
            int i = 0;
            Enumeration en = ht.elements();
            while (en.hasMoreElements()) {
                ycu = (YahooChatUser)en.nextElement();
                if (!ycl.exists(ycu)) {
                    ycl.addUser(ycu);
                }
                se.setChatUser(i++, ycu);
            }
            if (!joining) {
                if (se.getChatUsers().length > 0) {
                    new FireEvent().fire(se, 152);
                }
            } else {
                this.chatSessionStatus = 2;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new YMSG9BadFormatException("chat login", false, e);
        }
        finally {
            if (joining) {
                this.chatLoginOver = true;
            }
        }
    }

    protected void receiveChatMsg(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            String netname = pkt.getValue("104");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
            if (ycu == null) {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, ycu, pkt.getValue("117"), pkt.getValue("124"), ycl);
            new FireEvent().fire(se, 168);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat message", false, e);
        }
    }

    protected void receiveChatPM(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
            new FireEvent().fire(se, 6);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat PM", false, e);
        }
    }

    protected void receiveConfAddInvite(YMSG9Packet pkt) {
        this.receiveConfInvite(pkt);
    }

    protected void receiveConfDecline(YMSG9Packet pkt) {
        try {
            YahooConference yc = this.getOrCreateConference(pkt);
            SessionConferenceEvent se = new SessionConferenceEvent(this, pkt.getValue("1"), pkt.getValue("54"), pkt.getValue("14"), yc, null);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 26);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference decline", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfInvite(YMSG9Packet pkt) {
        try {
            YahooConference yc = this.getOrCreateConference(pkt);
            String[] users = pkt.getValues("52");
            SessionConferenceEvent se = new SessionConferenceEvent(this, pkt.getValue("1"), pkt.getValue("50"), pkt.getValue("58"), yc, this.userStore.toUserArray(users));
            yc.addUsers(users);
            yc.addUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 24);
            }
            YahooConference yahooConference = yc;
            synchronized (yahooConference) {
                Vector v = yc.inviteReceived();
                for (int i = 0; i < v.size(); ++i) {
                    this.ipThread.process((YMSG9Packet)v.elementAt(i));
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference invite", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogoff(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("56"), null, yc);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 27);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logoff", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogon(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("53"), null, yc);
            yc.addUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 25);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logon", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfMsg(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("3"), pkt.getValue("14"), yc);
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 29);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference mesg", false, e);
        }
    }

    protected void receiveContactIgnore(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("0");
            boolean ig = pkt.getValue("13").charAt(0) == '1';
            int st = Integer.parseInt(pkt.getValue("66"));
            if (st == 0) {
                YahooUser yu = this.userStore.getOrCreate(n);
                yu.setIgnored(ig);
                SessionFriendEvent se = new SessionFriendEvent(this, 1);
                se.setUser(0, yu);
                new FireEvent().fire(se, 3);
            } else {
                String m = "Contact ignore error: ";
                switch (st) {
                    case 2: {
                        m = m + "Already on ignore list";
                        break;
                    }
                    case 3: {
                        m = m + "Not currently ignored";
                        break;
                    }
                    case 12: {
                        m = m + "Cannot ignore friend";
                        break;
                    }
                    default: {
                        m = m + "Unknown error";
                    }
                }
                this.errorMessage(pkt, m);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact ignore", false, e);
        }
    }

    protected void receiveContactNew(YMSG9Packet pkt) {
        try {
            if (pkt.length <= 0) {
                return;
            }
            if (pkt.exists("7")) {
                this.updateFriendsStatus(pkt);
                return;
            }
            if (pkt.status == 7L) {
                SessionEvent se = new SessionEvent(this, null, pkt.getValue("3"), pkt.getValue("14"));
                new FireEvent().fire(se, 134);
            } else {
                SessionEvent se = new SessionEvent(this, pkt.getValue("1"), pkt.getValue("3"), pkt.getValue("14"), pkt.getValue("15"));
                se.setStatus(pkt.status);
                new FireEvent().fire(se, 15);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact request", false, e);
        }
    }

    protected void receiveAuthorization(YMSG9Packet pkt) {
        try {
            if (pkt.length <= 0) {
                return;
            }
            String who = pkt.getValue("4");
            String msg = pkt.getValue("14");
            String fname = pkt.getValue("216");
            String lname = pkt.getValue("254");
            String id = pkt.getValue("5");
            int state = -1;
            String stateStr = pkt.getValue("13");
            if (stateStr != null) {
                try {
                    state = Integer.parseInt(stateStr);
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.FINER, "state not a number", ex);
                }
            }
            SessionAuthorizationEvent se = new SessionAuthorizationEvent(this, id, who, fname, lname, msg);
            se.setStatus(state);
            new FireEvent().fire(se, 214);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact request", false, e);
        }
    }

    protected void receiveFileTransfer(YMSG9Packet pkt) {
        try {
            if (!pkt.exists("38")) {
                SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
                new FireEvent().fire(se, 6);
            } else {
                SessionFileTransferEvent se = new SessionFileTransferEvent((Object)this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"), pkt.getValue("38"), pkt.getValue("20"));
                new FireEvent().fire(se, 70);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("file transfer", false, e);
        }
    }

    protected void receiveFriendAdd(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("7");
            String s = pkt.getValue("66");
            String g = pkt.getValue("65");
            YahooUser yu = this.userStore.getOrCreate(n);
            this.insertFriend(yu, g);
            SessionFriendEvent se = new SessionFriendEvent((Object)this, yu, g);
            new FireEvent().fire(se, 131);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend added", false, e);
        }
    }

    protected void receiveFriendRemove(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("7");
            String g = pkt.getValue("65");
            YahooUser yu = this.userStore.get(n);
            if (yu == null) {
                this.report("Unknown friend", pkt);
                return;
            }
            this.deleteFriend(yu, g);
            SessionFriendEvent se = new SessionFriendEvent((Object)this, yu, g);
            new FireEvent().fire(se, 132);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend removed", false, e);
        }
    }

    protected void receiveIdAct(YMSG9Packet pkt) {
    }

    protected void receiveIdDeact(YMSG9Packet pkt) {
    }

    protected void receiveIsAway(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    private void receiveStatus15(YMSG9Packet pkt) {
        String v;
        YahooUser current = null;
        String message = null;
        ArrayList<YahooUser> us = new ArrayList<YahooUser>();
        boolean loginStatus = false;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("7")) {
                if (current != null && message != null) {
                    current.setCustomStatusMessage(message);
                }
                message = null;
                current = null;
                current = this.userStore.getOrCreate(en[1]);
                us.add(current);
                continue;
            }
            if (key.equals("10")) {
                if (current == null) continue;
                int stat = Integer.parseInt(en[1]);
                current.status = stat;
                continue;
            }
            if (key.equals("19")) {
                message = en[1];
                continue;
            }
            if (key.equals("13")) {
                if (!en[1].equals("0")) continue;
                current.status = 0x5A55AA56L;
                continue;
            }
            if (key.equals("192")) continue;
            if (key.equals("241")) {
                loginStatus = true;
                continue;
            }
            if (!key.equals("244")) continue;
            try {
                if (current == null) continue;
                current.versionId = Long.valueOf(en[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (us.size() > 0) {
            SessionFriendEvent se = new SessionFriendEvent(this, us.size());
            for (int i = 0; i < us.size(); ++i) {
                YahooUser yahooUser = (YahooUser)us.get(i);
                se.setUser(i, yahooUser);
            }
            new FireEvent().fire(se, 3);
        }
        if (((v = pkt.getValue("7")) != null || loginStatus) && !this.loginOver) {
            this.sessionStatus = 2;
            this.loginOver = true;
            this.identities = new YahooIdentity[1];
            this.identities[0] = new YahooIdentity(this.loginID);
            this.primaryID = this.loginID;
            this.identityIdToObject(this.primaryID).setPrimaryIdentity(true);
            this.identityIdToObject(this.loginID).setLoginIdentity(true);
            if (!this.receivedListFired) {
                new FireEvent().fire(new SessionEvent(this), 85);
            }
        }
    }

    protected void receiveIsBack(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    protected void receiveList(YMSG9Packet pkt) {
        String[] concatFields = new String[]{"87", "88", "89"};
        if (this.cachePacket == null) {
            this.cachePacket = pkt;
        } else {
            this.cachePacket.merge(pkt, concatFields);
        }
        if (pkt.exists("59")) {
            this._receiveList(this.cachePacket);
        }
    }

    private void _receiveList(YMSG9Packet pkt) {
        StringTokenizer st;
        String s;
        try {
            s = pkt.getValue("87");
            if (s != null) {
                StringTokenizer st1 = new StringTokenizer(s, "\n");
                this.groups = new YahooGroup[st1.countTokens()];
                int i = 0;
                while (st1.hasMoreTokens()) {
                    String s1 = st1.nextToken();
                    this.groups[i] = new YahooGroup(s1.substring(0, s1.indexOf(":")));
                    StringTokenizer st2 = new StringTokenizer(s1.substring(s1.indexOf(":") + 1), ",");
                    while (st2.hasMoreTokens()) {
                        String k = st2.nextToken();
                        YahooUser yu = this.userStore.getOrCreate(k);
                        this.groups[i].addUser(yu);
                        yu.adjustGroupCount(1);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friends list in list", false, e);
        }
        try {
            s = pkt.getValue("88");
            if (s != null) {
                st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                    YahooUser yu = this.userStore.getOrCreate(s);
                    yu.setIgnored(true);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("ignored list in list", false, e);
        }
        try {
            s = pkt.getValue("89");
            if (s != null) {
                st = new StringTokenizer(s, ",");
                int i = 0;
                this.identities = new YahooIdentity[st.countTokens()];
                while (st.hasMoreTokens()) {
                    this.identities[i++] = new YahooIdentity(st.nextToken());
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("identities list in list", false, e);
        }
        try {
            String[] ck = ConnectionHandler.extractCookies(pkt);
            this.cookieY = ck[0];
            this.cookieT = ck[1];
            this.cookieC = ck[2];
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("cookies in list", false, e);
        }
        try {
            this.primaryID = pkt.exists("3") ? pkt.getValue("3").trim() : this.loginID;
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("primary identity in list", false, e);
        }
        this.identityIdToObject(this.primaryID).setPrimaryIdentity(true);
        this.identityIdToObject(this.loginID).setLoginIdentity(true);
        if (this.loginOver) {
            new FireEvent().fire(new SessionEvent(this), 85);
        }
    }

    private void receiveList15(YMSG9Packet pkt) {
        String temp = null;
        YahooGroup currentListGroup = null;
        Vector<YahooGroup> receivedGroups = new Vector<YahooGroup>();
        for (String[] s : pkt.entries()) {
            int key = Integer.valueOf(s[0]);
            String value = s[1];
            switch (key) {
                case 302: {
                    if (value == null || !value.equals("320")) break;
                    currentListGroup = null;
                    break;
                }
                case 301: {
                    YahooUser yu;
                    if (temp == null) break;
                    if (currentListGroup != null) {
                        yu = this.userStore.getOrCreate(temp);
                        currentListGroup.addUser(yu);
                        yu.adjustGroupCount(1);
                    } else {
                        yu = this.userStore.getOrCreate(temp);
                        yu.setIgnored(true);
                    }
                    temp = null;
                    break;
                }
                case 300: {
                    break;
                }
                case 65: {
                    currentListGroup = new YahooGroup(value);
                    receivedGroups.add(currentListGroup);
                    break;
                }
                case 7: {
                    temp = value;
                    break;
                }
                case 241: {
                    break;
                }
                case 59: {
                    break;
                }
            }
        }
        this.groups = new YahooGroup[receivedGroups.size()];
        this.groups = receivedGroups.toArray(this.groups);
        if (this.loginOver) {
            this.receivedListFired = true;
            new FireEvent().fire(new SessionEvent(this), 85);
        }
    }

    protected void receiveLogoff(YMSG9Packet pkt) {
        if (!pkt.exists("7")) {
            this.sessionStatus = 0;
            this.ipThread.quit = true;
        } else {
            try {
                this.updateFriendsStatus(pkt);
            }
            catch (Exception e) {
                throw new YMSG9BadFormatException("online friends in logoff", false, e);
            }
        }
    }

    protected void receiveLogon(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            try {
                this.updateFriendsStatus(pkt);
            }
            catch (Exception e) {
                throw new YMSG9BadFormatException("online friends in logon", false, e);
            }
        }
        if (!this.loginOver) {
            try {
                if (this.status == 0L) {
                    this.transmitIsBack();
                } else {
                    this.transmitIsAway();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sessionStatus = 2;
            this.loginOver = true;
        }
    }

    protected void receiveMessage(YMSG9Packet pkt) {
        try {
            if (!pkt.exists("14")) {
                return;
            }
            if (pkt.status == 5L) {
                int i = 0;
                String s = pkt.getNthValue("31", i);
                while (s != null) {
                    SessionEvent se = new SessionEvent(this, pkt.getNthValue("5", i), pkt.getNthValue("4", i), pkt.getNthValue("14", i), pkt.getNthValue("15", i));
                    new FireEvent().fire(se, 3841);
                    s = pkt.getNthValue("31", ++i);
                }
            } else {
                String from = pkt.getValue("4");
                SessionEvent se = new SessionEvent(this, pkt.getValue("5"), from, pkt.getValue("14"));
                if (se.getMessage().equalsIgnoreCase("<ding>")) {
                    new FireEvent().fire(se, 3843);
                } else {
                    new FireEvent().fire(se, 6);
                }
                String id = pkt.getValue("429");
                if (id != null) {
                    PacketBodyBuffer body = new PacketBodyBuffer();
                    body.addElement("1", this.loginID);
                    body.addElement("5", from);
                    body.addElement("302", "430");
                    body.addElement("430", id);
                    body.addElement("303", "430");
                    body.addElement("450", "0");
                    this.sendPacket(body, 251, this.status);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("message", false, e);
        }
    }

    protected void receiveNewMail(YMSG9Packet pkt) {
        try {
            SessionNewMailEvent se = !pkt.exists("43") ? new SessionNewMailEvent(this, pkt.getValue("9")) : new SessionNewMailEvent(this, pkt.getValue("43"), pkt.getValue("42"), pkt.getValue("18"));
            new FireEvent().fire(se, 11);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("new mail", false, e);
        }
    }

    protected void receiveNotify(YMSG9Packet pkt) {
        try {
            if (pkt.status == 1L) {
                SessionNotifyEvent se = new SessionNotifyEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"), pkt.getValue("49"), pkt.getValue("13"));
                se.setStatus(pkt.status);
                new FireEvent().fire(se, 75);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("notify", false, e);
        }
    }

    protected void receivePing(YMSG9Packet pkt) {
    }

    protected void receiveUserStat(YMSG9Packet pkt) {
        this.status = pkt.status;
    }

    protected void erroneousChatLogin(YMSG9Packet pkt) {
        this.chatSessionStatus = 3;
        this.chatLoginOver = true;
    }

    protected void sendPacket(PacketBodyBuffer body, int service, long status) throws IOException {
        this.network.sendPacket(body, service, status, this.sessionId);
    }

    protected void sendPacket(PacketBodyBuffer body, int service) throws IOException {
        this.sendPacket(body, service, 0L);
    }

    private void report(String s, YMSG9Packet p) {
        System.err.println(s + "\n" + p.toString() + "\n");
    }

    private boolean past(long time) {
        return System.currentTimeMillis() > time;
    }

    private void startThreads() {
        this.ipThread = new InputThread();
        this.pingThread = new PingThread();
    }

    private void closeNetwork() {
        if (this.pingThread != null) {
            this.pingThread.quit = true;
            this.pingThread.interrupt();
        }
        if (this.network != null) {
            try {
                this.network.close();
                this.network = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (this.sessionStatus != 2) {
            throw new IllegalStateException("Not logged in");
        }
    }

    private void checkChatStatus() throws IllegalStateException {
        if (this.chatSessionStatus != 2) {
            throw new IllegalStateException("Not logged in to a chatroom");
        }
    }

    private YahooIdentity identityIdToObject(String yid) {
        for (int i = 0; i < this.identities.length; ++i) {
            if (!yid.equals(this.identities[i].getId())) continue;
            return this.identities[i];
        }
        return null;
    }

    private void checkIdentity(YahooIdentity yid) throws IllegalIdentityException {
        for (int i = 0; i < this.identities.length; ++i) {
            if (yid != this.identities[i]) continue;
            return;
        }
        throw new IllegalIdentityException(yid + " not a valid identity for this session");
    }

    private void checkIdentityNotOnList(String[] yids) {
        for (int i = 0; i < yids.length; ++i) {
            if (this.identityIdToObject(yids[i]) == null) continue;
            throw new IllegalIdentityException(yids[i] + " is an identity of this session and cannot be used here");
        }
    }

    private void resetData() {
        this.primaryID = null;
        this.loginID = null;
        this.password = null;
        this.cookieY = null;
        this.cookieT = null;
        this.cookieC = null;
        this.imvironment = null;
        this.customStatusMessage = null;
        this.customStatusBusy = false;
        this.groups = null;
        this.identities = null;
        this.clearTypingNotifiers();
        this.loginOver = false;
        this.loginException = null;
        this.chatConnectOver = false;
        this.chatLoginOver = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTypingNotifiers() {
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            Enumeration e = this.typingNotifiers.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
                tn.quit = true;
                tn.interrupt();
                this.typingNotifiers.remove(key);
            }
        }
    }

    private void errorMessage(YMSG9Packet pkt, String m) {
        if (m == null) {
            m = pkt.getValue("16");
        }
        SessionErrorEvent se = new SessionErrorEvent((Object)this, m, pkt.service);
        if (pkt.exists("114")) {
            se.setCode(Integer.parseInt(pkt.getValue("114").trim()));
        }
        new FireEvent().fire(se, 3840);
    }

    private YMSG9Packet compoundChatLoginPacket(YMSG9Packet pkt) {
        if (pkt.status == 5L) {
            if (this.cachePacket == null) {
                this.cachePacket = pkt;
            } else {
                this.cachePacket.append(pkt);
            }
            return null;
        }
        if (pkt.status == 1L) {
            if (this.cachePacket != null) {
                this.cachePacket.append(pkt);
                pkt = this.cachePacket;
                this.cachePacket = null;
            }
            return pkt;
        }
        return pkt;
    }

    private void updateFriendsStatus(YMSG9Packet pkt) {
        boolean logoff;
        String s = pkt.getValue("8");
        if (s == null && pkt.getValue("7") != null) {
            s = "1";
        }
        boolean bl = logoff = pkt.service == 2;
        if (s != null) {
            int cnt = Integer.parseInt(s);
            SessionFriendEvent se = new SessionFriendEvent(this, cnt);
            for (int i = 0; i < cnt; ++i) {
                YahooUser yu = this.userStore.get(pkt.getNthValue("7", i));
                if (yu == null) {
                    String n = pkt.getNthValue("7", i);
                    yu = this.userStore.getOrCreate(n);
                }
                if (pkt.exists("17")) {
                    yu.update(pkt.getNthValue("7", i), logoff ? "1515563606" : pkt.getNthValue("10", i), pkt.getNthValue("17", i), pkt.getNthValue("13", i));
                } else {
                    yu.update(pkt.getNthValue("7", i), logoff ? "1515563606" : pkt.getNthValue("10", i), pkt.getNthValue("13", i));
                }
                if (pkt.getNthValue("19", i) != null && pkt.getNthValue("47", i) != null) {
                    yu.setCustom(pkt.getNthValue("19", i), pkt.getNthValue("47", i));
                }
                se.setUser(i, yu);
            }
            new FireEvent().fire(se, 3);
        }
    }

    private void insertFriend(YahooUser yu, String gr) {
        int idx;
        for (idx = 0; idx < this.groups.length && !this.groups[idx].getName().equalsIgnoreCase(gr); ++idx) {
        }
        if (idx >= this.groups.length) {
            int j;
            YahooGroup[] arr = new YahooGroup[this.groups.length + 1];
            boolean k = false;
            for (j = 0; j < this.groups.length && this.groups[j].getName().compareTo(gr) < 0; ++j) {
                arr[j] = this.groups[j];
            }
            idx = j;
            arr[idx] = new YahooGroup(gr);
            while (j < this.groups.length) {
                arr[j + 1] = this.groups[j];
                ++j;
            }
            this.groups = arr;
        }
        if (this.groups[idx].getIndexOfFriend(yu.getId()) < 0) {
            this.groups[idx].addUser(yu);
            yu.adjustGroupCount(1);
        }
    }

    private void deleteFriend(YahooUser yu, String gr) {
        int idx;
        for (idx = 0; idx < this.groups.length && !this.groups[idx].getName().equalsIgnoreCase(gr); ++idx) {
        }
        if (idx >= this.groups.length) {
            return;
        }
        int j = this.groups[idx].getIndexOfFriend(yu.getId());
        if (j < 0) {
            return;
        }
        this.groups[idx].removeUserAt(j);
        yu.adjustGroupCount(-1);
        if (this.groups[idx].isEmpty()) {
            YahooGroup[] arr = new YahooGroup[this.groups.length - 1];
            for (j = 0; j < idx; ++j) {
                arr[j] = this.groups[j];
            }
            for (j = idx; j < arr.length; ++j) {
                arr[j] = this.groups[j + 1];
            }
            this.groups = arr;
        }
    }

    private YahooChatUser createChatUser(YMSG9Packet pkt, int i) {
        YahooUser yu = this.userStore.getOrCreate(pkt.getNthValue("109", i));
        return new YahooChatUser(yu, pkt.getValueFromNthSet("109", "113", i), pkt.getValueFromNthSet("109", "141", i), pkt.getValueFromNthSet("109", "110", i), pkt.getValueFromNthSet("109", "142", i));
    }

    private String getConferenceName(String yid) {
        return yid + "-" + this.conferenceCount++;
    }

    private YahooConference getConference(String room) throws NoSuchConferenceException {
        YahooConference yc = (YahooConference)this.conferences.get(room);
        if (yc == null) {
            throw new NoSuchConferenceException("Conference " + room + " not found.");
        }
        return yc;
    }

    private YahooConference getOrCreateConference(YMSG9Packet pkt) {
        String room = pkt.getValue("57");
        YahooIdentity yid = this.identityIdToObject(pkt.getValue("1"));
        YahooConference yc = (YahooConference)this.conferences.get(room);
        if (yc == null) {
            yc = new YahooConference(this.userStore, yid, room, this);
            this.conferences.put(room, yc);
        }
        return yc;
    }

    public static void dump(Session s) {
        YahooUser yu;
        YahooGroup[] yg = s.getGroups();
        for (int i = 0; i < yg.length; ++i) {
            System.out.print(yg[i].getName() + ": ");
            Vector v = yg[i].getMembers();
            for (int j = 0; j < v.size(); ++j) {
                yu = (YahooUser)v.elementAt(j);
                System.out.print(yu.getId() + " ");
            }
            System.out.print("\n");
        }
        Hashtable h = s.userStore.getUsers();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            yu = (YahooUser)h.get(k);
            System.out.println(k + " = " + yu.getId());
        }
        YahooIdentity[] ya = s.getIdentities();
        for (int i = 0; i < ya.length; ++i) {
            System.out.print(ya[i].getId() + " ");
        }
        System.out.print("\n");
    }

    public void requestPicture(String friend) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("5", friend);
        body.addElement("13", "1");
        this.sendPacket(body, 190);
    }

    protected void receivePicture(YMSG9Packet pkt) {
        String who = null;
        String us = null;
        boolean gotIconInfo = false;
        boolean sendIconInfo = false;
        String url = null;
        int checksum = 0;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("1") || key.equals("4")) {
                who = en[1];
                continue;
            }
            if (key.equals("5")) {
                us = en[1];
                continue;
            }
            if (key.equals("13")) {
                if (en[1].equals("1")) {
                    sendIconInfo = true;
                    continue;
                }
                gotIconInfo = true;
                continue;
            }
            if (key.equals("20")) {
                url = en[1];
                continue;
            }
            if (!key.equals("192")) continue;
            checksum = Integer.valueOf(en[1]);
        }
        if (who != null && gotIconInfo && url != null) {
            try {
                int bytesRead;
                URL imgUrl = new URL(url);
                InputStream imgIn = imgUrl.openStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                while ((bytesRead = imgIn.read(buff)) > 0) {
                    out.write(buff, 0, bytesRead);
                }
                imgIn.close();
                YahooUser user = this.userStore.get(who);
                if (user != null) {
                    user.setImage(out.toByteArray());
                }
                SessionPictureEvent se = new SessionPictureEvent((Object)this, us, who, out.toByteArray());
                new FireEvent().fire(se, 190);
            }
            catch (Exception e) {
                logger.warning("Error retreiving picture " + e.getMessage());
            }
        } else {
            try {
                this.sendPictureInfo(who);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Cannot send our picture info", ex);
            }
        }
    }

    protected void receivePictureUpdate(YMSG9Packet pkt) {
        String who = null;
        String icon = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                who = en[1];
                continue;
            }
            if (!key.equals("206") && !key.equals("213")) continue;
            icon = en[1];
        }
        if (who != null) {
            if (icon.equals("2")) {
                try {
                    this.requestPicture(who);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Cannot send picture request", ex);
                }
            } else if (icon.equals("0") || icon.equals("1")) {
                SessionPictureEvent se = new SessionPictureEvent((Object)this, null, who, null);
                new FireEvent().fire(se, 190);
            }
        }
    }

    protected void receivePictureUpload(YMSG9Packet pkt) {
        String url = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (!key.equals("20")) continue;
            url = en[1];
        }
        if (url != null) {
            this.pictureURL = url;
            try {
                this.sendPictureChecksum();
                this.sendPictureUpdate(2);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Cannot send picture update", ex);
            }
        }
    }

    private void sendPictureChecksum() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("212", "1");
        body.addElement("192", this.getPictureChecksum());
        this.sendPacket(body, 189);
    }

    private void sendPictureUpdate(int type) throws IOException {
        for (String key : this.userStore.getUsers().keySet()) {
            YahooUser u = this.userStore.get(key);
            if (u == null) continue;
            this.sendPictureUpdate(key, type);
        }
    }

    private void sendPictureUpdate(String who, int type) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("5", who);
        body.addElement("206", String.valueOf(type));
        this.sendPacket(body, 193);
    }

    protected void receivePictureChecksum(YMSG9Packet pkt) {
        String localChecksum;
        YahooUser yahooUser;
        String who = null;
        int checksum = 0;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                who = en[1];
                continue;
            }
            if (!key.equals("192")) continue;
            checksum = Integer.valueOf(en[1]);
        }
        if (who != null && (yahooUser = this.userStore.get(who)) != null && (localChecksum = this.getPictureChecksum(yahooUser.getImage())) != null && localChecksum.equals(String.valueOf(checksum))) {
            try {
                this.requestPicture(who);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Cannot send picture request", ex);
            }
        }
    }

    protected void receiveAvatarUpdate(YMSG9Packet pkt) {
        String who = null;
        String avatar = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                who = en[1];
                continue;
            }
            if (!key.equals("206")) continue;
            avatar = en[1];
        }
        if (who != null) {
            if (avatar == null || avatar.equals("2")) {
                try {
                    this.requestPicture(who);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Cannot send picture request", ex);
                }
            } else if (avatar.equals("0") || avatar.equals("1")) {
                SessionPictureEvent se = new SessionPictureEvent((Object)this, null, who, null);
                new FireEvent().fire(se, 190);
            }
        }
    }

    public void setSessionPicture(SessionPicture p) {
        this.picture = p;
        if (this.sessionStatus == 2) {
            try {
                this.updateBuddyPicture();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot update picture", e);
            }
        }
    }

    private void sendPictureInfo(String who) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("4", this.loginID);
        body.addElement("5", who);
        body.addElement("13", "2");
        body.addElement("20", this.pictureURL);
        body.addElement("192", this.getPictureChecksum());
        this.sendPacket(body, 190);
    }

    private void updateBuddyPicture() throws IOException {
        byte[] image = this.picture.getPicture();
        if (image == null) {
            this.sendPictureUpdate(0);
        } else {
            String in;
            try {
                BufferedImage i = ImageIO.read(new ByteArrayInputStream(image));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)i, "png", out);
                image = out.toByteArray();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "error converting picture to png", e);
            }
            String cookie = "T=" + this.cookieT + "; Y=" + this.cookieY;
            int fileSize = image.length;
            byte[] marker = new byte[]{50, 57, -64, -128};
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID);
            body.addElement("38", "604800");
            body.addElement("0", this.loginID);
            body.addElement("28", String.valueOf(image.length));
            body.addElement("27", this.picture.getPictureFileName() + ".png");
            body.addElement("14", "");
            byte[] packet = body.getBuffer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(MAGIC, 0, 4);
            dos.write(VERSION, 0, 4);
            dos.writeShort(packet.length + 4 & 0xFFFF);
            dos.writeShort(194);
            dos.writeInt((int)(this.status & 0xFFFFFFFFFFFFFFFFL));
            dos.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
            dos.write(packet, 0, packet.length);
            dos.write(marker, 0, 4);
            packet = baos.toByteArray();
            String ftHost = Util.fileTransferHost();
            String ftURL = "http://" + ftHost + ":80/notifyft";
            HTTPConnection conn = new HTTPConnection("POST", new URL(ftURL));
            conn.println("Content-Length: " + (fileSize + packet.length));
            conn.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
            conn.println("Host: " + ftHost);
            conn.println("Cookie: " + cookie);
            conn.println("Cache-Control: no-cache");
            conn.println("");
            conn.write(packet);
            conn.write(image);
            conn.flush();
            String head = in = conn.readLine();
            if (in != null) {
                byte[] buffer = new byte[4096];
                while (conn.read(buffer) > 0) {
                }
            }
            conn.close();
            if (head.indexOf(" 200 ") < 0) {
                throw new FileTransferFailedException("Server rejected picture upload");
            }
        }
    }

    private String getPictureChecksum() {
        if (this.picture == null || this.picture.getPicture() == null) {
            return "";
        }
        return this.getPictureChecksum(this.picture.getPicture());
    }

    private String getPictureChecksum(byte[] data) {
        if (data == null) {
            return null;
        }
        int checksum = 0;
        int i = data.length;
        int ix = 0;
        while (i-- > 0) {
            int g;
            if ((g = (checksum = (checksum << 4) + data[ix++]) & 0xF0000000) != 0) {
                checksum ^= g >> 23;
            }
            checksum &= ~g;
        }
        return String.valueOf(checksum);
    }

    private String xferNewId() {
        char[] chars = new char[24];
        Arrays.fill(chars, ' ');
        chars[22] = 36;
        chars[23] = 36;
        Random r = new Random();
        for (int i = 0; i < 22; ++i) {
            int j = r.nextInt(61);
            chars[i] = j < 26 ? (char)(j + 97) : (j < 52 ? (char)(j - 26 + 65) : (char)(j - 52 + 48));
        }
        return new String(chars);
    }

    private void xferCancelRemote(String xferId, List<String> fileNames, boolean event) {
        if (event) {
            XFer xfer = this.currentTransfers.get(xferId);
            int state = 1;
            if (xfer.sending && xfer.sendFileThread != null) {
                xfer.sendFileThread.cancel();
            } else if (xfer.receiveFileThread == null) {
                state = 6;
            }
            SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)this, xfer.to, xfer.from, xfer.xferPeerIDstring, state);
            new FireEvent().fire(ev, 220);
            this.currentTransfers.remove(xferId);
        }
    }

    protected void receiveFiletrans15(YMSG9Packet pkt) throws IOException {
        XFer xfer = new XFer();
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                xfer.from = en[1];
                continue;
            }
            if (key.equals("5")) {
                xfer.to = en[1];
                continue;
            }
            if (key.equals("265")) {
                xfer.xferPeerIDstring = en[1];
                continue;
            }
            if (key.equals("27")) {
                xfer.fileNames.add(en[1]);
                continue;
            }
            if (key.equals("28")) {
                xfer.fileSizes.add(en[1]);
                continue;
            }
            if (key.equals("222")) {
                try {
                    xfer.val_222 = Long.valueOf(en[1]);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (key.equals("49")) {
                xfer.service = en[1];
                continue;
            }
            if (!key.equals("63")) continue;
            xfer.imv = en[1];
        }
        if (xfer.xferPeerIDstring == null) {
            return;
        }
        if (xfer.val_222 == 2L || xfer.val_222 == 4L) {
            xfer = this.currentTransfers.get(xfer.xferPeerIDstring);
            this.xferCancelRemote(xfer.xferPeerIDstring, xfer.fileNames, true);
            return;
        }
        if (xfer.val_222 == 3L) {
            xfer = this.currentTransfers.get(xfer.xferPeerIDstring);
            if (xfer == null) {
                return;
            }
            int fileIx = this.getNextFileIx(xfer);
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID);
            body.addElement("5", xfer.to);
            body.addElement("265", xfer.xferPeerIDstring);
            body.addElement("27", new File(xfer.fileNames.get(fileIx)).getName());
            body.addElement("249", "3");
            body.addElement("250", InetAddress.getByName("relay.msg.yahoo.com").getHostAddress());
            this.sendPacket(body, 221);
            return;
        }
        if (xfer.from == null) {
            return;
        }
        this.currentTransfers.put(xfer.xferPeerIDstring, xfer);
        SessionFileTransferEvent se = new SessionFileTransferEvent(this, xfer.to, xfer.from, xfer.fileNames, xfer.fileSizes, xfer.xferPeerIDstring, 0);
        new FireEvent().fire(se, 220);
    }

    public void fileTransferAccept(String id, File file) {
        try {
            this.xferAccept(id, file);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot accept file transfer!", e);
        }
    }

    private void xferAccept(String id, File file) throws IOException {
        XFer xfer = this.currentTransfers.get(id);
        xfer.receiveFile = file;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("5", xfer.from);
        body.addElement("265", id);
        body.addElement("222", "3");
        this.sendPacket(body, 220);
    }

    public void cancelRunningFileTransfer(String id) {
        try {
            this.xferCancel(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot cancel file transfer!", e);
        }
    }

    public void fileTransferReject(String id) {
        try {
            this.xferCancel(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot reject file transfer!", e);
        }
    }

    private void xferCancel(String id) throws IOException {
        XFer xfer = this.currentTransfers.get(id);
        if (xfer == null) {
            return;
        }
        if (xfer.sendFileThread != null) {
            xfer.sendFileThread.cancel();
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        String toVal = null;
        toVal = this.loginID.equals(xfer.to) ? xfer.from : xfer.to;
        body.addElement("5", toVal);
        body.addElement("265", id);
        body.addElement("66", "-1");
        this.sendPacket(body, 222, -1L);
        SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)this, xfer.to, xfer.from, xfer.xferPeerIDstring, 1);
        new FireEvent().fire(ev, 220);
        this.currentTransfers.remove(id);
    }

    protected void receiveP2P(YMSG9Packet pkt) {
        String who = null;
        String peerIP = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                who = en[1];
                continue;
            }
            if (!key.equals("12")) continue;
            peerIP = en[1];
        }
    }

    protected void receiveFiletransInfo15(YMSG9Packet pkt) throws IOException {
        String from = null;
        String to = null;
        String urlStr = null;
        String val_249 = null;
        long val_66 = 0L;
        String filename = null;
        String xferPeerIdString = null;
        String xferPeerIdStringForRelay = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("4")) {
                from = en[1];
                continue;
            }
            if (key.equals("5")) {
                to = en[1];
                continue;
            }
            if (key.equals("265")) {
                xferPeerIdString = en[1];
                continue;
            }
            if (key.equals("27")) {
                filename = en[1];
                continue;
            }
            if (key.equals("66")) {
                val_66 = Long.valueOf(en[1]);
                continue;
            }
            if (key.equals("249")) {
                val_249 = en[1];
                continue;
            }
            if (key.equals("250")) {
                urlStr = en[1];
                continue;
            }
            if (!key.equals("251")) continue;
            xferPeerIdStringForRelay = en[1];
        }
        if (xferPeerIdString == null) {
            return;
        }
        XFer xfer = this.currentTransfers.get(xferPeerIdString);
        if (xfer == null) {
            return;
        }
        if (xfer.fileNamesReceived.contains(filename)) {
            return;
        }
        if (val_66 == -1L) {
            this.xferCancelRemote(xferPeerIdString, xfer.fileNames, true);
            return;
        }
        xfer.val_249 = val_249;
        xfer.xferPeerIDstringRelay = xferPeerIdStringForRelay;
        xfer.fileNames.add(filename);
        try {
            if (!urlStr.startsWith("http")) {
                urlStr = "http://" + urlStr;
            }
            new URL(urlStr);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot parse url for incoming file", e);
            this.xferCancelRemote(xferPeerIdString, xfer.fileNames, true);
            return;
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("5", from);
        body.addElement("265", xferPeerIdString);
        body.addElement("27", filename);
        body.addElement("249", val_249);
        body.addElement("251", xferPeerIdStringForRelay);
        this.sendPacket(body, 222);
        this.xferConnect(xferPeerIdString, filename, urlStr, xferPeerIdStringForRelay, from);
    }

    private void xferConnect(String id, String filename, String urlStr, String relayStr, String to) throws IOException {
        XFer xfer = this.currentTransfers.get(id);
        xfer.to = to;
        xfer.receiveFileThread = new ReceiveFileThread(urlStr, relayStr, filename, xfer);
        xfer.receiveFileThread.start();
    }

    protected void receiveFiletransAcc15(YMSG9Packet pkt) throws IOException {
        long val_66 = 0L;
        String val_222 = null;
        String xferPeerIdString = null;
        String xferPeerIdStringForRelay = null;
        for (String[] en : pkt.entries()) {
            String key = en[0];
            if (key.equals("251")) {
                xferPeerIdStringForRelay = en[1];
                continue;
            }
            if (key.equals("265")) {
                xferPeerIdString = en[1];
                continue;
            }
            if (key.equals("222")) {
                val_222 = en[1];
                continue;
            }
            if (!key.equals("66")) continue;
            val_66 = Long.valueOf(en[1]);
        }
        if (xferPeerIdString == null) {
            return;
        }
        XFer xfer = this.currentTransfers.get(xferPeerIdString);
        if (xfer == null) {
            return;
        }
        if (val_66 == -1L || xferPeerIdStringForRelay == null) {
            this.xferCancelRemote(xferPeerIdString, xfer.fileNames, true);
            return;
        }
        if (xferPeerIdStringForRelay != null) {
            xfer.xferPeerIDstringRelay = xferPeerIdStringForRelay;
            xfer.sending = true;
            xfer.sendFileThread = new SendFileThread(xfer);
            xfer.sendFileThread.start();
        } else {
            int fileIx = this.getNextFileIx(xfer);
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID);
            body.addElement("5", xfer.to);
            body.addElement("265", xfer.xferPeerIDstring);
            body.addElement("27", new File(xfer.fileNames.get(fileIx)).getName());
            body.addElement("249", "3");
            body.addElement("250", InetAddress.getByName("relay.msg.yahoo.com").getHostAddress());
            this.sendPacket(body, 221);
        }
    }

    private int getNextFileIx(XFer xfer) {
        for (int i = 0; i < xfer.fileNames.size(); ++i) {
            String f = xfer.fileNames.get(i);
            if (xfer.fileNamesSent.contains(f)) continue;
            return i;
        }
        return 0;
    }

    public String sendFiles(List<String> files, String to) throws IOException {
        if (files.size() > 1) {
            XFer xfer = new XFer();
            xfer.sending = true;
            xfer.to = to;
            xfer.xferPeerIDstring = this.xferNewId();
            this.currentTransfers.put(xfer.xferPeerIDstring, xfer);
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID);
            body.addElement("5", to);
            body.addElement("265", xfer.xferPeerIDstring);
            body.addElement("222", "1");
            body.addElement("266", String.valueOf(files.size()));
            body.addElement("302", "268");
            body.addElement("300", "268");
            for (int i = 0; i < files.size(); ++i) {
                String f = files.get(i);
                xfer.fileNames.add(f);
                File fileToSend = new File(f);
                String fLen = String.valueOf(fileToSend.length());
                xfer.fileSizes.add(fLen);
                body.addElement("27", fileToSend.getName());
                body.addElement("28", fLen);
                body.addElement("301", "268");
                if (i < files.size() - 1) {
                    body.addElement("300", "268");
                    continue;
                }
                body.addElement("303", "268");
            }
            this.sendPacket(body, 220);
            return xfer.xferPeerIDstring;
        }
        File fileToSend = new File(files.get(0));
        XFer xfer = new XFer();
        xfer.sending = true;
        xfer.to = to;
        xfer.xferPeerIDstring = this.xferNewId();
        xfer.fileNames.addAll(files);
        xfer.fileSizes.add(String.valueOf(fileToSend.length()));
        this.currentTransfers.put(xfer.xferPeerIDstring, xfer);
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("5", to);
        body.addElement("265", xfer.xferPeerIDstring);
        body.addElement("222", "1");
        body.addElement("266", "1");
        body.addElement("302", "268");
        body.addElement("300", "268");
        body.addElement("27", fileToSend.getName());
        body.addElement("28", xfer.fileSizes.get(0));
        body.addElement("301", "268");
        body.addElement("303", "268");
        this.sendPacket(body, 220);
        return xfer.xferPeerIDstring;
    }

    private class ReceiveFileThread
    extends Thread {
        String urlStr;
        String relayStr;
        String fileName;
        XFer xfer;

        ReceiveFileThread(String urlStr, String relayStr, String fileName, XFer xfer) {
            this.urlStr = urlStr;
            this.relayStr = relayStr;
            this.fileName = fileName;
            this.xfer = xfer;
        }

        public void run() {
            block9: {
                try {
                    URL url = new URL(this.urlStr.trim() + "/relay?token=" + URLEncoder.encode(this.relayStr.trim(), "UTF-8") + "&sender=" + Session.this.loginID + "&recver=" + this.xfer.to.trim());
                    String cookie = "T=" + Session.this.cookieT + "; Y=" + Session.this.cookieY;
                    URLConnection uc = url.openConnection();
                    uc.setRequestProperty("Cookie", cookie);
                    uc.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
                    uc.setRequestProperty("Host", url.getHost());
                    uc.setRequestProperty("Connection", "Keep-Alive");
                    if (uc instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)uc).getResponseCode();
                        int fileSize = ((HttpURLConnection)uc).getContentLength();
                        if (responseCode == 200) {
                            InputStream in = uc.getInputStream();
                            SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4);
                            new FireEvent().fire(ev, 220);
                            FileOutputStream out = new FileOutputStream(this.xfer.receiveFile);
                            long progress = 0L;
                            int read = -1;
                            byte[] buff = new byte[1024];
                            while ((read = in.read(buff)) != -1) {
                                out.write(buff, 0, read);
                                new FireEvent().fire(new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4, progress += (long)read), 220);
                            }
                            in.close();
                            out.flush();
                            out.close();
                            if ((long)fileSize == progress) {
                                this.xfer.fileNamesReceived.add(this.fileName);
                                ev = new SessionFileTransferEvent((Object)Session.this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 2);
                                new FireEvent().fire(ev, 220);
                                if (this.xfer.fileNames.size() != this.xfer.fileNamesReceived.size()) {
                                    PacketBodyBuffer body = new PacketBodyBuffer();
                                    body.addElement("1", Session.this.loginID);
                                    body.addElement("5", this.xfer.from);
                                    body.addElement("265", this.xfer.xferPeerIDstring);
                                    body.addElement("271", "1");
                                    Session.this.sendPacket(body, 222);
                                } else {
                                    Session.this.currentTransfers.remove(this.xfer.xferPeerIDstring);
                                }
                            } else {
                                logger.log(Level.WARNING, "File size doesn't match expected " + fileSize + " is " + progress + ". Probably filetransfer canceled!");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error receiving file", e);
                    if (this.fileName == null) break block9;
                    SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)e, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 5);
                    new FireEvent().fire(ev, 220);
                }
            }
        }
    }

    private class SendFileThread
    extends Thread {
        XFer xfer;
        boolean running = false;

        SendFileThread(XFer xfer) {
            this.xfer = xfer;
        }

        public void run() {
            block6: {
                String fileSize = null;
                String fileName = null;
                try {
                    String line;
                    this.running = true;
                    int fileIx = Session.this.getNextFileIx(this.xfer);
                    URL url = new URL("http://relay.msg.yahoo.com/relay?token=" + URLEncoder.encode(this.xfer.xferPeerIDstringRelay, "UTF-8") + "&sender=" + Session.this.loginID + "&recver=" + this.xfer.to);
                    String cookie = "T=" + Session.this.cookieT + "; Y=" + Session.this.cookieY;
                    fileSize = this.xfer.fileSizes.get(fileIx);
                    fileName = this.xfer.fileNames.get(fileIx);
                    URLConnection uc = url.openConnection();
                    uc.setDoOutput(true);
                    uc.setUseCaches(false);
                    uc.setAllowUserInteraction(false);
                    uc.setRequestProperty("Cookie", cookie);
                    uc.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
                    uc.setRequestProperty("Host", url.getHost());
                    uc.setRequestProperty("Content-Length", fileSize);
                    uc.setRequestProperty("Cache-Control", "no-cache");
                    OutputStream out = uc.getOutputStream();
                    File f = new File(fileName);
                    FileInputStream fin = new FileInputStream(f);
                    SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4);
                    new FireEvent().fire(ev, 220);
                    long progress = 0L;
                    int read = -1;
                    byte[] buff = new byte[1024];
                    while ((read = fin.read(buff)) != -1) {
                        if (!this.running) {
                            fin.close();
                            out.close();
                            return;
                        }
                        new FireEvent().fire(new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4, progress += (long)read), 220);
                        out.write(buff, 0, read);
                        out.flush();
                    }
                    fin.close();
                    this.xfer.fileNamesSent.add(fileName);
                    BufferedReader rd = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                    StringBuffer sb = new StringBuffer();
                    while ((line = rd.readLine()) != null) {
                        sb.append(line);
                    }
                    rd.close();
                    out.close();
                    if (this.xfer.fileNamesSent.size() == this.xfer.fileNames.size()) {
                        Session.this.currentTransfers.remove(this.xfer.xferPeerIDstring);
                    }
                    ev = new SessionFileTransferEvent((Object)fileName, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 3);
                    new FireEvent().fire(ev, 220);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error sending file", e);
                    if (fileName == null) break block6;
                    SessionFileTransferEvent ev = new SessionFileTransferEvent((Object)e, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 5);
                    new FireEvent().fire(ev, 220);
                }
            }
        }

        void cancel() {
            this.running = false;
        }
    }

    private static class XFer {
        String from = null;
        String to = null;
        String imv = null;
        long val_222 = 0L;
        String service = null;
        String xferPeerIDstring = null;
        String xferPeerIDstringRelay = null;
        String val_249 = null;
        ArrayList<String> fileNames = new ArrayList();
        ArrayList<String> fileSizes = new ArrayList();
        boolean sending = false;
        ArrayList<String> fileNamesReceived = new ArrayList();
        ArrayList<String> fileNamesSent = new ArrayList();
        SendFileThread sendFileThread;
        ReceiveFileThread receiveFileThread;
        File receiveFile = null;

        private XFer() {
        }
    }

    private class FireEvent
    extends Thread {
        int type;
        SessionEvent ev;

        FireEvent() {
            super(Session.this.ymsgThreads, "Event Fired");
        }

        void fire(SessionEvent ev, int t) {
            this.ev = ev;
            this.type = t;
            this.start();
        }

        public void start() {
            if (Session.this.listeners.size() > 0) {
                super.start();
            }
        }

        public void run() {
            logger.finest("Will fire eventType=" + this.type + " event=" + this.ev + " to listeners count=" + Session.this.listeners.size());
            if (this.type == 220) {
                SessionFileTransferEvent sfe = (SessionFileTransferEvent)this.ev;
                for (int i = 0; i < Session.this.sessionFileTransferListeners.size(); ++i) {
                    try {
                        SessionFileTransferListener sfs = (SessionFileTransferListener)Session.this.sessionFileTransferListeners.get(i);
                        if (sfe.getState() == 0) {
                            sfs.fileTransferRequestReceived(sfe);
                            continue;
                        }
                        sfs.statusChanged(sfe);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                return;
            }
            block32: for (int i = 0; i < Session.this.listeners.size(); ++i) {
                SessionListener l = (SessionListener)Session.this.listeners.elementAt(i);
                switch (this.type) {
                    case 2: {
                        l.connectionClosed(this.ev);
                        continue block32;
                    }
                    case 3: {
                        l.friendsUpdateReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 6: {
                        l.messageReceived(this.ev);
                        continue block32;
                    }
                    case 3841: {
                        l.offlineMessageReceived(this.ev);
                        continue block32;
                    }
                    case 11: {
                        l.newMailReceived((SessionNewMailEvent)this.ev);
                        continue block32;
                    }
                    case 15: {
                        l.contactRequestReceived(this.ev);
                        continue block32;
                    }
                    case 26: {
                        l.conferenceInviteDeclinedReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 24: {
                        l.conferenceInviteReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 25: {
                        l.conferenceLogonReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 27: {
                        l.conferenceLogoffReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 29: {
                        l.conferenceMessageReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 70: {
                        l.fileTransferReceived((SessionFileTransferEvent)this.ev);
                        continue block32;
                    }
                    case 75: {
                        l.notifyReceived((SessionNotifyEvent)this.ev);
                        continue block32;
                    }
                    case 85: {
                        l.listReceived(this.ev);
                        continue block32;
                    }
                    case 131: {
                        l.friendAddedReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 132: {
                        l.friendRemovedReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 134: {
                        l.contactRejectionReceived(this.ev);
                        continue block32;
                    }
                    case 152: {
                        l.chatLogonReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 155: {
                        l.chatLogoffReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 160: {
                        l.chatConnectionClosed(this.ev);
                        continue block32;
                    }
                    case 168: {
                        l.chatMessageReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 3844: {
                        l.chatUserUpdateReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 3840: {
                        l.errorPacketReceived((SessionErrorEvent)this.ev);
                        continue block32;
                    }
                    case 3842: {
                        l.inputExceptionThrown((SessionExceptionEvent)this.ev);
                        continue block32;
                    }
                    case 3843: {
                        l.buzzReceived(this.ev);
                        continue block32;
                    }
                    case 190: {
                        l.pictureReceived((SessionPictureEvent)this.ev);
                        continue block32;
                    }
                    case 214: {
                        l.authorizationReceived((SessionAuthorizationEvent)this.ev);
                        continue block32;
                    }
                    default: {
                        logger.finest("UNKNOWN event: " + this.type);
                    }
                }
            }
        }
    }

    private class TypingNotifier
    extends KeyAdapter
    implements Runnable {
        public boolean quit = false;
        private long lastKey;
        private int timeout = 30000;
        private boolean typing = false;
        private Thread thread;
        private Component typeSource;
        private int listenerCnt = 0;
        private String target;
        private String identity;

        public TypingNotifier(Component com, String to, String from) {
            this.typeSource = com;
            this.target = to;
            this.identity = from;
            if (this.typeSource != null) {
                this.typeSource.addKeyListener(this);
            }
            this.thread = new Thread(Session.this.ymsgThreads, this, "Typing Notification: " + from + "->" + to);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public void keyTyped(KeyEvent ev) {
            this.keyTyped();
        }

        void keyTyped() {
            if (!this.thread.isAlive() || Session.this.sessionStatus != 2) {
                return;
            }
            this.lastKey = System.currentTimeMillis();
            if (!this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, true, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.typing = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.quit) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (Session.this.sessionStatus != 2 || !this.typing || System.currentTimeMillis() - this.lastKey <= (long)this.timeout) continue;
                    try {
                        Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.typing = false;
                }
            }
            finally {
                if (this.typeSource != null) {
                    this.typeSource.removeKeyListener(this);
                }
            }
        }

        public void interrupt() {
            this.thread.interrupt();
        }

        public void stopTyping() {
            if (this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.typing = false;
            }
        }
    }

    private class PingThread
    extends Thread {
        public boolean quit;
        public int time;

        public PingThread() {
            super(Session.this.ymsgThreads, "Ping");
            this.quit = false;
            this.time = 1200000;
            this.setPriority(1);
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.time);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (!this.quit) {
                try {
                    Session.this.transmitPing();
                    if (Session.this.currentLobby != null) {
                        Session.this.transmitChatPing();
                    }
                    try {
                        Thread.sleep(this.time);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private class InputThread
    extends Thread {
        public boolean quit;

        public InputThread() {
            super(Session.this.ymsgThreads, "Network Input");
            this.quit = false;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                block9: while (true) {
                    while (!this.quit) {
                        try {
                            this.process(Session.this.network.receivePacket());
                        }
                        catch (SocketException e) {
                            break block11;
                        }
                        catch (LoginRefusedException e) {
                            break block11;
                        }
                        catch (Exception e) {
                            try {
                                SessionExceptionEvent se = new SessionExceptionEvent((Object)Session.this, "Source: InputThread", e);
                                new FireEvent().fire(se, 3842);
                                continue block9;
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    Session.this.closeNetwork();
                    new FireEvent().fire(new SessionEvent(this), 2);
                }
            }
        }

        void process(YMSG9Packet pkt) throws Exception {
            if (pkt == null) {
                this.quit = true;
                return;
            }
            if (pkt.sessionId != 0L) {
                Session.this.sessionId = pkt.sessionId;
            }
            logger.finest("Received a packet - status: " + pkt.status + " service: " + pkt.service + " packet:" + pkt);
            if (pkt.status == -1L && pkt.service != 221 && pkt.service != 222 && this.processError(pkt)) {
                return;
            }
            switch (pkt.service) {
                case 17: {
                    Session.this.receiveAddIgnore(pkt);
                    break;
                }
                case 87: {
                    Session.this.receiveAuth(pkt);
                    break;
                }
                case 84: {
                    Session.this.receiveAuthResp(pkt);
                    break;
                }
                case 150: {
                    Session.this.receiveChatConnect(pkt);
                    break;
                }
                case 160: {
                    Session.this.receiveChatDisconnect(pkt);
                    break;
                }
                case 155: {
                    Session.this.receiveChatLogoff(pkt);
                    break;
                }
                case 152: {
                    Session.this.receiveChatLogon(pkt);
                    break;
                }
                case 168: {
                    Session.this.receiveChatMsg(pkt);
                    break;
                }
                case 32: {
                    Session.this.receiveChatPM(pkt);
                    break;
                }
                case 28: {
                    Session.this.receiveConfAddInvite(pkt);
                    break;
                }
                case 26: {
                    Session.this.receiveConfDecline(pkt);
                    break;
                }
                case 24: {
                    Session.this.receiveConfInvite(pkt);
                    break;
                }
                case 27: {
                    Session.this.receiveConfLogoff(pkt);
                    break;
                }
                case 25: {
                    Session.this.receiveConfLogon(pkt);
                    break;
                }
                case 29: {
                    Session.this.receiveConfMsg(pkt);
                    break;
                }
                case 133: {
                    Session.this.receiveContactIgnore(pkt);
                    break;
                }
                case 15: {
                    Session.this.receiveContactNew(pkt);
                    break;
                }
                case 70: {
                    Session.this.receiveFileTransfer(pkt);
                    break;
                }
                case 131: {
                    Session.this.receiveFriendAdd(pkt);
                    break;
                }
                case 132: {
                    Session.this.receiveFriendRemove(pkt);
                    break;
                }
                case 7: {
                    Session.this.receiveIdAct(pkt);
                    break;
                }
                case 8: {
                    Session.this.receiveIdDeact(pkt);
                    break;
                }
                case 3: {
                    Session.this.receiveIsAway(pkt);
                    break;
                }
                case 4: {
                    Session.this.receiveIsBack(pkt);
                    break;
                }
                case 85: {
                    Session.this.receiveList(pkt);
                    break;
                }
                case 241: {
                    Session.this.receiveList15(pkt);
                    break;
                }
                case 2: {
                    Session.this.receiveLogoff(pkt);
                    break;
                }
                case 1: {
                    Session.this.receiveLogon(pkt);
                    break;
                }
                case 6: {
                    Session.this.receiveMessage(pkt);
                    break;
                }
                case 11: {
                    Session.this.receiveNewMail(pkt);
                    break;
                }
                case 75: {
                    Session.this.receiveNotify(pkt);
                    break;
                }
                case 18: {
                    Session.this.receivePing(pkt);
                    break;
                }
                case 10: {
                    Session.this.receiveUserStat(pkt);
                    break;
                }
                case 198: {
                    Session.this.receiveIsAway(pkt);
                    break;
                }
                case 240: {
                    Session.this.receiveStatus15(pkt);
                    break;
                }
                case 214: {
                    Session.this.receiveAuthorization(pkt);
                    break;
                }
                case 190: {
                    Session.this.receivePicture(pkt);
                    break;
                }
                case 193: {
                    Session.this.receivePictureUpdate(pkt);
                    break;
                }
                case 199: {
                    Session.this.receiveAvatarUpdate(pkt);
                    break;
                }
                case 194: {
                    Session.this.receivePictureUpload(pkt);
                    break;
                }
                case 189: {
                    Session.this.receivePictureChecksum(pkt);
                    break;
                }
                case 220: {
                    Session.this.receiveFiletrans15(pkt);
                    break;
                }
                case 79: {
                    Session.this.receiveP2P(pkt);
                    break;
                }
                case 221: {
                    Session.this.receiveFiletransInfo15(pkt);
                    break;
                }
                case 222: {
                    Session.this.receiveFiletransAcc15(pkt);
                    break;
                }
                default: {
                    logger.finest("UNKNOWN: " + pkt.toString());
                }
            }
        }

        boolean processError(YMSG9Packet pkt) throws Exception {
            switch (pkt.service) {
                case 84: {
                    Session.this.receiveAuthResp(pkt);
                    return true;
                }
                case 152: {
                    Session.this.receiveChatLogon(pkt);
                    return true;
                }
                case 2: {
                    Session.this.receiveLogoff(pkt);
                    return true;
                }
            }
            Session.this.errorMessage(pkt, null);
            return pkt.body.length <= 2;
        }
    }
}

