/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jitsi.service.neomedia.control.KeyFrameControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFrameControlAdapter
implements KeyFrameControl {
    private List<KeyFrameControl.KeyFrameRequestee> keyFrameRequestees = new ArrayList<KeyFrameControl.KeyFrameRequestee>(0);
    private List<KeyFrameControl.KeyFrameRequester> keyFrameRequesters = new ArrayList<KeyFrameControl.KeyFrameRequester>(0);
    private List<KeyFrameControl.KeyFrameRequestee> unmodifiableKeyFrameRequestees;
    private List<KeyFrameControl.KeyFrameRequester> unmodifiableKeyFrameRequesters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyFrameRequestee(int index, KeyFrameControl.KeyFrameRequestee keyFrameRequestee) {
        if (keyFrameRequestee == null) {
            throw new NullPointerException("keyFrameRequestee");
        }
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            if (!this.keyFrameRequestees.contains(keyFrameRequestee)) {
                ArrayList<KeyFrameControl.KeyFrameRequestee> newKeyFrameRequestees = new ArrayList<KeyFrameControl.KeyFrameRequestee>(this.keyFrameRequestees.size() + 1);
                newKeyFrameRequestees.addAll(this.keyFrameRequestees);
                if (-1 == index) {
                    index = keyFrameRequestee.getClass().getName().contains(".neomedia.") ? newKeyFrameRequestees.size() : 0;
                }
                newKeyFrameRequestees.add(index, keyFrameRequestee);
                this.keyFrameRequestees = newKeyFrameRequestees;
                this.unmodifiableKeyFrameRequestees = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyFrameRequester(int index, KeyFrameControl.KeyFrameRequester keyFrameRequester) {
        if (keyFrameRequester == null) {
            throw new NullPointerException("keyFrameRequester");
        }
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            if (!this.keyFrameRequesters.contains(keyFrameRequester)) {
                ArrayList<KeyFrameControl.KeyFrameRequester> newKeyFrameRequesters = new ArrayList<KeyFrameControl.KeyFrameRequester>(this.keyFrameRequesters.size() + 1);
                newKeyFrameRequesters.addAll(this.keyFrameRequesters);
                if (-1 == index) {
                    index = keyFrameRequester.getClass().getName().contains(".neomedia.") ? newKeyFrameRequesters.size() : 0;
                }
                newKeyFrameRequesters.add(index, keyFrameRequester);
                this.keyFrameRequesters = newKeyFrameRequesters;
                this.unmodifiableKeyFrameRequesters = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyFrameControl.KeyFrameRequestee> getKeyFrameRequestees() {
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            if (this.unmodifiableKeyFrameRequestees == null) {
                this.unmodifiableKeyFrameRequestees = Collections.unmodifiableList(this.keyFrameRequestees);
            }
            return this.unmodifiableKeyFrameRequestees;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyFrameControl.KeyFrameRequester> getKeyFrameRequesters() {
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            if (this.unmodifiableKeyFrameRequesters == null) {
                this.unmodifiableKeyFrameRequesters = Collections.unmodifiableList(this.keyFrameRequesters);
            }
            return this.unmodifiableKeyFrameRequesters;
        }
    }

    @Override
    public boolean keyFrameRequest() {
        for (KeyFrameControl.KeyFrameRequestee keyFrameRequestee : this.getKeyFrameRequestees()) {
            try {
                if (!keyFrameRequestee.keyFrameRequest()) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKeyFrameRequestee(KeyFrameControl.KeyFrameRequestee keyFrameRequestee) {
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            int index = this.keyFrameRequestees.indexOf(keyFrameRequestee);
            if (-1 != index) {
                ArrayList<KeyFrameControl.KeyFrameRequestee> newKeyFrameRequestees = new ArrayList<KeyFrameControl.KeyFrameRequestee>(this.keyFrameRequestees);
                newKeyFrameRequestees.remove(index);
                this.keyFrameRequestees = newKeyFrameRequestees;
                this.unmodifiableKeyFrameRequestees = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKeyFrameRequester(KeyFrameControl.KeyFrameRequester keyFrameRequester) {
        KeyFrameControlAdapter keyFrameControlAdapter = this;
        synchronized (keyFrameControlAdapter) {
            int index = this.keyFrameRequesters.indexOf(keyFrameRequester);
            if (-1 != index) {
                ArrayList<KeyFrameControl.KeyFrameRequester> newKeyFrameRequesters = new ArrayList<KeyFrameControl.KeyFrameRequester>(this.keyFrameRequesters);
                newKeyFrameRequesters.remove(index);
                this.keyFrameRequesters = newKeyFrameRequesters;
                this.unmodifiableKeyFrameRequesters = null;
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean requestKeyFrame(boolean urgent) {
        for (KeyFrameControl.KeyFrameRequester keyFrameRequester : this.getKeyFrameRequesters()) {
            try {
                if (!keyFrameRequester.requestKeyFrame()) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }
}

