/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.awt.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualityPreset
implements Comparable<QualityPreset> {
    public static final QualityPreset HD_QUALITY = new QualityPreset(new Dimension(1280, 720), 30.0f);
    public static final QualityPreset LO_QUALITY = new QualityPreset(new Dimension(320, 240), 15.0f);
    public static final QualityPreset SD_QUALITY = new QualityPreset(new Dimension(640, 480), 20.0f);
    private final float frameRate;
    private final Dimension resolution;

    public QualityPreset(Dimension resolution, float frameRate) {
        this.frameRate = frameRate;
        this.resolution = resolution;
    }

    public QualityPreset(Dimension resolution) {
        this(resolution, -1.0f);
    }

    public float getFameRate() {
        return this.frameRate;
    }

    public Dimension getResolution() {
        return this.resolution;
    }

    @Override
    public int compareTo(QualityPreset o) {
        if (this.resolution == null) {
            return -1;
        }
        if (o == null) {
            return 1;
        }
        if (this.resolution.equals(o.resolution)) {
            return 0;
        }
        if (this.resolution.height < o.resolution.height && this.resolution.width < o.resolution.width) {
            return -1;
        }
        return 1;
    }
}

