/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MediaDirection {
    INACTIVE("inactive"),
    SENDONLY("sendonly"),
    RECVONLY("recvonly"),
    SENDRECV("sendrecv");

    private final String directionName;

    private MediaDirection(String directionName) {
        this.directionName = directionName;
    }

    public String toString() {
        return this.directionName;
    }

    public MediaDirection and(MediaDirection direction) {
        if (this == SENDRECV) {
            return direction;
        }
        if (this == SENDONLY) {
            if (direction == SENDONLY || direction == SENDRECV) {
                return SENDONLY;
            }
            return INACTIVE;
        }
        if (this == RECVONLY) {
            if (direction == RECVONLY || direction == SENDRECV) {
                return RECVONLY;
            }
            return INACTIVE;
        }
        return INACTIVE;
    }

    public MediaDirection or(MediaDirection direction) {
        if (this == SENDRECV) {
            return this;
        }
        if (this == SENDONLY) {
            if (direction.allowsReceiving()) {
                return SENDRECV;
            }
            return this;
        }
        if (this == RECVONLY) {
            if (direction.allowsSending()) {
                return SENDRECV;
            }
            return this;
        }
        return direction;
    }

    public MediaDirection getReverseDirection() {
        switch (this) {
            case SENDRECV: {
                return SENDRECV;
            }
            case SENDONLY: {
                return RECVONLY;
            }
            case RECVONLY: {
                return SENDONLY;
            }
        }
        return INACTIVE;
    }

    public MediaDirection getDirectionForAnswer(MediaDirection remotePartyDir) {
        return this.and(remotePartyDir.getReverseDirection());
    }

    public boolean allowsSending() {
        return this == SENDONLY || this == SENDRECV;
    }

    public boolean allowsReceiving() {
        return this == RECVONLY || this == SENDRECV;
    }

    public static MediaDirection parseString(String mediaDirectionStr) throws IllegalArgumentException {
        for (MediaDirection value : MediaDirection.values()) {
            if (!value.toString().equals(mediaDirectionStr)) continue;
            return value;
        }
        throw new IllegalArgumentException(mediaDirectionStr + " is not a valid media direction");
    }
}

