/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.sdes;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import ch.imvs.sdes4j.srtp.SrtpCryptoSuite;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;

public class SDesTransformEngine
implements TransformEngine {
    private SRTPTransformer srtpTransformer;
    private SRTCPTransformer srtcpTransformer;

    public SDesTransformEngine(SrtpCryptoAttribute inAttribute, SrtpCryptoAttribute outAttribute) {
        SRTPContextFactory forwardCtx = SDesTransformEngine.getTransformEngine(outAttribute);
        SRTPContextFactory reverseCtx = SDesTransformEngine.getTransformEngine(inAttribute);
        this.srtpTransformer = new SRTPTransformer(forwardCtx, reverseCtx);
        this.srtcpTransformer = new SRTCPTransformer(forwardCtx, reverseCtx);
    }

    public void close() {
        if (this.srtpTransformer != null) {
            this.srtpTransformer.close();
        }
        if (this.srtcpTransformer != null) {
            this.srtcpTransformer.close();
        }
        this.srtpTransformer = null;
        this.srtcpTransformer = null;
    }

    private static SRTPContextFactory getTransformEngine(SrtpCryptoAttribute attribute) {
        if (attribute.getSessionParams() != null && attribute.getSessionParams().length > 0) {
            throw new IllegalArgumentException("session parameters are not supported");
        }
        SrtpCryptoSuite cs = attribute.getCryptoSuite();
        return new SRTPContextFactory(SDesTransformEngine.getKey(attribute), SDesTransformEngine.getSalt(attribute), new SRTPPolicy(SDesTransformEngine.getEncryptionCipher(cs), cs.getEncKeyLength() / 8, SDesTransformEngine.getHashAlgorithm(cs), cs.getSrtpAuthKeyLength() / 8, cs.getSrtpAuthTagLength() / 8, cs.getSaltKeyLength() / 8), new SRTPPolicy(SDesTransformEngine.getEncryptionCipher(cs), cs.getEncKeyLength() / 8, SDesTransformEngine.getHashAlgorithm(cs), cs.getSrtcpAuthKeyLength() / 8, cs.getSrtcpAuthTagLength() / 8, cs.getSaltKeyLength() / 8));
    }

    private static byte[] getKey(SrtpCryptoAttribute attribute) {
        int length = attribute.getCryptoSuite().getEncKeyLength() / 8;
        byte[] key = new byte[length];
        System.arraycopy(attribute.getKeyParams()[0].getKey(), 0, key, 0, length);
        return key;
    }

    private static byte[] getSalt(SrtpCryptoAttribute attribute) {
        int keyLength = attribute.getCryptoSuite().getEncKeyLength() / 8;
        int saltLength = attribute.getCryptoSuite().getSaltKeyLength() / 8;
        byte[] salt = new byte[keyLength];
        System.arraycopy(attribute.getKeyParams()[0].getKey(), keyLength, salt, 0, saltLength);
        return salt;
    }

    private static int getEncryptionCipher(SrtpCryptoSuite cs) {
        switch (cs.getEncryptionAlgorithm()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported cipher");
    }

    private static int getHashAlgorithm(SrtpCryptoSuite cs) {
        switch (cs.getHashAlgorithm()) {
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported hash");
    }

    public PacketTransformer getRTPTransformer() {
        return this.srtpTransformer;
    }

    public PacketTransformer getRTCPTransformer() {
        return this.srtcpTransformer;
    }
}

