/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.rtcp;

import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTCPSenderReport;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;

public class StatisticsEngine
implements TransformEngine,
PacketTransformer {
    private static final Logger logger = Logger.getLogger(StatisticsEngine.class);
    public static final String RTP_STAT_PREFIX = "rtpstat:";
    private long lost = 0L;
    private long maxInterArrivalJitter = 0L;
    private final MediaStreamImpl mediaStream;
    private long minInterArrivalJitter = -1L;
    private long numberOfSenderReports = 0L;

    public StatisticsEngine(MediaStreamImpl stream) {
        this.mediaStream = stream;
    }

    public void close() {
    }

    public long getLost() {
        return this.lost;
    }

    public long getMaxInterArrivalJitter() {
        return this.maxInterArrivalJitter;
    }

    public long getMinInterArrivalJitter() {
        return this.minInterArrivalJitter;
    }

    public PacketTransformer getRTCPTransformer() {
        return this;
    }

    public PacketTransformer getRTPTransformer() {
        return null;
    }

    public RawPacket reverseTransform(RawPacket pkt) {
        try {
            RTCPSenderReport senderReport;
            Vector feedbackReports;
            int offset;
            byte[] data;
            RTCPHeader header;
            int length = pkt.getLength();
            if (length != 0 && (header = new RTCPHeader(data = pkt.getBuffer(), offset = pkt.getOffset(), length)).getPacketType() == 200 && (feedbackReports = (senderReport = new RTCPSenderReport(data, offset, length)).getFeedbackReports()).size() != 0) {
                RTCPFeedback feedback = (RTCPFeedback)feedbackReports.get(0);
                this.mediaStream.getMediaStreamStats().updateNewReceivedFeedback(feedback);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to analyze an incoming RTCP packet for the purposes of statistics.", t);
        }
        return pkt;
    }

    public RawPacket transform(RawPacket pkt) {
        try {
            RTCPSenderReport senderReport;
            Vector feedbackReports;
            ++this.numberOfSenderReports;
            byte[] data = pkt.getBuffer();
            int offset = pkt.getOffset();
            int length = pkt.getLength();
            RTCPHeader header = new RTCPHeader(data, offset, length);
            if (header.getPacketType() == 200 && (feedbackReports = (senderReport = new RTCPSenderReport(data, offset, length)).getFeedbackReports()).size() != 0) {
                RTCPFeedback feedback = (RTCPFeedback)feedbackReports.get(0);
                this.mediaStream.getMediaStreamStats().updateNewSentFeedback(feedback);
                if (!logger.isInfoEnabled()) {
                    return pkt;
                }
                long jitter = feedback.getJitter();
                if (jitter < this.getMinInterArrivalJitter() || this.getMinInterArrivalJitter() == -1L) {
                    this.minInterArrivalJitter = jitter;
                }
                if (this.getMaxInterArrivalJitter() < jitter) {
                    this.maxInterArrivalJitter = jitter;
                }
                this.lost = feedback.getNumLost();
                if (this.numberOfSenderReports % 4L != 1L) {
                    return pkt;
                }
                StringBuilder buff = new StringBuilder(RTP_STAT_PREFIX);
                MediaType mediaType = this.mediaStream.getMediaType();
                String mediaTypeStr = mediaType == null ? "" : mediaType.toString();
                buff.append("Sending a report for ").append(mediaTypeStr).append(" stream SSRC:").append(feedback.getSSRC()).append(" [packet count:").append(senderReport.getSenderPacketCount()).append(", bytes:").append(senderReport.getSenderByteCount()).append(", interarrival jitter:").append(jitter).append(", lost packets:").append(feedback.getNumLost()).append(", time since previous report:").append((int)((double)feedback.getDLSR() / 65.536)).append("ms ]");
                logger.info(buff);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to analyze an outgoing RTCP packet for the purposes of statistics.", t);
        }
        return pkt;
    }
}

