/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceDelegate;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushBufferDataSourceAdapter
extends PushBufferDataSourceDelegate<PullBufferDataSource> {
    private static final Logger logger = Logger.getLogger(PushBufferDataSourceAdapter.class);
    private static final boolean STRICT_STOP = false;
    private boolean started = false;
    private final List<PushBufferStreamAdapter> streams = new ArrayList<PushBufferStreamAdapter>();

    public PushBufferDataSourceAdapter(PullBufferDataSource dataSource) {
        super(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        List<PushBufferStreamAdapter> list = this.streams;
        synchronized (list) {
            Iterator<PushBufferStreamAdapter> streamIter = this.streams.iterator();
            while (streamIter.hasNext()) {
                PushBufferStreamAdapter stream = streamIter.next();
                streamIter.remove();
                stream.close();
            }
        }
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        super.start();
        List<PushBufferStreamAdapter> list = this.streams;
        synchronized (list) {
            this.started = true;
            for (PushBufferStreamAdapter stream : this.streams) {
                stream.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        List<PushBufferStreamAdapter> list = this.streams;
        synchronized (list) {
            this.started = false;
            for (PushBufferStreamAdapter stream : this.streams) {
                stream.stop();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushBufferStream[] getStreams() {
        List<PushBufferStreamAdapter> list = this.streams;
        synchronized (list) {
            int dataSourceStreamCount;
            PullBufferStream[] dataSourceStreams = ((PullBufferDataSource)this.dataSource).getStreams();
            if (dataSourceStreams != null) {
                dataSourceStreams = (PullBufferStream[])dataSourceStreams.clone();
                dataSourceStreamCount = dataSourceStreams.length;
            } else {
                dataSourceStreamCount = 0;
            }
            Iterator<PushBufferStreamAdapter> streamIter = this.streams.iterator();
            while (streamIter.hasNext()) {
                PushBufferStreamAdapter streamAdapter = streamIter.next();
                PullBufferStream stream = streamAdapter.stream;
                boolean removeStream = true;
                for (int dataSourceStreamIndex = 0; dataSourceStreamIndex < dataSourceStreamCount; ++dataSourceStreamIndex) {
                    if (stream != dataSourceStreams[dataSourceStreamIndex]) continue;
                    removeStream = false;
                    dataSourceStreams[dataSourceStreamIndex] = null;
                    break;
                }
                if (!removeStream) continue;
                streamIter.remove();
                streamAdapter.close();
            }
            for (int dataSourceStreamIndex = 0; dataSourceStreamIndex < dataSourceStreamCount; ++dataSourceStreamIndex) {
                PullBufferStream dataSourceStream = dataSourceStreams[dataSourceStreamIndex];
                if (dataSourceStream == null) continue;
                PushBufferStreamAdapter stream = new PushBufferStreamAdapter(dataSourceStream);
                this.streams.add(stream);
                if (!this.started) continue;
                stream.start();
            }
            return this.streams.toArray(EMPTY_STREAMS);
        }
    }

    private static class PushBufferStreamAdapter
    implements PushBufferStream {
        private final Buffer buffer = new Buffer();
        private boolean bufferIsWritten = false;
        private boolean started = false;
        public final PullBufferStream stream;
        private IOException streamReadException;
        private Thread streamReadThread;
        private final Object streamReadThreadSyncRoot = new Object();
        private BufferTransferHandler transferHandler;

        public PushBufferStreamAdapter(PullBufferStream stream) {
            if (stream == null) {
                throw new NullPointerException("stream");
            }
            this.stream = stream;
        }

        void close() {
            this.stop();
        }

        public boolean endOfStream() {
            return this.stream.endOfStream();
        }

        public ContentDescriptor getContentDescriptor() {
            return this.stream.getContentDescriptor();
        }

        public long getContentLength() {
            return this.stream.getContentLength();
        }

        public Object getControl(String controlType) {
            return this.stream.getControl(controlType);
        }

        public Object[] getControls() {
            return this.stream.getControls();
        }

        public Format getFormat() {
            return this.stream.getFormat();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                if (this.streamReadException != null) {
                    IOException ie = new IOException();
                    ie.initCause(this.streamReadException);
                    this.streamReadException = null;
                    throw ie;
                }
                if (this.bufferIsWritten) {
                    buffer.copy(this.buffer);
                    this.bufferIsWritten = false;
                } else {
                    buffer.setLength(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInStreamReadThread() {
            boolean yield;
            boolean bufferIsWritten;
            Buffer buffer = this.buffer;
            synchronized (buffer) {
                try {
                    this.stream.read(this.buffer);
                    this.bufferIsWritten = !this.buffer.isDiscard();
                    this.streamReadException = null;
                }
                catch (IOException ie) {
                    this.bufferIsWritten = false;
                    this.streamReadException = ie;
                }
                bufferIsWritten = this.bufferIsWritten;
                yield = !bufferIsWritten && this.streamReadException != null;
            }
            if (bufferIsWritten) {
                BufferTransferHandler transferHandler = this.transferHandler;
                if (transferHandler != null) {
                    transferHandler.transferData((PushBufferStream)this);
                }
            } else if (yield) {
                Thread.yield();
            }
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            if (this.transferHandler != transferHandler) {
                this.transferHandler = transferHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            Object object = this.streamReadThreadSyncRoot;
            synchronized (object) {
                this.started = true;
                if (this.streamReadThread == null) {
                    this.streamReadThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                while (true) {
                                    Object object = PushBufferStreamAdapter.this.streamReadThreadSyncRoot;
                                    synchronized (object) {
                                        if (!PushBufferStreamAdapter.this.started) {
                                            break;
                                        }
                                        if (PushBufferStreamAdapter.this.streamReadThread != Thread.currentThread()) {
                                            break;
                                        }
                                    }
                                    PushBufferStreamAdapter.this.runInStreamReadThread();
                                }
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                Object object = PushBufferStreamAdapter.this.streamReadThreadSyncRoot;
                                synchronized (object) {
                                    if (PushBufferStreamAdapter.this.streamReadThread == Thread.currentThread()) {
                                        PushBufferStreamAdapter.this.streamReadThread = null;
                                        PushBufferStreamAdapter.this.streamReadThreadSyncRoot.notifyAll();
                                    }
                                }
                                throw throwable;
                            }
                            Object object = PushBufferStreamAdapter.this.streamReadThreadSyncRoot;
                            synchronized (object) {
                                if (PushBufferStreamAdapter.this.streamReadThread == Thread.currentThread()) {
                                    PushBufferStreamAdapter.this.streamReadThread = null;
                                    PushBufferStreamAdapter.this.streamReadThreadSyncRoot.notifyAll();
                                }
                            }
                        }
                    };
                    this.streamReadThread.setDaemon(true);
                    this.streamReadThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Object object = this.streamReadThreadSyncRoot;
            synchronized (object) {
                this.started = false;
                this.streamReadThread = null;
            }
        }
    }
}

