/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.notify;

import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jitsi.service.audionotifier.AbstractSCAudioClip;
import org.jitsi.service.audionotifier.AudioNotifierService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSoundClipImpl
extends AbstractSCAudioClip {
    private static Constructor<AudioClip> acConstructor = null;
    private final AudioClip audioClip;

    private static Constructor<AudioClip> createAcConstructor() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> class1;
        try {
            class1 = Class.forName("com.sun.media.sound.JavaSoundAudioClip", true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException cnfex) {
            class1 = Class.forName("sun.audio.SunAudioClip", true, null);
        }
        return class1.getConstructor(InputStream.class);
    }

    private static AudioClip createAppletAudioClip(InputStream inputstream) throws IOException {
        if (acConstructor == null) {
            try {
                acConstructor = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<AudioClip>>(){

                    @Override
                    public Constructor<AudioClip> run() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
                        return JavaSoundClipImpl.createAcConstructor();
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                throw new IOException("Failed to get AudioClip constructor: " + paex.getException());
            }
        }
        try {
            return acConstructor.newInstance(inputstream);
        }
        catch (Exception ex) {
            throw new IOException("Failed to construct the AudioClip: " + ex);
        }
    }

    public JavaSoundClipImpl(String uri, AudioNotifierService audioNotifier) throws IOException {
        super(uri, audioNotifier);
        this.audioClip = JavaSoundClipImpl.createAppletAudioClip(new URL(uri).openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalStop() {
        try {
            if (this.audioClip != null) {
                this.audioClip.stop();
            }
            Object var2_1 = null;
            super.internalStop();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.internalStop();
            throw throwable;
        }
    }

    @Override
    protected boolean runOnceInPlayThread() {
        if (this.audioClip == null) {
            return false;
        }
        this.audioClip.play();
        return true;
    }
}

