/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAPIRenderer
extends AbstractAudioRenderer<WASAPISystem> {
    private static final long DEFAULT_BUFFER_DURATION = 20L;
    private static final Logger logger = Logger.getLogger(WASAPIRenderer.class);
    private static final String PLUGIN_NAME = "Windows Audio Session API (WASAPI) Renderer";
    private boolean busy;
    private int dstChannels;
    private int dstSampleSize;
    private long eventHandle;
    private Runnable eventHandleCmd;
    private Executor eventHandleExecutor;
    private long iAudioClient;
    private long iAudioRenderClient;
    private int numBufferFrames;
    private long periodicity = 10L;
    private byte[] remainder;
    private int remainderLength;
    private int srcChannels;
    private int srcFrameSize;
    private int srcSampleSize;
    private boolean started;

    public WASAPIRenderer() {
        this(AudioSystem.DataFlow.PLAYBACK);
    }

    public WASAPIRenderer(AudioSystem.DataFlow dataFlow) {
        super("wasapi");
    }

    public WASAPIRenderer(boolean playback) {
        this(playback ? AudioSystem.DataFlow.PLAYBACK : AudioSystem.DataFlow.NOTIFY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        block11: {
            block9: {
                try {
                    this.stop();
                    Object var2_1 = null;
                    if (this.iAudioRenderClient == 0L) break block9;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.iAudioRenderClient != 0L) {
                        WASAPI.IAudioRenderClient_Release(this.iAudioRenderClient);
                        this.iAudioRenderClient = 0L;
                    }
                    if (this.iAudioClient != 0L) {
                        WASAPI.IAudioClient_Release(this.iAudioClient);
                        this.iAudioClient = 0L;
                    }
                    if (this.eventHandle != 0L) {
                        try {
                            WASAPI.CloseHandle(this.eventHandle);
                        }
                        catch (HResultException hre) {
                            logger.warn("Failed to close event HANDLE.", hre);
                        }
                        this.eventHandle = 0L;
                    }
                    this.remainder = null;
                    this.remainderLength = 0;
                    this.started = false;
                    super.close();
                    throw throwable;
                }
                WASAPI.IAudioRenderClient_Release(this.iAudioRenderClient);
                this.iAudioRenderClient = 0L;
            }
            if (this.iAudioClient != 0L) {
                WASAPI.IAudioClient_Release(this.iAudioClient);
                this.iAudioClient = 0L;
            }
            if (this.eventHandle == 0L) break block11;
            try {
                WASAPI.CloseHandle(this.eventHandle);
            }
            catch (HResultException hre) {
                logger.warn("Failed to close event HANDLE.", hre);
            }
            this.eventHandle = 0L;
            {
            }
        }
        this.remainder = null;
        this.remainderLength = 0;
        this.started = false;
        super.close();
    }

    private AudioFormat[] getFormatsToInitializeIAudioClient() {
        AudioFormat inputFormat = (AudioFormat)this.inputFormat;
        if (inputFormat == null) {
            throw new NullPointerException("No inputFormat set.");
        }
        return WASAPISystem.getFormatsToInitializeIAudioClient(inputFormat);
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void open() throws ResourceUnavailableException {
        block22: {
            if (this.iAudioClient != 0L) {
                return;
            }
            try {
                MediaLocator locator = this.getLocator();
                if (locator == null) {
                    throw new NullPointerException("No locator/MediaLocator set.");
                }
                AudioFormat[] formats = this.getFormatsToInitializeIAudioClient();
                long eventHandle = WASAPI.CreateEvent(0L, false, false, null);
                try {
                    block21: {
                        long hnsBufferDuration = 200000L;
                        long iAudioClient = ((WASAPISystem)this.audioSystem).initializeIAudioClient(locator, this.dataFlow, eventHandle, hnsBufferDuration, formats);
                        if (iAudioClient == 0L) {
                            throw new ResourceUnavailableException("Failed to initialize IAudioClient for MediaLocator " + locator + " and AudioSystem.DataFlow " + (Object)((Object)this.dataFlow));
                        }
                        try {
                            block20: {
                                long iAudioRenderClient;
                                AudioFormat format = null;
                                for (AudioFormat aFormat : formats) {
                                    if (aFormat == null) continue;
                                    format = aFormat;
                                    break;
                                }
                                if ((iAudioRenderClient = WASAPI.IAudioClient_GetService(iAudioClient, "{f294acfc-3146-4483-a7bf-addca7c260e2}")) == 0L) {
                                    throw new ResourceUnavailableException("IAudioClient_GetService(IID_IAudioRenderClient)");
                                }
                                try {
                                    this.periodicity = WASAPI.IAudioClient_GetDefaultDevicePeriod(iAudioClient);
                                    this.numBufferFrames = WASAPI.IAudioClient_GetBufferSize(iAudioClient);
                                    long bufferDuration = this.numBufferFrames * 1000 / (int)format.getSampleRate();
                                    this.periodicity /= 10000L;
                                    if (this.periodicity <= 1L) {
                                        this.periodicity = bufferDuration / 2L;
                                        if (this.periodicity < 10L) {
                                            this.periodicity = 10L;
                                        }
                                    }
                                    this.dstChannels = format.getChannels();
                                    this.dstSampleSize = WASAPISystem.getSampleSizeInBytes(format);
                                    this.remainder = new byte[this.numBufferFrames * this.srcFrameSize];
                                    this.remainderLength = this.remainder.length;
                                    this.eventHandle = eventHandle;
                                    eventHandle = 0L;
                                    this.iAudioClient = iAudioClient;
                                    iAudioClient = 0L;
                                    this.iAudioRenderClient = iAudioRenderClient;
                                    iAudioRenderClient = 0L;
                                    Object var15_15 = null;
                                    if (iAudioRenderClient == 0L) break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var15_16 = null;
                                    if (iAudioRenderClient != 0L) {
                                        WASAPI.IAudioRenderClient_Release(iAudioRenderClient);
                                    }
                                    throw throwable;
                                }
                                WASAPI.IAudioRenderClient_Release(iAudioRenderClient);
                            }
                            Object var17_18 = null;
                            if (iAudioClient == 0L) break block21;
                        }
                        catch (Throwable throwable) {
                            Object var17_19 = null;
                            if (iAudioClient != 0L) {
                                WASAPI.IAudioClient_Release(iAudioClient);
                            }
                            throw throwable;
                        }
                        WASAPI.IAudioClient_Release(iAudioClient);
                    }
                    Object var19_21 = null;
                    if (eventHandle == 0L) break block22;
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    if (eventHandle != 0L) {
                        WASAPI.CloseHandle(eventHandle);
                    }
                    throw throwable;
                }
                WASAPI.CloseHandle(eventHandle);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (t instanceof ResourceUnavailableException) {
                    throw (ResourceUnavailableException)t;
                }
                ResourceUnavailableException rue = new ResourceUnavailableException();
                rue.initCause(t);
                throw rue;
            }
        }
        super.open();
    }

    @Override
    protected synchronized void playbackDevicePropertyChange(PropertyChangeEvent ev) {
        boolean open;
        this.waitWhileBusy();
        boolean bl = open = this.iAudioClient != 0L && this.iAudioRenderClient != 0L;
        if (open) {
            boolean start = this.started;
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                throw new UndeclaredThrowableException(rue);
            }
            if (start) {
                this.start();
            }
        }
    }

    private void popFromRemainder(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length");
        }
        if (length == 0) {
            return;
        }
        int newRemainderLength = this.remainderLength - length;
        if (newRemainderLength > 0) {
            int i = 0;
            int j = length;
            while (i < newRemainderLength) {
                this.remainder[i] = this.remainder[j];
                ++i;
                ++j;
            }
            this.remainderLength = newRemainderLength;
        } else {
            this.remainderLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        WASAPIRenderer wASAPIRenderer;
        int length = buffer.getLength();
        if (length < 1) {
            return 0;
        }
        byte[] data = (byte[])buffer.getData();
        int offset = buffer.getOffset();
        WASAPIRenderer wASAPIRenderer2 = this;
        synchronized (wASAPIRenderer2) {
            if (this.iAudioClient == 0L || this.iAudioRenderClient == 0L || !this.started) {
                return 1;
            }
            this.waitWhileBusy();
            this.busy = true;
        }
        int ret = 0;
        long sleep = 0L;
        try {
            int numPaddingFrames;
            if (this.eventHandle == 0L) {
                try {
                    numPaddingFrames = WASAPI.IAudioClient_GetCurrentPadding(this.iAudioClient);
                }
                catch (HResultException hre) {
                    numPaddingFrames = 0;
                    ret = 1;
                    logger.error("IAudioClient_GetCurrentPadding", hre);
                }
            } else {
                numPaddingFrames = this.numBufferFrames;
            }
            if (ret != 1) {
                int numFramesRequested = this.numBufferFrames - numPaddingFrames;
                if (numFramesRequested == 0) {
                    if (this.eventHandle == 0L) {
                        ret |= 2;
                        sleep = this.periodicity;
                    } else {
                        int toCopy = this.remainder.length - this.remainderLength;
                        if (toCopy > 0) {
                            if (toCopy > length) {
                                toCopy = length;
                            }
                            System.arraycopy(data, offset, this.remainder, this.remainderLength, toCopy);
                            this.remainderLength += toCopy;
                            if (length > toCopy) {
                                buffer.setLength(length - toCopy);
                                buffer.setOffset(offset + toCopy);
                                ret |= 2;
                            }
                        } else {
                            ret |= 2;
                            sleep = this.periodicity;
                        }
                    }
                } else {
                    int written;
                    int effectiveOffset;
                    byte[] effectiveData;
                    int effectiveLength = this.remainderLength + length;
                    int toWrite = Math.min(effectiveLength, numFramesRequested * this.srcFrameSize);
                    if (this.remainderLength > 0) {
                        effectiveData = this.remainder;
                        effectiveOffset = 0;
                        int toCopy = toWrite - this.remainderLength;
                        if (toCopy <= 0) {
                            ret |= 2;
                        } else {
                            if (toCopy > length) {
                                toCopy = length;
                            }
                            System.arraycopy(data, offset, this.remainder, this.remainderLength, toCopy);
                            this.remainderLength += toCopy;
                            if (toWrite > this.remainderLength) {
                                toWrite = this.remainderLength;
                            }
                            if (length > toCopy) {
                                buffer.setLength(length - toCopy);
                                buffer.setOffset(offset + toCopy);
                                ret |= 2;
                            }
                        }
                    } else {
                        effectiveData = data;
                        effectiveOffset = offset;
                    }
                    if (toWrite / this.srcFrameSize == 0) {
                        written = 0;
                    } else {
                        try {
                            written = WASAPI.IAudioRenderClient_Write(this.iAudioRenderClient, effectiveData, effectiveOffset, toWrite, this.srcSampleSize, this.srcChannels, this.dstSampleSize, this.dstChannels);
                        }
                        catch (HResultException hre) {
                            written = 0;
                            ret = 1;
                            logger.error("IAudioRenderClient_Write", hre);
                        }
                    }
                    if (ret != 1) {
                        if (effectiveData == data) {
                            if (written == 0) {
                                System.arraycopy(data, offset, this.remainder, this.remainderLength, toWrite);
                                this.remainderLength += toWrite;
                                written = toWrite;
                            }
                            if (length > written) {
                                buffer.setLength(length - written);
                                buffer.setOffset(offset + written);
                                ret |= 2;
                            }
                        } else if (written > 0) {
                            this.popFromRemainder(written);
                        }
                    }
                }
            }
            Object var17_21 = null;
            wASAPIRenderer = this;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            WASAPIRenderer wASAPIRenderer3 = this;
            synchronized (wASAPIRenderer3) {
                this.busy = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (wASAPIRenderer) {
            this.busy = false;
            this.notifyAll();
        }
        if ((ret & 2) == 2 && sleep > 0L) {
            boolean interrupted = false;
            WASAPIRenderer wASAPIRenderer4 = this;
            synchronized (wASAPIRenderer4) {
                try {
                    this.wait(sleep);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInEventHandleCmd(Runnable eventHandleCmd) {
        WASAPIRenderer wASAPIRenderer;
        try {
            int wfso;
            WASAPIRenderer.useAudioThreadPriority();
            do {
                WASAPIRenderer wASAPIRenderer2;
                Object var11_13;
                long eventHandle;
                WASAPIRenderer wASAPIRenderer3 = this;
                synchronized (wASAPIRenderer3) {
                    if (!eventHandleCmd.equals(this.eventHandleCmd)) {
                        break;
                    }
                    if (this.iAudioClient == 0L || this.iAudioRenderClient == 0L || !this.started) {
                        break;
                    }
                    eventHandle = this.eventHandle;
                    if (eventHandle == 0L) {
                        throw new IllegalStateException("eventHandle");
                    }
                    this.waitWhileBusy();
                    this.busy = true;
                }
                try {
                    int numPaddingFrames;
                    try {
                        numPaddingFrames = WASAPI.IAudioClient_GetCurrentPadding(this.iAudioClient);
                    }
                    catch (HResultException hre) {
                        numPaddingFrames = this.numBufferFrames;
                        logger.error("IAudioClient_GetCurrentPadding", hre);
                    }
                    int numFramesRequested = this.numBufferFrames - numPaddingFrames;
                    if (numFramesRequested > 0) {
                        int written;
                        int toWrite = numFramesRequested * this.srcFrameSize;
                        int silence = toWrite - this.remainderLength;
                        if (silence > 0) {
                            Arrays.fill(this.remainder, this.remainderLength, toWrite, (byte)0);
                            this.remainderLength = toWrite;
                        }
                        try {
                            written = WASAPI.IAudioRenderClient_Write(this.iAudioRenderClient, this.remainder, 0, toWrite, this.srcSampleSize, this.srcChannels, this.dstSampleSize, this.dstChannels);
                        }
                        catch (HResultException hre) {
                            written = 0;
                            logger.error("IAudioRenderClient_Write", hre);
                        }
                        this.popFromRemainder(written);
                    }
                    var11_13 = null;
                    wASAPIRenderer2 = this;
                }
                catch (Throwable throwable) {
                    var11_13 = null;
                    wASAPIRenderer2 = this;
                    synchronized (wASAPIRenderer2) {
                        this.busy = false;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (wASAPIRenderer2) {
                    this.busy = false;
                    this.notifyAll();
                }
                try {
                    wfso = WASAPI.WaitForSingleObject(eventHandle, this.periodicity);
                }
                catch (HResultException hre) {
                    wfso = -1;
                    logger.error("WaitForSingleObject", hre);
                }
            } while (wfso != -1);
            Object var15_18 = null;
            wASAPIRenderer = this;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            WASAPIRenderer wASAPIRenderer4 = this;
            synchronized (wASAPIRenderer4) {
                if (eventHandleCmd.equals(this.eventHandleCmd)) {
                    this.eventHandleCmd = null;
                    this.notifyAll();
                }
            }
            throw throwable;
        }
        synchronized (wASAPIRenderer) {
            if (eventHandleCmd.equals(this.eventHandleCmd)) {
                this.eventHandleCmd = null;
                this.notifyAll();
            }
        }
    }

    @Override
    public Format setInputFormat(Format format) {
        AudioFormat oldValue = (AudioFormat)this.inputFormat;
        Format setInputFormat = super.setInputFormat(format);
        AudioFormat newValue = (AudioFormat)this.inputFormat;
        if (newValue != null && !newValue.equals((Object)oldValue)) {
            this.srcChannels = newValue.getChannels();
            this.srcSampleSize = WASAPISystem.getSampleSizeInBytes(newValue);
            this.srcFrameSize = this.srcSampleSize * this.srcChannels;
        }
        return setInputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        block14: {
            if (this.iAudioClient != 0L) {
                this.waitWhileBusy();
                this.waitWhileEventHandleCmd();
                if (this.remainder != null) {
                    int silence;
                    if (this.remainderLength > 0) {
                        int i = this.remainder.length - 1;
                        for (int j = this.remainderLength - 1; j >= 0; --j) {
                            this.remainder[i] = this.remainder[j];
                            --i;
                        }
                    } else if (this.remainderLength < 0) {
                        this.remainderLength = 0;
                    }
                    if ((silence = this.remainder.length - this.remainderLength) > 0) {
                        Arrays.fill(this.remainder, 0, silence, (byte)0);
                    }
                    this.remainderLength = this.remainder.length;
                }
                try {
                    WASAPI.IAudioClient_Start(this.iAudioClient);
                    this.started = true;
                    if (this.eventHandle == 0L || this.eventHandleCmd != null) break block14;
                    Runnable eventHandleCmd = new Runnable(){

                        public void run() {
                            WASAPIRenderer.this.runInEventHandleCmd(this);
                        }
                    };
                    boolean submitted = false;
                    try {
                        if (this.eventHandleExecutor == null) {
                            this.eventHandleExecutor = Executors.newSingleThreadExecutor();
                        }
                        this.eventHandleCmd = eventHandleCmd;
                        this.eventHandleExecutor.execute(eventHandleCmd);
                        submitted = true;
                        Object var4_5 = null;
                        if (!submitted && eventHandleCmd.equals(this.eventHandleCmd)) {
                            this.eventHandleCmd = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (!submitted && eventHandleCmd.equals(this.eventHandleCmd)) {
                            this.eventHandleCmd = null;
                        }
                        throw throwable;
                    }
                }
                catch (HResultException hre) {
                    if (hre.getHResult() == WASAPI.AUDCLNT_E_NOT_STOPPED) break block14;
                    logger.error("IAudioClient_Start", hre);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.iAudioClient != 0L) {
            this.waitWhileBusy();
            try {
                WASAPI.IAudioClient_Stop(this.iAudioClient);
                this.started = false;
                this.waitWhileEventHandleCmd();
            }
            catch (HResultException hre) {
                logger.error("IAudioClient_Stop", hre);
            }
        }
    }

    private synchronized void waitWhileBusy() {
        boolean interrupted = false;
        while (this.busy) {
            try {
                this.wait(this.periodicity);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitWhileEventHandleCmd() {
        if (this.eventHandle == 0L) {
            throw new IllegalStateException("eventHandle");
        }
        boolean interrupted = false;
        while (this.eventHandleCmd != null) {
            try {
                this.wait(this.periodicity);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

