/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.util.Logger;

public class WASAPIStream
extends AbstractPullBufferStream {
    private static final long DEFAULT_BUFFER_DURATION = 20L;
    private static Logger logger = Logger.getLogger(WASAPIStream.class);
    private final WASAPISystem audioSystem = (WASAPISystem)AudioSystem.getAudioSystem("wasapi");
    private int bufferLength;
    private boolean busy;
    private int dstChannels;
    private int dstFrameSize;
    private int dstSampleSize;
    private AudioFormat format;
    private long iAudioCaptureClient;
    private long iAudioClient;
    private MediaLocator locator;
    private long periodicity = 10L;
    private int srcChannels;
    private int srcSampleSize;
    private boolean started;

    public WASAPIStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        if (this.audioSystem == null) {
            throw new IllegalStateException("audioSystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect() throws IOException {
        if (this.iAudioClient != 0L) {
            return;
        }
        try {
            MediaLocator locator = this.getLocator();
            AudioSystem.DataFlow dataFlow = AudioSystem.DataFlow.CAPTURE;
            long hnsBufferDuration = 400000L;
            AudioFormat thisFormat = (AudioFormat)this.getFormat();
            AudioFormat[] formats = WASAPISystem.getFormatsToInitializeIAudioClient(thisFormat);
            long iAudioClient = this.audioSystem.initializeIAudioClient(locator, dataFlow, 0L, hnsBufferDuration, formats);
            if (iAudioClient == 0L) {
                throw new ResourceUnavailableException("Failed to initialize IAudioClient for MediaLocator " + locator + " and AudioSystem.DataFlow " + (Object)((Object)dataFlow));
            }
            try {
                block14: {
                    long iAudioCaptureClient;
                    AudioFormat format = null;
                    for (AudioFormat aFormat : formats) {
                        if (aFormat == null) continue;
                        format = aFormat;
                        break;
                    }
                    if ((iAudioCaptureClient = WASAPI.IAudioClient_GetService(iAudioClient, "{c8adbd64-e71e-48a0-a4de-185c395cd317}")) == 0L) {
                        throw new ResourceUnavailableException("IAudioClient_GetService(IID_IAudioCaptureClient)");
                    }
                    try {
                        this.periodicity = WASAPI.IAudioClient_GetDefaultDevicePeriod(iAudioClient);
                        int numBufferFrames = WASAPI.IAudioClient_GetBufferSize(iAudioClient);
                        long bufferDuration = numBufferFrames * 1000 / (int)format.getSampleRate();
                        this.periodicity /= 10000L;
                        if (this.periodicity <= 1L) {
                            this.periodicity = bufferDuration / 4L;
                            if (this.periodicity < 10L) {
                                this.periodicity = 10L;
                            }
                        }
                        this.srcChannels = format.getChannels();
                        this.srcSampleSize = WASAPISystem.getSampleSizeInBytes(format);
                        this.dstChannels = thisFormat.getChannels();
                        this.dstSampleSize = WASAPISystem.getSampleSizeInBytes(thisFormat);
                        this.dstFrameSize = this.dstSampleSize * this.dstChannels;
                        this.bufferLength = (int)(20L * (long)this.dstFrameSize * (long)((int)thisFormat.getSampleRate()) / 1000L);
                        this.format = thisFormat;
                        this.iAudioClient = iAudioClient;
                        iAudioClient = 0L;
                        this.iAudioCaptureClient = iAudioCaptureClient;
                        iAudioCaptureClient = 0L;
                        Object var16_16 = null;
                        if (iAudioCaptureClient == 0L) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        if (iAudioCaptureClient == 0L) throw throwable;
                        WASAPI.IAudioCaptureClient_Release(iAudioCaptureClient);
                        throw throwable;
                    }
                    WASAPI.IAudioCaptureClient_Release(iAudioCaptureClient);
                }
                Object var18_19 = null;
                if (iAudioClient == 0L) return;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (iAudioClient == 0L) throw throwable;
                WASAPI.IAudioClient_Release(iAudioClient);
                throw throwable;
            }
            WASAPI.IAudioClient_Release(iAudioClient);
            return;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            IOException ioe = new IOException();
            ioe.initCause(t);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() throws IOException {
        block5: {
            try {
                this.stop();
                Object var2_1 = null;
                if (this.iAudioCaptureClient == 0L) break block5;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.iAudioCaptureClient != 0L) {
                    WASAPI.IAudioCaptureClient_Release(this.iAudioCaptureClient);
                    this.iAudioCaptureClient = 0L;
                }
                if (this.iAudioClient != 0L) {
                    WASAPI.IAudioClient_Release(this.iAudioClient);
                    this.iAudioClient = 0L;
                }
                this.format = null;
                this.started = false;
                throw throwable;
            }
            WASAPI.IAudioCaptureClient_Release(this.iAudioCaptureClient);
            this.iAudioCaptureClient = 0L;
        }
        if (this.iAudioClient != 0L) {
            WASAPI.IAudioClient_Release(this.iAudioClient);
            this.iAudioClient = 0L;
        }
        this.format = null;
        this.started = false;
    }

    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    public int doRead(Buffer buffer) throws IOException {
        int read;
        int numPaddingFrames;
        int numFramesInNextPacket;
        try {
            numFramesInNextPacket = WASAPI.IAudioCaptureClient_GetNextPacketSize(this.iAudioCaptureClient);
        }
        catch (HResultException hre) {
            numFramesInNextPacket = 0;
            WASAPIStream.throwNewIOException("IAudioCaptureClient_GetNextPacketSize", hre);
        }
        int offset = buffer.getOffset() + buffer.getLength();
        int toRead = numFramesInNextPacket * this.dstFrameSize;
        byte[] data = AbstractCodec2.validateByteArraySize(buffer, offset + toRead, true);
        try {
            numPaddingFrames = WASAPI.IAudioClient_GetCurrentPadding(this.iAudioClient);
        }
        catch (HResultException hre) {
            numPaddingFrames = 0;
            WASAPIStream.throwNewIOException("IAudioClient_GetCurrentPadding", hre);
        }
        if (numFramesInNextPacket != 0 && numFramesInNextPacket <= numPaddingFrames) {
            try {
                read = WASAPI.IAudioCaptureClient_Read(this.iAudioCaptureClient, data, offset, toRead, this.srcSampleSize, this.srcChannels, this.dstSampleSize, this.dstChannels);
            }
            catch (HResultException hre) {
                read = 0;
                WASAPIStream.throwNewIOException("IAudioCaptureClient_Read", hre);
            }
            if (read != 0 && offset == 0) {
                long timeStamp = System.nanoTime();
                buffer.setFlags(128);
                buffer.setTimeStamp(timeStamp);
            }
        } else {
            read = 0;
        }
        return read;
    }

    private MediaLocator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void read(Buffer buffer) throws IOException {
        Throwable cause;
        block25: {
            if (this.bufferLength != 0) {
                AbstractCodec2.validateByteArraySize(buffer, this.bufferLength, false);
            }
            buffer.setLength(0);
            buffer.setOffset(0);
            while (true) {
                WASAPIStream wASAPIStream;
                Object var7_11;
                int read;
                String message;
                WASAPIStream wASAPIStream2 = this;
                // MONITORENTER : wASAPIStream2
                if (this.iAudioClient == 0L || this.iAudioCaptureClient == 0L) {
                    message = this.getClass().getName() + " is disconnected.";
                } else if (!this.started) {
                    message = this.getClass().getName() + " is stopped.";
                } else {
                    message = null;
                    this.busy = true;
                }
                // MONITOREXIT : wASAPIStream2
                if (message != null) {
                    WASAPIStream.yield();
                    throw new IOException(message);
                }
                try {
                    try {
                        read = this.doRead(buffer);
                        cause = null;
                    }
                    catch (Throwable t) {
                        read = 0;
                        cause = t;
                        var7_11 = null;
                        wASAPIStream = this;
                        // MONITORENTER : wASAPIStream
                        this.busy = false;
                        this.notifyAll();
                        // MONITOREXIT : wASAPIStream
                    }
                    var7_11 = null;
                    wASAPIStream = this;
                    // MONITORENTER : wASAPIStream
                    this.busy = false;
                    this.notifyAll();
                    // MONITOREXIT : wASAPIStream
                }
                catch (Throwable wASAPIStream3) {
                    var7_11 = null;
                    wASAPIStream = this;
                    // MONITORENTER : wASAPIStream
                    this.busy = false;
                    this.notifyAll();
                    // MONITOREXIT : wASAPIStream
                    throw wASAPIStream3;
                }
                if (cause != null) break block25;
                if (read == 0) {
                    boolean interrupted = false;
                    WASAPIStream wASAPIStream3 = this;
                    // MONITORENTER : wASAPIStream3
                    try {
                        this.wait(this.periodicity);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                int length = buffer.getLength() + read;
                buffer.setLength(length);
                if (length >= this.bufferLength) break;
            }
            if (this.format == null) return;
            buffer.setFormat((Format)this.format);
            return;
        }
        if (cause instanceof ThreadDeath) {
            throw (ThreadDeath)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        IOException ioe = new IOException();
        ioe.initCause(cause);
        throw ioe;
    }

    void setLocator(MediaLocator locator) throws IOException {
        if (this.locator != locator) {
            if (this.locator != null) {
                this.disconnect();
            }
            this.locator = locator;
            if (this.locator != null) {
                this.connect();
            }
        }
    }

    public synchronized void start() throws IOException {
        block3: {
            if (this.iAudioClient != 0L) {
                this.waitWhileBusy();
                try {
                    WASAPI.IAudioClient_Start(this.iAudioClient);
                    this.started = true;
                }
                catch (HResultException hre) {
                    if (hre.getHResult() == WASAPI.AUDCLNT_E_NOT_STOPPED) break block3;
                    String message = "IAudioClient_Start";
                    logger.error(message, hre);
                    WASAPIStream.throwNewIOException(message, hre);
                }
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (this.iAudioClient != 0L) {
            this.waitWhileBusy();
            try {
                WASAPI.IAudioClient_Stop(this.iAudioClient);
                this.started = false;
            }
            catch (HResultException hre) {
                String message = "IAudioClient_Stop";
                logger.error(message, hre);
                WASAPIStream.throwNewIOException(message, hre);
            }
        }
    }

    private static void throwNewIOException(String message, HResultException hre) throws IOException {
        logger.error(message, hre);
        IOException ioe = new IOException(message);
        ioe.initCause(hre);
        throw ioe;
    }

    private synchronized void waitWhileBusy() {
        boolean interrupted = false;
        while (this.busy) {
            try {
                this.wait(this.periodicity);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void yield() {
        boolean interrupted = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

