/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;

public class ByteBufferPool {
    private final List<PooledByteBuffer> buffers = new ArrayList<PooledByteBuffer>();

    public synchronized void drain() {
        Iterator<PooledByteBuffer> i = this.buffers.iterator();
        while (i.hasNext()) {
            PooledByteBuffer buffer = i.next();
            i.remove();
            buffer.doFree();
        }
    }

    public synchronized ByteBuffer getBuffer(int capacity) {
        capacity += 8;
        ByteBuffer buffer = null;
        Iterator<PooledByteBuffer> i = this.buffers.iterator();
        while (i.hasNext()) {
            ByteBuffer aBuffer = i.next();
            if (aBuffer.getCapacity() < capacity) continue;
            i.remove();
            buffer = aBuffer;
            break;
        }
        if (buffer == null) {
            buffer = new PooledByteBuffer(capacity, this);
        }
        return buffer;
    }

    private synchronized void returnBuffer(PooledByteBuffer buffer) {
        if (!this.buffers.contains(buffer)) {
            this.buffers.add(buffer);
        }
    }

    private static class PooledByteBuffer
    extends ByteBuffer {
        private final WeakReference<ByteBufferPool> pool;

        public PooledByteBuffer(int capacity, ByteBufferPool pool) {
            super(capacity);
            this.pool = new WeakReference<ByteBufferPool>(pool);
        }

        void doFree() {
            super.free();
        }

        public void free() {
            ByteBufferPool pool = (ByteBufferPool)this.pool.get();
            if (pool == null) {
                this.doFree();
            } else {
                pool.returnBuffer(this);
            }
        }
    }
}

