/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.format;

import java.awt.Dimension;
import java.util.Map;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.format.VideoMediaFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoMediaFormatImpl
extends MediaFormatImpl<VideoFormat>
implements VideoMediaFormat {
    public static final double DEFAULT_CLOCK_RATE = 90000.0;
    private final double clockRate;

    VideoMediaFormatImpl(String encoding) {
        this(encoding, 90000.0);
    }

    VideoMediaFormatImpl(String encoding, double clockRate) {
        this(new VideoFormat(encoding), clockRate);
    }

    VideoMediaFormatImpl(VideoFormat format) {
        this(format, 90000.0);
    }

    VideoMediaFormatImpl(VideoFormat format, double clockRate) {
        this(format, clockRate, -1.0f, null, null);
    }

    VideoMediaFormatImpl(VideoFormat format, double clockRate, float frameRate, Map<String, String> formatParameters, Map<String, String> advancedParameters) {
        super(new ParameterizedVideoFormat(format.getEncoding(), format.getSize(), format.getMaxDataLength(), format.getDataType(), frameRate, formatParameters), formatParameters, advancedParameters);
        this.clockRate = clockRate;
    }

    @Override
    public boolean equals(Object mediaFormat) {
        if (this == mediaFormat) {
            return true;
        }
        if (!super.equals(mediaFormat)) {
            return false;
        }
        VideoMediaFormatImpl videoMediaFormatImpl = (VideoMediaFormatImpl)mediaFormat;
        double clockRate = this.getClockRate();
        double videoMediaFormatImplClockRate = videoMediaFormatImpl.getClockRate();
        if (-1.0 == clockRate) {
            clockRate = 90000.0;
        }
        if (-1.0 == videoMediaFormatImplClockRate) {
            videoMediaFormatImplClockRate = 90000.0;
        }
        return clockRate == videoMediaFormatImplClockRate;
    }

    @Override
    protected boolean formatParametersAreEqual(Map<String, String> fmtps1, Map<String, String> fmtps2) {
        return VideoMediaFormatImpl.formatParametersAreEqual(this.getEncoding(), fmtps1, fmtps2);
    }

    public static boolean formatParametersAreEqual(String encoding, Map<String, String> fmtps1, Map<String, String> fmtps2) {
        if ("H264".equalsIgnoreCase(encoding) || "h264/rtp".equalsIgnoreCase(encoding)) {
            String packetizationMode = "packetization-mode";
            String pm1 = null;
            String pm2 = null;
            if (fmtps1 != null) {
                pm1 = fmtps1.remove(packetizationMode);
            }
            if (fmtps2 != null) {
                pm2 = fmtps2.remove(packetizationMode);
            }
            if (pm1 == null) {
                pm1 = "0";
            }
            if (pm2 == null) {
                pm2 = "0";
            }
            if (!pm1.equals(pm2)) {
                return false;
            }
        }
        return MediaFormatImpl.formatParametersAreEqual(encoding, fmtps1, fmtps2);
    }

    @Override
    public boolean formatParametersMatch(Map<String, String> fmtps) {
        return VideoMediaFormatImpl.formatParametersMatch(this.getEncoding(), this.getFormatParameters(), fmtps) && super.formatParametersMatch(fmtps);
    }

    public static boolean formatParametersMatch(String encoding, Map<String, String> fmtps1, Map<String, String> fmtps2) {
        if ("H264".equalsIgnoreCase(encoding) || "h264/rtp".equalsIgnoreCase(encoding)) {
            String pm2;
            String packetizationMode = "packetization-mode";
            String pm1 = fmtps1 == null ? null : fmtps1.get(packetizationMode);
            String string = pm2 = fmtps2 == null ? null : fmtps2.get(packetizationMode);
            if (pm1 == null) {
                pm1 = "0";
            }
            if (pm2 == null) {
                pm2 = "0";
            }
            if (!pm1.equals(pm2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public double getClockRate() {
        return this.clockRate;
    }

    @Override
    public float getFrameRate() {
        return ((VideoFormat)this.format).getFrameRate();
    }

    @Override
    public final MediaType getMediaType() {
        return MediaType.VIDEO;
    }

    @Override
    public Dimension getSize() {
        return ((VideoFormat)this.format).getSize();
    }

    @Override
    public int hashCode() {
        double clockRate = this.getClockRate();
        if (-1.0 == clockRate) {
            clockRate = 90000.0;
        }
        return super.hashCode() | Double.valueOf(clockRate).hashCode();
    }
}

