/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.format;

import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.format.AudioMediaFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMediaFormatImpl
extends MediaFormatImpl<AudioFormat>
implements AudioMediaFormat {
    AudioMediaFormatImpl(AudioFormat format) {
        this(format, (Map<String, String>)null, (Map<String, String>)null);
    }

    AudioMediaFormatImpl(AudioFormat format, Map<String, String> formatParameters, Map<String, String> advancedParameters) {
        super(AudioMediaFormatImpl.fixChannels(format), formatParameters, advancedParameters);
    }

    public AudioMediaFormatImpl(String encoding) {
        this(new AudioFormat(encoding));
    }

    AudioMediaFormatImpl(String encoding, double clockRate) {
        this(encoding, clockRate, 1);
    }

    AudioMediaFormatImpl(String encoding, double clockRate, int channels) {
        this(encoding, clockRate, channels, null, null);
    }

    AudioMediaFormatImpl(String encoding, double clockRate, Map<String, String> formatParameters, Map<String, String> advancedParameters) {
        this(encoding, clockRate, 1, formatParameters, advancedParameters);
    }

    AudioMediaFormatImpl(String encoding, double clockRate, int channels, Map<String, String> formatParameters, Map<String, String> advancedParameters) {
        this(new AudioFormat(encoding, clockRate, -1, channels), formatParameters, advancedParameters);
    }

    private static AudioFormat fixChannels(AudioFormat format) {
        if (-1 == format.getChannels()) {
            format = (AudioFormat)format.intersects((Format)new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), 1));
        }
        return format;
    }

    @Override
    public int getChannels() {
        int channels = ((AudioFormat)this.format).getChannels();
        return -1 == channels ? 1 : channels;
    }

    @Override
    public double getClockRate() {
        return ((AudioFormat)this.format).getSampleRate();
    }

    @Override
    public final MediaType getMediaType() {
        return MediaType.AUDIO;
    }
}

