/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.ArrayList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.IMMNotificationClient;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.MMNotificationClient;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.WASAPIRenderer;
import org.jitsi.service.neomedia.codec.Constants;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAPISystem
extends AudioSystem {
    private static String audioSessionGuid;
    private static final String LOCATOR_PROTOCOL = "wasapi";
    private static final Logger logger;
    private long iMMDeviceEnumerator;
    private IMMNotificationClient pNotify;
    private long waveformatex;

    WASAPISystem() throws Exception {
        super(LOCATOR_PROTOCOL, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doInitialize() throws Exception {
        ArrayList<CaptureDeviceInfo2> playbackDevices;
        ArrayList<CaptureDeviceInfo2> captureDevices;
        long iMMDeviceCollection;
        WASAPI.CoInitializeEx(0L, 0);
        if (this.iMMDeviceEnumerator == 0L) {
            this.iMMDeviceEnumerator = WASAPI.CoCreateInstance("{bcde0395-e52f-467c-8e3d-c4579291692e}", 0L, 23, "{a95664d2-9614-4f35-a746-de8db63617e6}");
            if (this.iMMDeviceEnumerator == 0L) {
                throw new IllegalStateException("iMMDeviceEnumerator");
            }
            MMNotificationClient.RegisterEndpointNotificationCallback(this.pNotify);
        }
        if ((iMMDeviceCollection = WASAPI.IMMDeviceEnumerator_EnumAudioEndpoints(this.iMMDeviceEnumerator, 2, 1)) == 0L) {
            throw new RuntimeException("IMMDeviceEnumerator_EnumAudioEndpoints");
        }
        try {
            int count = WASAPI.IMMDeviceCollection_GetCount(iMMDeviceCollection);
            captureDevices = new ArrayList<CaptureDeviceInfo2>(count);
            playbackDevices = new ArrayList<CaptureDeviceInfo2>(count);
            for (int i = 0; i < count; ++i) {
                Object var11_8;
                long iMMDevice = WASAPI.IMMDeviceCollection_Item(iMMDeviceCollection, i);
                if (iMMDevice == 0L) {
                    throw new RuntimeException("IMMDeviceCollection_Item");
                }
                try {
                    try {
                        this.doInitializeIMMDevice(iMMDevice, captureDevices, playbackDevices);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("Failed to doInitialize for IMMDevice at index " + i, t);
                        var11_8 = null;
                        WASAPI.IMMDevice_Release(iMMDevice);
                        continue;
                    }
                    var11_8 = null;
                }
                catch (Throwable throwable) {
                    var11_8 = null;
                    WASAPI.IMMDevice_Release(iMMDevice);
                    throw throwable;
                }
                WASAPI.IMMDevice_Release(iMMDevice);
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            WASAPI.IMMDeviceCollection_Release(iMMDeviceCollection);
            throw throwable;
        }
        WASAPI.IMMDeviceCollection_Release(iMMDeviceCollection);
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitializeIMMDevice(long iMMDevice, List<CaptureDeviceInfo2> captureDevices, List<CaptureDeviceInfo2> playbackDevices) throws HResultException {
        List<AudioFormat> formats;
        String id = WASAPI.IMMDevice_GetId(iMMDevice);
        if (id == null) {
            throw new RuntimeException("IMMDevice_GetId");
        }
        long iAudioClient = WASAPI.IMMDevice_Activate(iMMDevice, "{1cb9ad4c-dbfa-4c32-b178-c2f568a703b2}", 23, 0L);
        if (iAudioClient == 0L) {
            throw new RuntimeException("IMMDevice_Activate");
        }
        try {
            formats = this.getIAudioClientSupportedFormats(iAudioClient);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            WASAPI.IAudioClient_Release(iAudioClient);
            throw throwable;
        }
        WASAPI.IAudioClient_Release(iAudioClient);
        if (formats != null && !formats.isEmpty()) {
            String name = null;
            try {
                name = this.getIMMDeviceFriendlyName(iMMDevice);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn("Failed to retrieve the PKEY_Device_FriendlyName of IMMDevice " + id, t);
            }
            if (name == null || name.length() == 0) {
                name = id;
            }
            int dataFlow = this.getIMMDeviceDataFlow(iMMDevice);
            CaptureDeviceInfo2 cdi2 = new CaptureDeviceInfo2(name, new MediaLocator("wasapi:" + id), formats.toArray(new Format[formats.size()]), id, null, null);
            switch (dataFlow) {
                case 1: {
                    captureDevices.add(cdi2);
                    break;
                }
                case 0: {
                    playbackDevices.add(cdi2);
                    break;
                }
                default: {
                    logger.error("Failed to retrieve dataFlow from IMMEndpoint " + id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.iMMDeviceEnumerator != 0L) {
                WASAPI.IMMDeviceEnumerator_Release(this.iMMDeviceEnumerator);
                this.iMMDeviceEnumerator = 0L;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public static AudioFormat[] getFormatsToInitializeIAudioClient(AudioFormat format) {
        int channels;
        switch (format.getChannels()) {
            case 1: {
                channels = 2;
                break;
            }
            case 2: {
                channels = 1;
                break;
            }
            default: {
                return new AudioFormat[]{format};
            }
        }
        return new AudioFormat[]{format, new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), channels, 0, 1, -1, -1.0, format.getDataType())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AudioFormat> getIAudioClientSupportedFormats(long iAudioClient) throws HResultException {
        char cbSize = '\u0000';
        ArrayList<AudioFormat> supportedFormats = new ArrayList<AudioFormat>();
        char nChannels = '\u0001';
        while (nChannels <= '\u0002') {
            for (int i = 0; i < Constants.AUDIO_SAMPLE_RATES.length; ++i) {
                int nSamplesPerSec = (int)Constants.AUDIO_SAMPLE_RATES[i];
                for (char wBitsPerSample = '\u0010'; wBitsPerSample > '\u0000'; wBitsPerSample = (char)(wBitsPerSample - 8)) {
                    Object var14_11;
                    long pClosestMatch;
                    block11: {
                        block10: {
                            char nBlockAlign = (char)(nChannels * wBitsPerSample / 8);
                            WASAPI.WAVEFORMATEX_fill(this.waveformatex, '\u0001', nChannels, nSamplesPerSec, nSamplesPerSec * nBlockAlign, nBlockAlign, wBitsPerSample, cbSize);
                            pClosestMatch = WASAPI.IAudioClient_IsFormatSupported(iAudioClient, 0, this.waveformatex);
                            if (pClosestMatch == 0L) continue;
                            try {
                                AudioFormat supportedFormat;
                                if (pClosestMatch != this.waveformatex) {
                                    if (WASAPI.WAVEFORMATEX_getWFormatTag(pClosestMatch) != '\u0001') {
                                        var14_11 = null;
                                        if (pClosestMatch == this.waveformatex) continue;
                                        break block10;
                                    }
                                    nChannels = WASAPI.WAVEFORMATEX_getNChannels(pClosestMatch);
                                    nSamplesPerSec = WASAPI.WAVEFORMATEX_getNSamplesPerSec(pClosestMatch);
                                    wBitsPerSample = WASAPI.WAVEFORMATEX_getWBitsPerSample(pClosestMatch);
                                }
                                if (nChannels == '\u0002' && !supportedFormats.contains(supportedFormat = new AudioFormat("LINEAR", (double)nSamplesPerSec, (int)wBitsPerSample, 1, 0, 1, -1, -1.0, Format.byteArray))) {
                                    supportedFormats.add(supportedFormat);
                                }
                                if (supportedFormats.contains(supportedFormat = new AudioFormat("LINEAR", (double)nSamplesPerSec, (int)wBitsPerSample, (int)nChannels, 0, 1, -1, -1.0, Format.byteArray))) break block11;
                                supportedFormats.add(supportedFormat);
                                break block11;
                            }
                            catch (Throwable throwable) {
                                var14_11 = null;
                                if (pClosestMatch != this.waveformatex) {
                                    WASAPI.CoTaskMemFree(pClosestMatch);
                                }
                                throw throwable;
                            }
                        }
                        WASAPI.CoTaskMemFree(pClosestMatch);
                        continue;
                    }
                    var14_11 = null;
                    if (pClosestMatch == this.waveformatex) continue;
                    WASAPI.CoTaskMemFree(pClosestMatch);
                }
            }
            nChannels = (char)(nChannels + 1);
        }
        return supportedFormats;
    }

    public long getIMMDevice(String id) throws HResultException {
        long iMMDeviceEnumerator = this.iMMDeviceEnumerator;
        if (iMMDeviceEnumerator == 0L) {
            throw new IllegalStateException("iMMDeviceEnumerator");
        }
        return WASAPI.IMMDeviceEnumerator_GetDevice(iMMDeviceEnumerator, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIMMDeviceDataFlow(long iMMDevice) throws HResultException {
        int dataFlow;
        long iMMEndpoint = WASAPI.IMMDevice_QueryInterface(iMMDevice, "{1be09788-6894-4089-8586-9a2a6c265ac5}");
        if (iMMEndpoint == 0L) {
            throw new RuntimeException("IMMDevice_QueryInterface");
        }
        try {
            dataFlow = WASAPI.IMMEndpoint_GetDataFlow(iMMEndpoint);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            WASAPI.IMMEndpoint_Release(iMMEndpoint);
            throw throwable;
        }
        WASAPI.IMMEndpoint_Release(iMMEndpoint);
        switch (dataFlow) {
            case 0: 
            case 1: 
            case 2: {
                return dataFlow;
            }
        }
        throw new RuntimeException("IMMEndpoint_GetDataFlow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIMMDeviceFriendlyName(long iMMDevice) throws HResultException {
        String deviceFriendlyName;
        long iPropertyStore = WASAPI.IMMDevice_OpenPropertyStore(iMMDevice, 0);
        if (iPropertyStore == 0L) {
            throw new RuntimeException("IMMDevice_OpenPropertyStore");
        }
        try {
            deviceFriendlyName = WASAPI.IPropertyStore_GetString(iPropertyStore, WASAPI.PKEY_Device_FriendlyName);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            WASAPI.IPropertyStore_Release(iPropertyStore);
            throw throwable;
        }
        WASAPI.IPropertyStore_Release(iPropertyStore);
        return deviceFriendlyName;
    }

    @Override
    protected String getRendererClassName() {
        return WASAPIRenderer.class.getName();
    }

    public static int getSampleSizeInBytes(AudioFormat format) {
        int sampleSizeInBits = format.getSampleSizeInBits();
        switch (sampleSizeInBits) {
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
        }
        return sampleSizeInBits / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long initializeIAudioClient(MediaLocator locator, AudioSystem.DataFlow dataFlow, long eventHandle, long hnsBufferDuration, AudioFormat[] formats) throws HResultException {
        String id = locator.getRemainder();
        long iMMDevice = this.getIMMDevice(id);
        if (iMMDevice == 0L) {
            throw new RuntimeException("Failed to retrieve audio endpoint device with endpoint ID string " + id);
        }
        long ret = 0L;
        try {
            block24: {
                int iMMDeviceDataFlow = this.getIMMDeviceDataFlow(iMMDevice);
                switch (dataFlow) {
                    case CAPTURE: {
                        if (iMMDeviceDataFlow == 2 || iMMDeviceDataFlow == 1) break;
                        throw new IllegalArgumentException("dataFlow");
                    }
                    case NOTIFY: 
                    case PLAYBACK: {
                        if (iMMDeviceDataFlow == 2 || iMMDeviceDataFlow == 0) break;
                        throw new IllegalArgumentException("dataFlow");
                    }
                }
                long iAudioClient = WASAPI.IMMDevice_Activate(iMMDevice, "{1cb9ad4c-dbfa-4c32-b178-c2f568a703b2}", 23, 0L);
                if (iAudioClient == 0L) {
                    throw new RuntimeException("IMMDevice_Activate");
                }
                try {
                    long waveformatex = WASAPI.WAVEFORMATEX_alloc();
                    if (waveformatex == 0L) {
                        throw new OutOfMemoryError("WAVEFORMATEX_alloc");
                    }
                    try {
                        int hresult;
                        int shareMode = 0;
                        boolean waveformatexIsInitialized = false;
                        for (int i = 0; i < formats.length; ++i) {
                            Object var24_17;
                            long pClosestMatch;
                            block23: {
                                block22: {
                                    WASAPISystem.WAVEFORMATEX_fill(waveformatex, formats[i]);
                                    pClosestMatch = WASAPI.IAudioClient_IsFormatSupported(iAudioClient, shareMode, waveformatex);
                                    if (pClosestMatch == 0L) {
                                        formats[i] = null;
                                        continue;
                                    }
                                    try {
                                        if (pClosestMatch == waveformatex) {
                                            waveformatexIsInitialized = true;
                                            var24_17 = null;
                                            if (pClosestMatch == waveformatex) break;
                                            break block22;
                                        }
                                        formats[i] = null;
                                        break block23;
                                    }
                                    catch (Throwable throwable) {
                                        var24_17 = null;
                                        if (pClosestMatch == waveformatex) throw throwable;
                                        WASAPI.CoTaskMemFree(pClosestMatch);
                                        throw throwable;
                                    }
                                }
                                WASAPI.CoTaskMemFree(pClosestMatch);
                                break;
                            }
                            var24_17 = null;
                            if (pClosestMatch == waveformatex) continue;
                            WASAPI.CoTaskMemFree(pClosestMatch);
                        }
                        if (!waveformatexIsInitialized) {
                            throw new IllegalArgumentException("formats");
                        }
                        int streamFlags = 524288;
                        if (eventHandle != 0L) {
                            eventHandle |= 0x40000L;
                        }
                        if ((hresult = WASAPI.IAudioClient_Initialize(iAudioClient, shareMode, streamFlags, hnsBufferDuration, 0L, waveformatex, audioSessionGuid)) != 0) {
                            throw new HResultException(hresult);
                        }
                        if ((streamFlags & 0x40000) == 262144 && eventHandle != 0L) {
                            WASAPI.IAudioClient_SetEventHandle(iAudioClient, eventHandle);
                        }
                        ret = iAudioClient;
                        iAudioClient = 0L;
                        Object var26_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var26_20 = null;
                        WASAPI.CoTaskMemFree(waveformatex);
                        throw throwable;
                    }
                    WASAPI.CoTaskMemFree(waveformatex);
                    Object var28_22 = null;
                    if (iAudioClient == 0L) break block24;
                }
                catch (Throwable throwable) {
                    Object var28_23 = null;
                    if (iAudioClient == 0L) throw throwable;
                    WASAPI.IAudioClient_Release(iAudioClient);
                    throw throwable;
                }
                WASAPI.IAudioClient_Release(iAudioClient);
            }
            Object var30_25 = null;
            if (iMMDevice == 0L) return ret;
        }
        catch (Throwable throwable) {
            Object var30_26 = null;
            if (iMMDevice == 0L) throw throwable;
            WASAPI.IMMDevice_Release(iMMDevice);
            throw throwable;
        }
        WASAPI.IMMDevice_Release(iMMDevice);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void postInitialize() {
        try {
            super.postInitialize();
            Object var2_1 = null;
            if (this.waveformatex == 0L) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.waveformatex == 0L) throw throwable;
            WASAPI.CoTaskMemFree(this.waveformatex);
            this.waveformatex = 0L;
            throw throwable;
        }
        WASAPI.CoTaskMemFree(this.waveformatex);
        this.waveformatex = 0L;
    }

    @Override
    protected void preInitialize() {
        super.preInitialize();
        if (this.waveformatex != 0L) {
            WASAPI.CoTaskMemFree(this.waveformatex);
            this.waveformatex = 0L;
        }
        this.waveformatex = WASAPI.WAVEFORMATEX_alloc();
        if (this.waveformatex == 0L) {
            throw new OutOfMemoryError("WAVEFORMATEX_alloc");
        }
        if (this.pNotify == null) {
            this.pNotify = new IMMNotificationClient(){

                public void OnDefaultDeviceChanged(int flow, int role, String pwstrDefaultDevice) {
                }

                public void OnDeviceAdded(String pwstrDeviceId) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                public void OnDeviceRemoved(String pwstrDeviceId) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                public void OnDeviceStateChanged(String pwstrDeviceId, int dwNewState) {
                    WASAPISystem.this.reinitialize(pwstrDeviceId);
                }

                public void OnPropertyValueChanged(String pwstrDeviceId, long key) {
                }
            };
        }
        if (audioSessionGuid == null) {
            try {
                audioSessionGuid = WASAPI.CoCreateGuid();
            }
            catch (HResultException hre) {
                logger.warn("Failed to generate a new audio session GUID", hre);
            }
        }
    }

    private void reinitialize(String deviceId) {
        try {
            WASAPISystem.invokeDeviceSystemInitialize(this, true);
        }
        catch (Exception e) {
            logger.error("Failed to reinitialize " + this.getClass().getName(), e);
        }
    }

    @Override
    public String toString() {
        return "Windows Audio Session API (WASAPI)";
    }

    public static void WAVEFORMATEX_fill(long waveformatex, AudioFormat audioFormat) {
        if (!"LINEAR".equals(audioFormat.getEncoding())) {
            throw new IllegalArgumentException("audioFormat.encoding");
        }
        int channels = audioFormat.getChannels();
        if (channels == -1) {
            throw new IllegalArgumentException("audioFormat.channels");
        }
        int sampleRate = (int)audioFormat.getSampleRate();
        if (sampleRate == -1) {
            throw new IllegalArgumentException("audioFormat.sampleRate");
        }
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        if (sampleSizeInBits == -1) {
            throw new IllegalArgumentException("audioFormat.sampleSizeInBits");
        }
        char nBlockAlign = (char)(channels * sampleSizeInBits / 8);
        WASAPI.WAVEFORMATEX_fill(waveformatex, '\u0001', (char)channels, sampleRate, sampleRate * nBlockAlign, nBlockAlign, (char)sampleSizeInBits, '\u0000');
    }

    static {
        logger = Logger.getLogger(WASAPISystem.class);
    }
}

