/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import org.jitsi.service.neomedia.device.ScreenDevice;

public class ScreenDeviceImpl
implements ScreenDevice {
    private static final ScreenDevice[] EMPTY_SCREEN_DEVICE_ARRAY = new ScreenDevice[0];
    final GraphicsDevice screen;
    private final int index;

    public static ScreenDevice[] getAvailableScreenDevices() {
        GraphicsDevice[] devices;
        GraphicsEnvironment ge;
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (NoClassDefFoundError ncdfe) {
            ge = null;
        }
        ScreenDevice[] screens = null;
        if (ge != null && !ge.isHeadlessInstance() && (devices = ge.getScreenDevices()) != null && devices.length != 0) {
            screens = new ScreenDevice[devices.length];
            int i = 0;
            for (GraphicsDevice dev : devices) {
                screens[i] = new ScreenDeviceImpl(i, dev);
                ++i;
            }
        }
        return screens == null ? EMPTY_SCREEN_DEVICE_ARRAY : screens;
    }

    public static ScreenDevice getDefaultScreenDevice() {
        ScreenDevice[] screens = ScreenDeviceImpl.getAvailableScreenDevices();
        int width = 0;
        int height = 0;
        ScreenDevice best = null;
        for (ScreenDevice screen : screens) {
            Dimension res = screen.getSize();
            if (res == null || width >= res.width && height >= res.height) continue;
            width = res.width;
            height = res.height;
            best = screen;
        }
        return best;
    }

    protected ScreenDeviceImpl(int index, GraphicsDevice screen) {
        this.index = index;
        this.screen = screen;
    }

    public int getIndex() {
        return this.index;
    }

    public Dimension getSize() {
        DisplayMode mode = this.screen.getDisplayMode();
        return mode == null ? null : new Dimension(mode.getWidth(), mode.getHeight());
    }

    public String getName() {
        return this.screen.getIDstring();
    }

    public boolean containsPoint(Point p) {
        return this.screen.getDefaultConfiguration().getBounds().contains(p);
    }

    public Rectangle getBounds() {
        return this.screen.getDefaultConfiguration().getBounds();
    }
}

