/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.CoreAudioDevice;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.control.DiagnosticsControl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.PortAudioRenderer;
import org.jitsi.impl.neomedia.portaudio.Pa;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortAudioSystem
extends AudioSystem {
    private static final String LOCATOR_PROTOCOL = "portaudio";
    private static final Logger logger = Logger.getLogger(PortAudioSystem.class);
    private static int paOpenStream = 0;
    private static final Object paOpenStreamSyncRoot = new Object();
    private static int paUpdateAvailableDeviceList = 0;
    private static final List<WeakReference<PaUpdateAvailableDeviceListListener>> paUpdateAvailableDeviceListListeners = new LinkedList<WeakReference<PaUpdateAvailableDeviceListListener>>();
    private static final Object paUpdateAvailableDeviceListSyncRoot = new Object();
    private Runnable devicesChangedCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPaUpdateAvailableDeviceListListener(PaUpdateAvailableDeviceListListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<WeakReference<PaUpdateAvailableDeviceListListener>> list = paUpdateAvailableDeviceListListeners;
        synchronized (list) {
            Iterator<WeakReference<PaUpdateAvailableDeviceListListener>> i = paUpdateAvailableDeviceListListeners.iterator();
            boolean add = true;
            while (i.hasNext()) {
                PaUpdateAvailableDeviceListListener l = (PaUpdateAvailableDeviceListListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                add = false;
            }
            if (add) {
                paUpdateAvailableDeviceListListeners.add(new WeakReference<PaUpdateAvailableDeviceListListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void didPaOpenStream() {
        Object object = paOpenStreamSyncRoot;
        synchronized (object) {
            if (--paOpenStream < 0) {
                paOpenStream = 0;
            }
            paOpenStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void didPaUpdateAvailableDeviceList() {
        Object object = paOpenStreamSyncRoot;
        synchronized (object) {
            if (--paUpdateAvailableDeviceList < 0) {
                paUpdateAvailableDeviceList = 0;
            }
            paOpenStreamSyncRoot.notifyAll();
        }
        PortAudioSystem.firePaUpdateAvailableDeviceListEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePaUpdateAvailableDeviceListEvent(boolean will) {
        block10: {
            try {
                ArrayList<WeakReference<PaUpdateAvailableDeviceListListener>> ls;
                List<WeakReference<PaUpdateAvailableDeviceListListener>> list = paUpdateAvailableDeviceListListeners;
                synchronized (list) {
                    ls = new ArrayList<WeakReference<PaUpdateAvailableDeviceListListener>>(paUpdateAvailableDeviceListListeners);
                }
                for (WeakReference weakReference : ls) {
                    PaUpdateAvailableDeviceListListener l = (PaUpdateAvailableDeviceListListener)weakReference.get();
                    if (l == null) continue;
                    try {
                        if (will) {
                            l.willPaUpdateAvailableDeviceList();
                            continue;
                        }
                        l.didPaUpdateAvailableDeviceList();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("PaUpdateAvailableDeviceListListener." + (will ? "will" : "did") + "PaUpdateAvailableDeviceList failed.", t);
                    }
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block10;
                throw (ThreadDeath)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double getSupportedSampleRate(boolean input, int deviceIndex, int channelCount, long sampleFormat) {
        double supportedSampleRate;
        long deviceInfo = Pa.GetDeviceInfo(deviceIndex);
        if (deviceInfo == 0L) return 44100.0;
        double defaultSampleRate = Pa.DeviceInfo_getDefaultSampleRate(deviceInfo);
        if (defaultSampleRate >= MediaUtils.MAX_AUDIO_SAMPLE_RATE) {
            return defaultSampleRate;
        }
        long streamParameters = Pa.StreamParameters_new(deviceIndex, channelCount, sampleFormat, 0.0);
        if (streamParameters == 0L) {
            return defaultSampleRate;
        }
        try {
            long outputParameters;
            long inputParameters;
            if (input) {
                inputParameters = streamParameters;
                outputParameters = 0L;
            } else {
                inputParameters = 0L;
                outputParameters = streamParameters;
            }
            boolean formatIsSupported = Pa.IsFormatSupported(inputParameters, outputParameters, 44100.0);
            supportedSampleRate = formatIsSupported ? 44100.0 : defaultSampleRate;
            Object var19_11 = null;
        }
        catch (Throwable throwable) {
            Object var19_12 = null;
            Pa.StreamParameters_free(streamParameters);
            throw throwable;
        }
        Pa.StreamParameters_free(streamParameters);
        return supportedSampleRate;
    }

    public static void monitorFunctionalHealth(DiagnosticsControl diagnosticsControl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePaUpdateAvailableDeviceListListener(PaUpdateAvailableDeviceListListener listener) {
        if (listener == null) {
            return;
        }
        List<WeakReference<PaUpdateAvailableDeviceListListener>> list = paUpdateAvailableDeviceListListeners;
        synchronized (list) {
            Iterator<WeakReference<PaUpdateAvailableDeviceListListener>> i = paUpdateAvailableDeviceListListeners.iterator();
            while (i.hasNext()) {
                PaUpdateAvailableDeviceListListener l = (PaUpdateAvailableDeviceListListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    private static void waitForPaOpenStream() {
        boolean interrupted = false;
        while (paOpenStream > 0) {
            try {
                paOpenStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static void waitForPaUpdateAvailableDeviceList() {
        boolean interrupted = false;
        while (paUpdateAvailableDeviceList > 0) {
            try {
                paOpenStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void willPaOpenStream() {
        Object object = paOpenStreamSyncRoot;
        synchronized (object) {
            PortAudioSystem.waitForPaUpdateAvailableDeviceList();
            ++paOpenStream;
            paOpenStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void willPaUpdateAvailableDeviceList() {
        Object object = paOpenStreamSyncRoot;
        synchronized (object) {
            PortAudioSystem.waitForPaOpenStream();
            ++paUpdateAvailableDeviceList;
            paOpenStreamSyncRoot.notifyAll();
        }
        PortAudioSystem.firePaUpdateAvailableDeviceListEvent(true);
    }

    PortAudioSystem() throws Exception {
        super(LOCATOR_PROTOCOL, 15);
    }

    private void bubbleUpUsbDevices(List<CaptureDeviceInfo2> devices) {
        if (!devices.isEmpty()) {
            ArrayList<CaptureDeviceInfo2> nonUsbDevices = new ArrayList<CaptureDeviceInfo2>(devices.size());
            Iterator<CaptureDeviceInfo2> i = devices.iterator();
            while (i.hasNext()) {
                CaptureDeviceInfo2 d = i.next();
                if (d.isSameTransportType("USB")) continue;
                nonUsbDevices.add(d);
                i.remove();
            }
            if (!nonUsbDevices.isEmpty()) {
                for (CaptureDeviceInfo2 d : nonUsbDevices) {
                    devices.add(d);
                }
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        int deviceCount = Pa.GetDeviceCount();
        int channels = 1;
        int sampleSizeInBits = 16;
        long sampleFormat = Pa.getPaSampleFormat(sampleSizeInBits);
        int defaultInputDeviceIndex = Pa.GetDefaultInputDevice();
        int defaultOutputDeviceIndex = Pa.GetDefaultOutputDevice();
        LinkedList<CaptureDeviceInfo2> captureAndPlaybackDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> captureDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevices = new LinkedList<CaptureDeviceInfo2>();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        if (CoreAudioDevice.isLoaded) {
            CoreAudioDevice.initDevices();
        }
        for (int deviceIndex = 0; deviceIndex < deviceCount; ++deviceIndex) {
            long deviceInfo = Pa.GetDeviceInfo(deviceIndex);
            String name = Pa.DeviceInfo_getName(deviceInfo);
            if (name != null) {
                name = name.trim();
            }
            int maxInputChannels = Pa.DeviceInfo_getMaxInputChannels(deviceInfo);
            int maxOutputChannels = Pa.DeviceInfo_getMaxOutputChannels(deviceInfo);
            String transportType = Pa.DeviceInfo_getTransportType(deviceInfo);
            String deviceUID = Pa.DeviceInfo_getDeviceUID(deviceInfo);
            String modelIdentifier = null;
            if (CoreAudioDevice.isLoaded) {
                modelIdentifier = CoreAudioDevice.getDeviceModelIdentifier(deviceUID);
            }
            String deviceLocatorID = deviceUID != null ? deviceUID : name;
            List<CaptureDeviceInfo2> existingCdis = this.getDevices(AudioSystem.DataFlow.CAPTURE);
            CaptureDeviceInfo2 cdi = null;
            if (existingCdis != null) {
                for (CaptureDeviceInfo2 existingCdi : existingCdis) {
                    String id = existingCdi.getIdentifier();
                    if (!id.equals(deviceUID) && !id.equals(name)) continue;
                    cdi = existingCdi;
                    break;
                }
            }
            if (cdi == null) {
                cdi = new CaptureDeviceInfo2(name, new MediaLocator("portaudio:#" + deviceLocatorID), new Format[]{new AudioFormat("LINEAR", maxInputChannels > 0 ? PortAudioSystem.getSupportedSampleRate(true, deviceIndex, channels, sampleFormat) : 44100.0, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray)}, deviceUID, transportType, modelIdentifier);
            }
            if (maxInputChannels > 0) {
                LinkedList<CaptureDeviceInfo2> devices = maxOutputChannels > 0 ? captureAndPlaybackDevices : captureDevices;
                if (deviceIndex == defaultInputDeviceIndex || maxOutputChannels > 0 && deviceIndex == defaultOutputDeviceIndex) {
                    devices.add(0, cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added default capture device: " + name);
                    }
                } else {
                    devices.add(cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added capture device: " + name);
                    }
                }
                if (!loggerIsDebugEnabled || maxInputChannels <= 0) continue;
                if (deviceIndex == defaultOutputDeviceIndex) {
                    logger.debug("Added default playback device: " + name);
                    continue;
                }
                logger.debug("Added playback device: " + name);
                continue;
            }
            if (maxOutputChannels <= 0) continue;
            if (deviceIndex == defaultOutputDeviceIndex) {
                playbackDevices.add(0, cdi);
                if (!loggerIsDebugEnabled) continue;
                logger.debug("Added default playback device: " + name);
                continue;
            }
            playbackDevices.add(cdi);
            if (!loggerIsDebugEnabled) continue;
            logger.debug("Added playback device: " + name);
        }
        if (CoreAudioDevice.isLoaded) {
            CoreAudioDevice.freeDevices();
        }
        this.bubbleUpUsbDevices(captureDevices);
        this.bubbleUpUsbDevices(playbackDevices);
        if (!captureDevices.isEmpty() && !playbackDevices.isEmpty()) {
            this.matchDevicesByName(captureDevices, playbackDevices);
        }
        if (!captureAndPlaybackDevices.isEmpty()) {
            this.bubbleUpUsbDevices(captureAndPlaybackDevices);
            for (int i = captureAndPlaybackDevices.size() - 1; i >= 0; --i) {
                CaptureDeviceInfo2 cdi = (CaptureDeviceInfo2)((Object)captureAndPlaybackDevices.get(i));
                captureDevices.add(0, cdi);
                playbackDevices.add(0, cdi);
            }
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
        if (this.devicesChangedCallback == null) {
            this.devicesChangedCallback = new Runnable(){

                public void run() {
                    try {
                        PortAudioSystem.this.reinitialize();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("Failed to reinitialize PortAudio devices", t);
                    }
                }
            };
            Pa.setDevicesChangedCallback(this.devicesChangedCallback);
        }
    }

    @Override
    protected String getRendererClassName() {
        return PortAudioRenderer.class.getName();
    }

    private void matchDevicesByName(List<CaptureDeviceInfo2> captureDevices, List<CaptureDeviceInfo2> playbackDevices) {
        Iterator<CaptureDeviceInfo2> captureIter = captureDevices.iterator();
        Pattern pattern = Pattern.compile("array|headphones|microphone|speakers|\\p{Space}|\\(|\\)", 2);
        LinkedList<CaptureDeviceInfo2> captureDevicesWithPlayback = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevicesWithCapture = new LinkedList<CaptureDeviceInfo2>();
        int count = 0;
        while (captureIter.hasNext()) {
            CaptureDeviceInfo2 captureDevice = captureIter.next();
            String captureName = captureDevice.getName();
            if (captureName == null || (captureName = pattern.matcher(captureName).replaceAll("")).length() == 0) continue;
            Iterator<CaptureDeviceInfo2> playbackIter = playbackDevices.iterator();
            CaptureDeviceInfo2 matchingPlaybackDevice = null;
            while (playbackIter.hasNext()) {
                CaptureDeviceInfo2 playbackDevice = playbackIter.next();
                String playbackName = playbackDevice.getName();
                if (playbackName == null || !captureName.equals(playbackName = pattern.matcher(playbackName).replaceAll(""))) continue;
                playbackIter.remove();
                matchingPlaybackDevice = playbackDevice;
                break;
            }
            if (matchingPlaybackDevice == null) continue;
            captureIter.remove();
            captureDevicesWithPlayback.add(captureDevice);
            playbackDevicesWithCapture.add(matchingPlaybackDevice);
            ++count;
        }
        for (int i = count - 1; i >= 0; --i) {
            captureDevices.add(0, (CaptureDeviceInfo2)((Object)captureDevicesWithPlayback.get(i)));
            playbackDevices.add(0, (CaptureDeviceInfo2)((Object)playbackDevicesWithCapture.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialize() throws Exception {
        Object object = paUpdateAvailableDeviceListSyncRoot;
        synchronized (object) {
            PortAudioSystem.willPaUpdateAvailableDeviceList();
            try {
                Pa.UpdateAvailableDeviceList();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                PortAudioSystem.didPaUpdateAvailableDeviceList();
                throw throwable;
            }
            PortAudioSystem.didPaUpdateAvailableDeviceList();
        }
        PortAudioSystem.invokeDeviceSystemInitialize(this);
    }

    @Override
    public String toString() {
        return "PortAudio";
    }

    public static interface PaUpdateAvailableDeviceListListener
    extends EventListener {
        public void didPaUpdateAvailableDeviceList() throws Exception;

        public void willPaUpdateAvailableDeviceList() throws Exception;
    }
}

