/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.MediaLocator;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Devices {
    private static final String PROP_DISABLE_USB_DEVICE_AUTO_SELECTION = "org.jitsi.impl.neomedia.device.disableUsbDeviceAutoSelection";
    private final AudioSystem audioSystem;
    private CaptureDeviceInfo2 device;
    private final List<String> devicePreferences = new ArrayList<String>();
    private List<CaptureDeviceInfo2> devices;

    public Devices(AudioSystem audioSystem) {
        this.audioSystem = audioSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDevicePreferences(String newDeviceIdentifier, boolean isSelected) {
        List<String> list = this.devicePreferences;
        synchronized (list) {
            this.devicePreferences.remove(newDeviceIdentifier);
            if (isSelected) {
                this.devicePreferences.add(0, newDeviceIdentifier);
            } else {
                this.devicePreferences.add(newDeviceIdentifier);
            }
        }
    }

    public CaptureDeviceInfo2 getDevice(MediaLocator locator) {
        CaptureDeviceInfo2 device = null;
        if (this.devices != null) {
            for (CaptureDeviceInfo2 aDevice : this.devices) {
                MediaLocator aLocator = aDevice.getLocator();
                if (!locator.equals((Object)aLocator)) continue;
                device = aDevice;
                break;
            }
        }
        return device;
    }

    public List<CaptureDeviceInfo2> getDevices() {
        List<CaptureDeviceInfo2> devices = this.devices == null ? Collections.emptyList() : new ArrayList<CaptureDeviceInfo2>(this.devices);
        return devices;
    }

    protected abstract String getPropDevice();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureDeviceInfo2 getSelectedDevice(String locator, List<CaptureDeviceInfo2> activeDevices) {
        if (activeDevices != null) {
            String property = this.getPropDevice();
            this.loadDevicePreferences(locator, property);
            this.renameOldFashionedIdentifier(activeDevices);
            for (int i = activeDevices.size() - 1; i >= 0; --i) {
                CaptureDeviceInfo2 activeDevice = activeDevices.get(i);
                if (this.devicePreferences.contains(activeDevice.getModelIdentifier())) continue;
                boolean isSelected = activeDevice.isSameTransportType("USB");
                ConfigurationService cfg = LibJitsi.getConfigurationService();
                if (cfg != null && cfg.getBoolean(PROP_DISABLE_USB_DEVICE_AUTO_SELECTION, false)) {
                    isSelected = false;
                }
                this.saveDevice(locator, property, activeDevice, isSelected);
            }
            List<String> list = this.devicePreferences;
            synchronized (list) {
                for (String devicePreference : this.devicePreferences) {
                    for (CaptureDeviceInfo2 activeDevice : activeDevices) {
                        if (devicePreference.equals(activeDevice.getModelIdentifier())) {
                            return activeDevice;
                        }
                        if (!devicePreference.equals("none")) continue;
                        return null;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDevicePreferences(String locator, String property) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            String new_property = "net.java.sip.communicator.impl.neomedia.audioSystem." + locator + "." + property + "_list";
            String deviceIdentifiersString = cfg.getString(new_property);
            List<String> list = this.devicePreferences;
            synchronized (list) {
                if (deviceIdentifiersString != null) {
                    this.devicePreferences.clear();
                    String[] deviceIdentifiers = deviceIdentifiersString.substring(2, deviceIdentifiersString.length() - 2).split("\", \"");
                    for (int i = 0; i < deviceIdentifiers.length; ++i) {
                        this.devicePreferences.add(deviceIdentifiers[i]);
                    }
                } else {
                    String old_property = "net.java.sip.communicator.impl.neomedia.audioSystem." + locator + "." + property;
                    deviceIdentifiersString = cfg.getString(old_property);
                    if (deviceIdentifiersString != null && !"none".equalsIgnoreCase(deviceIdentifiersString)) {
                        this.devicePreferences.clear();
                        this.devicePreferences.add(deviceIdentifiersString);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameOldFashionedIdentifier(List<CaptureDeviceInfo2> activeDevices) {
        for (CaptureDeviceInfo2 activeDevice : activeDevices) {
            String id;
            String name = activeDevice.getName();
            if (name.equals(id = activeDevice.getModelIdentifier())) continue;
            List<String> list = this.devicePreferences;
            synchronized (list) {
                int nameIndex;
                while ((nameIndex = this.devicePreferences.indexOf(name)) != -1) {
                    int idIndex = this.devicePreferences.indexOf(id);
                    if (idIndex == -1) {
                        this.devicePreferences.set(nameIndex, id);
                        continue;
                    }
                    this.devicePreferences.remove(nameIndex);
                }
            }
        }
    }

    private void saveDevice(String locator, String property, CaptureDeviceInfo2 device, boolean isSelected) {
        String selectedDeviceIdentifier = device == null ? "none" : device.getModelIdentifier();
        this.addToDevicePreferences(selectedDeviceIdentifier, isSelected);
        this.writeDevicePreferences(locator, property);
    }

    public void setDevice(String locator, CaptureDeviceInfo2 device, boolean save) {
        if (device == null || !device.equals((Object)this.device)) {
            CaptureDeviceInfo2 oldValue = this.device;
            if (save) {
                this.saveDevice(locator, this.getPropDevice(), device, true);
            }
            this.device = device;
            this.audioSystem.propertyChange(this.getPropDevice(), (Object)oldValue, (Object)this.device);
        }
    }

    public void setDevices(List<CaptureDeviceInfo2> devices) {
        this.devices = devices == null ? null : new ArrayList<CaptureDeviceInfo2>(devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDevicePreferences(String locator, String property) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            property = "net.java.sip.communicator.impl.neomedia.audioSystem." + locator + "." + property + "_list";
            StringBuilder value = new StringBuilder("[\"");
            List<String> list = this.devicePreferences;
            synchronized (list) {
                int devicePreferenceCount = this.devicePreferences.size();
                if (devicePreferenceCount != 0) {
                    value.append(this.devicePreferences.get(0));
                    for (int i = 1; i < devicePreferenceCount; ++i) {
                        value.append("\", \"").append(this.devicePreferences.get(i));
                    }
                }
            }
            value.append("\"]");
            cfg.setProperty(property, value.toString());
        }
    }
}

