/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.control;

import javax.media.Controls;
import org.jitsi.util.Logger;

public abstract class AbstractControls
implements Controls {
    private static final Logger logger = Logger.getLogger(AbstractControls.class);

    public Object getControl(String controlType) {
        return AbstractControls.getControl(this, controlType);
    }

    public static Object getControl(Controls controlsImpl, String controlType) {
        Object[] controls = controlsImpl.getControls();
        if (controls != null && controls.length > 0) {
            Class<?> controlClass;
            try {
                controlClass = Class.forName(controlType);
            }
            catch (ClassNotFoundException cnfe) {
                controlClass = null;
                logger.warn("Failed to find control class " + controlType, cnfe);
            }
            if (controlClass != null) {
                for (Object control : controls) {
                    if (!controlClass.isInstance(control)) continue;
                    return control;
                }
            }
        }
        return null;
    }
}

