/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.event.RTCPFeedbackEvent;
import org.jitsi.service.neomedia.event.RTCPFeedbackListener;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNIEncoder
extends AbstractCodec
implements RTCPFeedbackListener {
    public static final String[] AVAILABLE_PRESETS = new String[]{"ultrafast", "superfast", "veryfast", "faster", "fast", "medium", "slow", "slower", "veryslow"};
    public static final String BASELINE_PROFILE = "baseline";
    static final int DEFAULT_FRAME_RATE = 15;
    public static final String DEFAULT_PRESET = AVAILABLE_PRESETS[0];
    public static final String DEFAULT_PROFILE_PNAME = "net.java.sip.communicator.impl.neomedia.codec.video.h264.defaultProfile";
    static final int IFRAME_INTERVAL = 150;
    private static final Logger logger = Logger.getLogger(JNIEncoder.class);
    public static final String MAIN_PROFILE = "main";
    public static final String HIGH_PROFILE = "high";
    public static final String DEFAULT_DEFAULT_PROFILE = "main";
    public static final String PACKETIZATION_MODE_FMTP = "packetization-mode";
    private static final long PLI_INTERVAL = 3000L;
    private static final String PLUGIN_NAME = "H.264 Encoder";
    public static final String PRESET_PNAME = "org.jitsi.impl.neomedia.codec.video.h264.preset";
    static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new ParameterizedVideoFormat("h264", "packetization-mode", "0"), new ParameterizedVideoFormat("h264", "packetization-mode", "1")};
    private Map<String, String> additionalSettings = null;
    private long avctx;
    private long avFrame;
    private boolean forceKeyFrame = true;
    private int framesSinceLastIFrame = 151;
    private KeyFrameControl keyFrameControl;
    private KeyFrameControl.KeyFrameRequestee keyFrameRequestee;
    private long lastKeyFrameRequestTime = System.currentTimeMillis();
    private String packetizationMode;
    private long rawFrameBuffer;
    private int rawFrameLen;
    private boolean secondKeyFrame = true;

    public JNIEncoder() {
        this.inputFormats = new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            if (this.avctx != 0L) {
                FFmpeg.avcodec_close(this.avctx);
                FFmpeg.av_free(this.avctx);
                this.avctx = 0L;
            }
            if (this.avFrame != 0L) {
                FFmpeg.avcodec_free_frame(this.avFrame);
                this.avFrame = 0L;
            }
            if (this.rawFrameBuffer != 0L) {
                FFmpeg.av_free(this.rawFrameBuffer);
                this.rawFrameBuffer = 0L;
            }
            if (this.keyFrameRequestee != null) {
                if (this.keyFrameControl != null) {
                    this.keyFrameControl.removeKeyFrameRequestee(this.keyFrameRequestee);
                }
                this.keyFrameRequestee = null;
            }
        }
    }

    private Format[] getMatchingOutputFormats(Format inputFormat) {
        String[] stringArray;
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        if (this.packetizationMode == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "0";
            stringArray = stringArray2;
            stringArray2[1] = "1";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.packetizationMode;
        }
        String[] packetizationModes = stringArray;
        Format[] matchingOutputFormats = new Format[packetizationModes.length];
        Dimension size = inputVideoFormat.getSize();
        float frameRate = inputVideoFormat.getFrameRate();
        for (int index = packetizationModes.length - 1; index >= 0; --index) {
            matchingOutputFormats[index] = new ParameterizedVideoFormat("h264", size, -1, Format.byteArray, frameRate, ParameterizedVideoFormat.toMap(PACKETIZATION_MODE_FMTP, packetizationModes[index]));
        }
        return matchingOutputFormats;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        Format[] supportedOutputFormats = in == null ? SUPPORTED_OUTPUT_FORMATS : (!(in instanceof VideoFormat) || null == AbstractCodec2.matches(in, this.inputFormats) ? new Format[]{} : this.getMatchingOutputFormats(in));
        return supportedOutputFormats;
    }

    private boolean keyFrameRequest() {
        if (System.currentTimeMillis() > this.lastKeyFrameRequestTime + 3000L) {
            this.lastKeyFrameRequestTime = System.currentTimeMillis();
            this.forceKeyFrame = true;
        }
        return true;
    }

    public synchronized void open() throws ResourceUnavailableException {
        String profile;
        if (this.opened) {
            return;
        }
        VideoFormat inputVideoFormat = (VideoFormat)this.inputFormat;
        VideoFormat outputVideoFormat = (VideoFormat)this.outputFormat;
        Dimension size = null;
        if (inputVideoFormat != null) {
            size = inputVideoFormat.getSize();
        }
        if (size == null && outputVideoFormat != null) {
            size = outputVideoFormat.getSize();
        }
        if (size == null) {
            throw new ResourceUnavailableException("The input video frame width and height are not set.");
        }
        int width = size.width;
        int height = size.height;
        boolean useIntraRefresh = true;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String string = profile = cfg == null ? null : cfg.getString(DEFAULT_PROFILE_PNAME, "main");
        if (this.additionalSettings != null) {
            for (Map.Entry<String, String> e : this.additionalSettings.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if ("h264.intrarefresh".equals(k)) {
                    if (!"false".equals(v)) continue;
                    useIntraRefresh = false;
                    continue;
                }
                if (!"h264.profile".equals(k) || !"main".equals(v) && !BASELINE_PROFILE.equals(v) && !HIGH_PROFILE.equals(v)) continue;
                profile = v;
            }
        }
        long avcodec = FFmpeg.avcodec_find_encoder(28);
        this.avctx = FFmpeg.avcodec_alloc_context3(avcodec);
        FFmpeg.avcodeccontext_set_pix_fmt(this.avctx, 0);
        FFmpeg.avcodeccontext_set_size(this.avctx, width, height);
        FFmpeg.avcodeccontext_set_qcompress(this.avctx, 0.6f);
        int bitRate = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoBitrate() * 1000;
        int frameRate = -1;
        if (outputVideoFormat != null) {
            frameRate = (int)outputVideoFormat.getFrameRate();
        }
        if (frameRate == -1 && inputVideoFormat != null) {
            frameRate = (int)inputVideoFormat.getFrameRate();
        }
        if (frameRate == -1) {
            frameRate = 15;
        }
        FFmpeg.avcodeccontext_set_bit_rate(this.avctx, bitRate);
        FFmpeg.avcodeccontext_set_bit_rate_tolerance(this.avctx, bitRate / frameRate);
        FFmpeg.avcodeccontext_set_rc_max_rate(this.avctx, bitRate);
        FFmpeg.avcodeccontext_set_sample_aspect_ratio(this.avctx, 0, 0);
        FFmpeg.avcodeccontext_set_thread_count(this.avctx, 1);
        FFmpeg.avcodeccontext_set_time_base(this.avctx, 1, frameRate);
        FFmpeg.avcodeccontext_set_ticks_per_frame(this.avctx, 2);
        FFmpeg.avcodeccontext_set_quantizer(this.avctx, 30, 31, 4);
        FFmpeg.avcodeccontext_set_mb_decision(this.avctx, 0);
        FFmpeg.avcodeccontext_set_rc_eq(this.avctx, "blurCplx^(1-qComp)");
        FFmpeg.avcodeccontext_add_flags(this.avctx, 2048);
        if (useIntraRefresh) {
            FFmpeg.avcodeccontext_add_flags2(this.avctx, 0x200000);
        }
        FFmpeg.avcodeccontext_set_me_method(this.avctx, 7);
        FFmpeg.avcodeccontext_set_me_subpel_quality(this.avctx, 2);
        FFmpeg.avcodeccontext_set_me_range(this.avctx, 16);
        FFmpeg.avcodeccontext_set_me_cmp(this.avctx, 256);
        FFmpeg.avcodeccontext_set_scenechange_threshold(this.avctx, 40);
        FFmpeg.avcodeccontext_set_rc_buffer_size(this.avctx, 10);
        FFmpeg.avcodeccontext_set_gop_size(this.avctx, 150);
        FFmpeg.avcodeccontext_set_i_quant_factor(this.avctx, 0.71428573f);
        FFmpeg.avcodeccontext_set_refs(this.avctx, 1);
        FFmpeg.avcodeccontext_set_keyint_min(this.avctx, 0);
        if (null == this.packetizationMode || "0".equals(this.packetizationMode)) {
            FFmpeg.avcodeccontext_set_rtp_payload_size(this.avctx, 1024);
        }
        try {
            FFmpeg.avcodeccontext_set_profile(this.avctx, JNIEncoder.getProfileForConfig(profile));
        }
        catch (UnsatisfiedLinkError ule) {
            logger.warn("The FFmpeg JNI library is out-of-date.");
        }
        String preset = cfg == null ? DEFAULT_PRESET : cfg.getString(PRESET_PNAME, DEFAULT_PRESET);
        if (FFmpeg.avcodec_open2(this.avctx, avcodec, "intra-refresh", useIntraRefresh ? "1" : "0", "partitions", "b8x8,i4x4,p8x8", "preset", preset, "thread_type", "slice", "tune", "zerolatency") < 0) {
            throw new ResourceUnavailableException("Could not open codec. (size= " + width + "x" + height + ")");
        }
        this.rawFrameLen = width * height * 3 / 2;
        this.rawFrameBuffer = FFmpeg.av_malloc(this.rawFrameLen);
        this.avFrame = FFmpeg.avcodec_alloc_frame();
        int sizeInBytes = width * height;
        FFmpeg.avframe_set_data(this.avFrame, this.rawFrameBuffer, sizeInBytes, sizeInBytes / 4);
        FFmpeg.avframe_set_linesize(this.avFrame, width, width / 2, width / 2);
        if (this.keyFrameRequestee == null) {
            this.keyFrameRequestee = new KeyFrameControl.KeyFrameRequestee(){

                public boolean keyFrameRequest() {
                    return JNIEncoder.this.keyFrameRequest();
                }
            };
        }
        if (this.keyFrameControl != null) {
            this.keyFrameControl.addKeyFrameRequestee(-1, this.keyFrameRequestee);
        }
        this.opened = true;
        super.open();
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        byte[] out;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.equals((Object)this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if (inBuffer.getLength() < 10) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        FFmpeg.memcpy(this.rawFrameBuffer, (byte[])inBuffer.getData(), inBuffer.getOffset(), this.rawFrameLen);
        if (this.forceKeyFrame) {
            FFmpeg.avframe_set_key_frame(this.avFrame, true);
            this.framesSinceLastIFrame = 0;
            if (this.secondKeyFrame) {
                this.secondKeyFrame = false;
                this.forceKeyFrame = true;
            } else {
                this.forceKeyFrame = false;
            }
        } else {
            ++this.framesSinceLastIFrame;
            FFmpeg.avframe_set_key_frame(this.avFrame, false);
        }
        Object outData = outBuffer.getData();
        if (outData instanceof byte[]) {
            out = (byte[])outData;
            if (out.length < this.rawFrameLen) {
                out = null;
            }
        } else {
            out = null;
        }
        if (out == null) {
            out = new byte[this.rawFrameLen];
            outBuffer.setData((Object)out);
        }
        int outputLength = FFmpeg.avcodec_encode_video(this.avctx, out, out.length, this.avFrame);
        outBuffer.setLength(outputLength);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    @Override
    public void rtcpFeedbackReceived(RTCPFeedbackEvent event) {
        if (event.getPayloadType() == 206) {
            switch (event.getFeedbackMessageType()) {
                case 1: 
                case 4: {
                    this.keyFrameRequest();
                    break;
                }
            }
        }
    }

    public void setAdditionalCodecSettings(Map<String, String> settings) {
        this.additionalSettings = settings;
    }

    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.inputFormats)) {
            return null;
        }
        YUVFormat yuvFormat = (YUVFormat)format;
        if (yuvFormat.getOffsetU() > yuvFormat.getOffsetV()) {
            return null;
        }
        this.inputFormat = AbstractCodec2.specialize(yuvFormat, Format.byteArray);
        return this.inputFormat;
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        if (this.keyFrameControl != keyFrameControl) {
            if (this.keyFrameControl != null && this.keyFrameRequestee != null) {
                this.keyFrameControl.removeKeyFrameRequestee(this.keyFrameRequestee);
            }
            this.keyFrameControl = keyFrameControl;
            if (this.keyFrameControl != null && this.keyFrameRequestee != null) {
                this.keyFrameControl.addKeyFrameRequestee(-1, this.keyFrameRequestee);
            }
        }
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        Map<String, String> fmtps = null;
        if (format instanceof ParameterizedVideoFormat) {
            fmtps = ((ParameterizedVideoFormat)format).getFormatParameters();
        }
        if (fmtps == null) {
            fmtps = new HashMap<String, String>();
        }
        if (this.packetizationMode != null) {
            fmtps.put(PACKETIZATION_MODE_FMTP, this.packetizationMode);
        }
        this.outputFormat = new ParameterizedVideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate(), fmtps);
        return this.outputFormat;
    }

    public void setPacketizationMode(String packetizationMode) {
        if (packetizationMode == null || "0".equals(packetizationMode)) {
            this.packetizationMode = "0";
        } else if ("1".equals(packetizationMode)) {
            this.packetizationMode = "1";
        } else {
            throw new IllegalArgumentException("packetizationMode");
        }
    }

    private static int getProfileForConfig(String profile) {
        if (BASELINE_PROFILE.equalsIgnoreCase(profile)) {
            return 66;
        }
        if (HIGH_PROFILE.equalsIgnoreCase(profile)) {
            return 100;
        }
        return 77;
    }
}

