/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.util.Arrays;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_SILK_SDK_DecControlStruct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_TOC_struct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_control;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_state;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_create_init_destroy;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_decode_frame;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_decode_parameters;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_range_coder;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_resampler;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_typedef;

public class Silk_dec_API {
    static int SKP_Silk_SDK_InitDecoder(Object decState) {
        int ret = 0;
        SKP_Silk_decoder_state struc = (SKP_Silk_decoder_state)decState;
        ret = Silk_create_init_destroy.SKP_Silk_init_decoder(struc);
        return ret;
    }

    static int SKP_Silk_SDK_Decode(Object decState, SKP_SILK_SDK_DecControlStruct decControl, int lostFlag, byte[] inData, int inData_offset, int nBytesIn, short[] samplesOut, int samplesOut_offset, short[] nSamplesOut) {
        int ret = 0;
        SKP_Silk_decoder_state psDec = (SKP_Silk_decoder_state)decState;
        if (psDec.moreInternalDecoderFrames == 0) {
            psDec.nFramesDecoded = 0;
        }
        if (psDec.moreInternalDecoderFrames == 0 && lostFlag == 0 && nBytesIn > 1024) {
            lostFlag = 1;
            ret = -11;
        }
        int prev_fs_kHz = psDec.fs_kHz;
        int[] used_bytes_ptr = new int[1];
        ret += Silk_decode_frame.SKP_Silk_decode_frame(psDec, samplesOut, samplesOut_offset, nSamplesOut, inData, inData_offset, nBytesIn, lostFlag, used_bytes_ptr);
        int used_bytes = used_bytes_ptr[0];
        if (used_bytes != 0) {
            if (psDec.nBytesLeft > 0 && psDec.FrameTermination == 1 && psDec.nFramesDecoded < 5) {
                psDec.moreInternalDecoderFrames = 1;
            } else {
                psDec.moreInternalDecoderFrames = 0;
                psDec.nFramesInPacket = psDec.nFramesDecoded;
                if (psDec.vadFlag == 1) {
                    if (psDec.FrameTermination == 0) {
                        ++psDec.no_FEC_counter;
                        if (psDec.no_FEC_counter > 10) {
                            psDec.inband_FEC_offset = 0;
                        }
                    } else if (psDec.FrameTermination == 2) {
                        psDec.inband_FEC_offset = 1;
                        psDec.no_FEC_counter = 0;
                    } else if (psDec.FrameTermination == 3) {
                        psDec.inband_FEC_offset = 2;
                        psDec.no_FEC_counter = 0;
                    }
                }
            }
        }
        if (48000 < decControl.API_sampleRate || 8000 > decControl.API_sampleRate) {
            ret = -10;
            return ret;
        }
        if (psDec.fs_kHz * 1000 != decControl.API_sampleRate) {
            short[] samplesOut_tmp = new short[960];
            Silk_typedef.SKP_assert(psDec.fs_kHz <= 48);
            System.arraycopy(samplesOut, samplesOut_offset + 0, samplesOut_tmp, 0, nSamplesOut[0]);
            if (prev_fs_kHz != psDec.fs_kHz || psDec.prev_API_sampleRate != decControl.API_sampleRate) {
                ret = Silk_resampler.SKP_Silk_resampler_init(psDec.resampler_state, psDec.fs_kHz * 1000, decControl.API_sampleRate);
            }
            ret += Silk_resampler.SKP_Silk_resampler(psDec.resampler_state, samplesOut, samplesOut_offset, samplesOut_tmp, 0, nSamplesOut[0]);
            nSamplesOut[0] = (short)(nSamplesOut[0] * decControl.API_sampleRate / (psDec.fs_kHz * 1000));
        }
        psDec.prev_API_sampleRate = decControl.API_sampleRate;
        decControl.frameSize = psDec.frame_length;
        decControl.framesPerPacket = psDec.nFramesInPacket;
        decControl.inBandFECOffset = psDec.inband_FEC_offset;
        decControl.moreInternalDecoderFrames = psDec.moreInternalDecoderFrames;
        return ret;
    }

    static void SKP_Silk_SDK_search_for_LBRR(byte[] inData, int inData_offset, short nBytesIn, int lost_offset, byte[] LBRRData, int LBRRData_offset, short[] nLBRRBytes) {
        block5: {
            SKP_Silk_decoder_state sDec = new SKP_Silk_decoder_state();
            SKP_Silk_decoder_control sDecCtrl = new SKP_Silk_decoder_control();
            int[] TempQ = new int[480];
            if (lost_offset < 1 || lost_offset > 2) {
                nLBRRBytes[0] = 0;
                return;
            }
            sDec.nFramesDecoded = 0;
            sDec.fs_kHz = 0;
            Arrays.fill(sDec.prevNLSF_Q15, 0, 16, 0);
            for (int i = 0; i < 16; ++i) {
                sDec.prevNLSF_Q15[i] = 0;
            }
            Silk_range_coder.SKP_Silk_range_dec_init(sDec.sRC, inData, inData_offset, nBytesIn);
            while (true) {
                Silk_decode_parameters.SKP_Silk_decode_parameters(sDec, sDecCtrl, TempQ, 0);
                if (sDec.sRC.error != 0) {
                    nLBRRBytes[0] = 0;
                    return;
                }
                if ((sDec.FrameTermination - 1 & lost_offset) != 0 && sDec.FrameTermination > 0 && sDec.nBytesLeft >= 0) {
                    nLBRRBytes[0] = (short)sDec.nBytesLeft;
                    System.arraycopy(inData, inData_offset + nBytesIn - sDec.nBytesLeft, LBRRData, LBRRData_offset + 0, sDec.nBytesLeft);
                    break block5;
                }
                if (sDec.nBytesLeft <= 0 || sDec.FrameTermination != 1) break;
                ++sDec.nFramesDecoded;
            }
            LBRRData = null;
            nLBRRBytes[0] = 0;
        }
    }

    static void SKP_Silk_SDK_get_TOC(byte[] inData, short nBytesIn, SKP_Silk_TOC_struct Silk_TOC) {
        SKP_Silk_decoder_state sDec = new SKP_Silk_decoder_state();
        SKP_Silk_decoder_control sDecCtrl = new SKP_Silk_decoder_control();
        int[] TempQ = new int[480];
        sDec.nFramesDecoded = 0;
        sDec.fs_kHz = 0;
        Silk_range_coder.SKP_Silk_range_dec_init(sDec.sRC, inData, 0, nBytesIn);
        Silk_TOC.corrupt = 0;
        while (true) {
            Silk_decode_parameters.SKP_Silk_decode_parameters(sDec, sDecCtrl, TempQ, 0);
            Silk_TOC.vadFlags[sDec.nFramesDecoded] = sDec.vadFlag;
            Silk_TOC.sigtypeFlags[sDec.nFramesDecoded] = sDecCtrl.sigtype;
            if (sDec.sRC.error != 0) {
                Silk_TOC.corrupt = 1;
                break;
            }
            if (sDec.nBytesLeft <= 0 || sDec.FrameTermination != 1) break;
            ++sDec.nFramesDecoded;
        }
        if (Silk_TOC.corrupt != 0 || sDec.FrameTermination == 1 || sDec.nFramesInPacket > 5) {
            int i;
            Silk_TOC.corrupt = 0;
            Silk_TOC.framesInPacket = 0;
            Silk_TOC.fs_kHz = 0;
            Silk_TOC.inbandLBRR = 0;
            for (i = 0; i < Silk_TOC.vadFlags.length; ++i) {
                Silk_TOC.vadFlags[i] = 0;
            }
            for (i = 0; i < Silk_TOC.sigtypeFlags.length; ++i) {
                Silk_TOC.sigtypeFlags[i] = 0;
            }
            Silk_TOC.corrupt = 1;
        } else {
            Silk_TOC.framesInPacket = sDec.nFramesDecoded + 1;
            Silk_TOC.fs_kHz = sDec.fs_kHz;
            Silk_TOC.inbandLBRR = sDec.FrameTermination == 0 ? sDec.FrameTermination : sDec.FrameTermination - 1;
        }
    }

    static String SKP_Silk_SDK_get_version() {
        String version = "1.0.6";
        return version;
    }
}

