/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.util.Arrays;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_CNG_struct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_control;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_state;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_LPC_synthesis_filter;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_LPC_synthesis_order16;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_NLSF2A_stable;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_SigProc_FIX;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_macros;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_typedef;

public class Silk_CNG {
    static void SKP_Silk_CNG_exc(short[] residual, int residual_offset, int[] exc_buf_Q10, int exc_buf_Q10_offset, int Gain_Q16, int length, int[] rand_seed) {
        int exc_mask;
        for (exc_mask = 255; exc_mask > length; exc_mask >>= 1) {
        }
        int seed = rand_seed[0];
        for (int i = 0; i < length; ++i) {
            int idx = (seed = Silk_SigProc_FIX.SKP_RAND(seed)) >> 24 & exc_mask;
            Silk_typedef.SKP_assert(idx >= 0);
            Silk_typedef.SKP_assert(idx <= 255);
            residual[residual_offset + i] = (short)Silk_SigProc_FIX.SKP_SAT16(Silk_SigProc_FIX.SKP_RSHIFT_ROUND(Silk_macros.SKP_SMULWW(exc_buf_Q10[idx], Gain_Q16), 10));
        }
        rand_seed[0] = seed;
    }

    static void SKP_Silk_CNG_Reset(SKP_Silk_decoder_state psDec) {
        int NLSF_step_Q15 = Short.MAX_VALUE / (psDec.LPC_order + 1);
        int NLSF_acc_Q15 = 0;
        for (int i = 0; i < psDec.LPC_order; ++i) {
            psDec.sCNG.CNG_smth_NLSF_Q15[i] = NLSF_acc_Q15 += NLSF_step_Q15;
        }
        psDec.sCNG.CNG_smth_Gain_Q16 = 0;
        psDec.sCNG.rand_seed = 3176576;
    }

    static void SKP_Silk_CNG(SKP_Silk_decoder_state psDec, SKP_Silk_decoder_control psDecCtrl, short[] signal, int signal_offset, int length) {
        int i;
        short[] LPC_buf = new short[16];
        short[] CNG_sig = new short[480];
        SKP_Silk_CNG_struct psCNG = psDec.sCNG;
        if (psDec.fs_kHz != psCNG.fs_kHz) {
            Silk_CNG.SKP_Silk_CNG_Reset(psDec);
            psCNG.fs_kHz = psDec.fs_kHz;
        }
        if (psDec.lossCnt == 0 && psDec.vadFlag == 0) {
            for (i = 0; i < psDec.LPC_order; ++i) {
                int n = i;
                psCNG.CNG_smth_NLSF_Q15[n] = psCNG.CNG_smth_NLSF_Q15[n] + Silk_macros.SKP_SMULWB(psDec.prevNLSF_Q15[i] - psCNG.CNG_smth_NLSF_Q15[i], 16348);
            }
            int max_Gain_Q16 = 0;
            int subfr = 0;
            for (i = 0; i < 4; ++i) {
                if (psDecCtrl.Gains_Q16[i] <= max_Gain_Q16) continue;
                max_Gain_Q16 = psDecCtrl.Gains_Q16[i];
                subfr = i;
            }
            System.arraycopy(psCNG.CNG_exc_buf_Q10, 0, psCNG.CNG_exc_buf_Q10, psDec.subfr_length, 3 * psDec.subfr_length);
            System.arraycopy(psDec.exc_Q10, subfr * psDec.subfr_length, psCNG.CNG_exc_buf_Q10, 0, psDec.subfr_length);
            for (i = 0; i < 4; ++i) {
                psCNG.CNG_smth_Gain_Q16 += Silk_macros.SKP_SMULWB(psDecCtrl.Gains_Q16[i] - psCNG.CNG_smth_Gain_Q16, 4634);
            }
        }
        if (psDec.lossCnt != 0) {
            int[] psCNG_rand_seed_ptr = new int[]{psCNG.rand_seed};
            Silk_CNG.SKP_Silk_CNG_exc(CNG_sig, 0, psCNG.CNG_exc_buf_Q10, 0, psCNG.CNG_smth_Gain_Q16, length, psCNG_rand_seed_ptr);
            psCNG.rand_seed = psCNG_rand_seed_ptr[0];
            Silk_NLSF2A_stable.SKP_Silk_NLSF2A_stable(LPC_buf, psCNG.CNG_smth_NLSF_Q15, psDec.LPC_order);
            int Gain_Q26 = 0x4000000;
            if (psDec.LPC_order == 16) {
                Silk_LPC_synthesis_order16.SKP_Silk_LPC_synthesis_order16(CNG_sig, LPC_buf, Gain_Q26, psCNG.CNG_synth_state, CNG_sig, length);
            } else {
                Silk_LPC_synthesis_filter.SKP_Silk_LPC_synthesis_filter(CNG_sig, LPC_buf, Gain_Q26, psCNG.CNG_synth_state, CNG_sig, length, psDec.LPC_order);
            }
            for (i = 0; i < length; ++i) {
                int tmp_32 = signal[signal_offset + i] + CNG_sig[i];
                signal[signal_offset + i] = (short)Silk_SigProc_FIX.SKP_SAT16(tmp_32);
            }
        } else {
            Arrays.fill(psCNG.CNG_synth_state, 0, psDec.LPC_order, 0);
        }
    }
}

