/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.utils.ZrtpUtils;
import java.util.EnumSet;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.ZrtpConfigureUtils;
import org.jitsi.impl.neomedia.transform.zrtp.SecurityEventManager;
import org.jitsi.impl.neomedia.transform.zrtp.ZRTPTransformEngine;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.neomedia.event.SrtpListener;

public class ZrtpControlImpl
implements ZrtpControl {
    private SrtpListener zrtpListener = null;
    private ZRTPTransformEngine zrtpEngine = null;
    private AbstractRTPConnector zrtpConnector = null;
    private boolean masterSession = false;

    ZrtpControlImpl() {
    }

    public void cleanup() {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.stopZrtp();
            this.zrtpEngine.cleanup();
        }
        this.zrtpEngine = null;
        this.zrtpConnector = null;
    }

    public void setSrtpListener(SrtpListener zrtpListener) {
        this.zrtpListener = zrtpListener;
    }

    public SrtpListener getSrtpListener() {
        return this.zrtpListener;
    }

    public boolean getSecureCommunicationStatus() {
        return this.zrtpEngine != null && this.zrtpEngine.getSecureCommunicationStatus();
    }

    public void setSASVerification(boolean verified) {
        ZRTPTransformEngine engine = this.getTransformEngine();
        if (verified) {
            engine.SASVerified();
        } else {
            engine.resetSASVerified();
        }
    }

    public ZRTPTransformEngine getTransformEngine() {
        if (this.zrtpEngine == null) {
            this.zrtpEngine = new ZRTPTransformEngine();
            this.zrtpEngine.initialize("GNUZRTP4J.zid", false, ZrtpConfigureUtils.getZrtpConfiguration());
            this.zrtpEngine.setUserCallback(new SecurityEventManager(this));
        }
        return this.zrtpEngine;
    }

    public void setMasterSession(boolean masterSession) {
        if (masterSession) {
            this.masterSession = masterSession;
        }
    }

    public void start(MediaType mediaType) {
        boolean zrtpAutoStart;
        ZRTPTransformEngine engine = this.getTransformEngine();
        SecurityEventManager securityEventManager = engine.getUserCallback();
        if (this.masterSession) {
            zrtpAutoStart = true;
            securityEventManager.setDHSession(true);
            securityEventManager.setSessionType(mediaType.equals((Object)MediaType.AUDIO) ? 1 : 2);
        } else {
            zrtpAutoStart = this.zrtpEngine.isEnableZrtp();
            securityEventManager.setSessionType(mediaType.equals((Object)MediaType.AUDIO) ? 1 : 2);
        }
        engine.setConnector(this.zrtpConnector);
        securityEventManager.setSrtpListener(this.zrtpListener);
        engine.setEnableZrtp(zrtpAutoStart);
        engine.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZRTPCustomInfoCodes.ZRTPEnabledByDefault));
    }

    public void setMultistream(SrtpControl master) {
        if (master == null || master == this) {
            return;
        }
        if (!(master instanceof ZrtpControlImpl)) {
            throw new IllegalArgumentException("master is no ZRTP control");
        }
        ZRTPTransformEngine engine = this.getTransformEngine();
        engine.setMultiStrParams(((ZrtpControlImpl)master).getTransformEngine().getMultiStrParams());
        engine.setEnableZrtp(true);
    }

    public String getHelloHash(int index) {
        return this.getTransformEngine().getHelloHash(index);
    }

    public String[] getHelloHashSep(int index) {
        return this.getTransformEngine().getHelloHashSep(index);
    }

    public String getPeerHelloHash() {
        if (this.zrtpEngine != null) {
            return this.zrtpEngine.getPeerHelloHash();
        }
        return new String();
    }

    public int getNumberSupportedVersions() {
        return this.zrtpEngine != null ? this.zrtpEngine.getNumberSupportedVersions() : 0;
    }

    public int getCurrentProtocolVersion() {
        return this.zrtpEngine != null ? this.zrtpEngine.getCurrentProtocolVersion() : 0;
    }

    public void setConnector(AbstractRTPConnector connector) {
        this.zrtpConnector = connector;
    }

    public String getSecurityString() {
        return this.getTransformEngine().getUserCallback().getSecurityString();
    }

    public String getCipherString() {
        return this.getTransformEngine().getUserCallback().getCipherString();
    }

    public boolean isSecurityVerified() {
        return this.getTransformEngine().getUserCallback().isSecurityVerified();
    }

    public byte[] getPeerZid() {
        return this.getTransformEngine().getPeerZid();
    }

    public String getPeerZidString() {
        byte[] zid = this.getPeerZid();
        String s = new String(ZrtpUtils.bytesToHexString((byte[])zid, (int)zid.length));
        return s;
    }

    public boolean requiresSecureSignalingTransport() {
        return false;
    }

    public long getTimeoutValue() {
        return 3750L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZRTPCustomInfoCodes {
        ZRTPNotEnabledByUser,
        ZRTPDisabledByCallEnd,
        ZRTPEngineInitFailure,
        ZRTPEnabledByDefault;

    }
}

