/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import gnu.java.zrtp.ZrtpConfigure;
import gnu.java.zrtp.ZrtpConstants;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZrtpConfigureUtils {
    public static <T extends Enum<T>> String getPropertyID(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        return "net.java.sip.communicator." + clazz.getName().replace('$', '_');
    }

    public static ZrtpConfigure getZrtpConfiguration() {
        ZrtpConfigure active = new ZrtpConfigure();
        ZrtpConfigureUtils.setupConfigure(ZrtpConstants.SupportedPubKeys.DH2K, active);
        ZrtpConfigureUtils.setupConfigure(ZrtpConstants.SupportedHashes.S256, active);
        ZrtpConfigureUtils.setupConfigure(ZrtpConstants.SupportedSymCiphers.AES1, active);
        ZrtpConfigureUtils.setupConfigure(ZrtpConstants.SupportedSASTypes.B32, active);
        ZrtpConfigureUtils.setupConfigure(ZrtpConstants.SupportedAuthLengths.HS32, active);
        return active;
    }

    private static <T extends Enum<T>> void setupConfigure(T algo, ZrtpConfigure active) {
        String[] savedAlgos;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String savedConf = null;
        if (cfg != null) {
            String id = ZrtpConfigureUtils.getPropertyID(algo);
            savedConf = cfg.getString(id);
        }
        if (savedConf == null) {
            savedConf = "";
        }
        Class<T> clazz = algo.getDeclaringClass();
        for (String str : savedAlgos = savedConf.split(";")) {
            try {
                T algoEnum = Enum.valueOf(clazz, str);
                if (algoEnum == null) continue;
                active.addAlgo(algoEnum);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }
}

