/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import org.jitsi.impl.neomedia.AbstractVolumeControl;
import org.jitsi.impl.neomedia.CoreAudioDevice;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.util.Logger;

public class HardwareVolumeControl
extends AbstractVolumeControl {
    private static final Logger logger = Logger.getLogger(HardwareVolumeControl.class);
    MediaServiceImpl mediaServiceImpl = null;
    private static final float MAX_HARDWARE_POWER = 1.0f;

    public HardwareVolumeControl(MediaServiceImpl mediaServiceImpl, String volumeLevelConfigurationPropertyName) {
        super(volumeLevelConfigurationPropertyName);
        this.mediaServiceImpl = mediaServiceImpl;
        this.volumeLevel = HardwareVolumeControl.getDefaultVolumeLevel();
        float volume = this.getVolume();
        if (volume != -1.0f) {
            this.volumeLevel = volume;
        }
    }

    protected static float getDefaultVolumeLevel() {
        return 0.5f;
    }

    protected static float getGainReferenceLevel() {
        return 1.0f;
    }

    protected void updateHardwareVolume() {
        String deviceUID = this.getCaptureDeviceUID();
        float jitsiHarwareVolumeFactor = 1.0f;
        float hardwareVolumeLevel = this.volumeLevel * jitsiHarwareVolumeFactor;
        if (hardwareVolumeLevel > 1.0f) {
            hardwareVolumeLevel = 1.0f;
        }
        if (this.setInputDeviceVolume(deviceUID, hardwareVolumeLevel) != 0) {
            logger.debug("Could not change hardware input device level");
        }
    }

    protected String getCaptureDeviceUID() {
        AudioSystem audioSystem = this.mediaServiceImpl.getDeviceConfiguration().getAudioSystem();
        CaptureDeviceInfo2 captureDevice = audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.CAPTURE);
        return captureDevice == null ? null : captureDevice.getUID();
    }

    protected int setInputDeviceVolume(String deviceUID, float volume) {
        if (deviceUID == null) {
            return -1;
        }
        if (CoreAudioDevice.initDevices() == -1) {
            CoreAudioDevice.freeDevices();
            logger.debug("Could not initialize CoreAudio input devices");
            return -1;
        }
        if (CoreAudioDevice.setInputDeviceVolume(deviceUID, volume) != 0) {
            CoreAudioDevice.freeDevices();
            logger.debug("Could not change CoreAudio input device level");
            return -1;
        }
        CoreAudioDevice.freeDevices();
        return 0;
    }

    protected float getInputDeviceVolume(String deviceUID) {
        if (deviceUID == null) {
            return -1.0f;
        }
        if (CoreAudioDevice.initDevices() == -1) {
            CoreAudioDevice.freeDevices();
            logger.debug("Could not initialize CoreAudio input devices");
            return -1.0f;
        }
        float volume = CoreAudioDevice.getInputDeviceVolume(deviceUID);
        if (volume == -1.0f) {
            CoreAudioDevice.freeDevices();
            logger.debug("Could not get CoreAudio input device level");
            return -1.0f;
        }
        CoreAudioDevice.freeDevices();
        return volume;
    }

    public float getVolume() {
        String deviceUID = this.getCaptureDeviceUID();
        return this.getInputDeviceVolume(deviceUID);
    }
}

